/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.core;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.CityObjectProcessor;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.gml.GMLUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.util.AffineTransform;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AddressType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.cityjson.geometry.GeometryTemplatesType;
import org.citygml4j.cityjson.geometry.MultiPointType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.cityjson.metadata.MetadataType;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.geometry.Point;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroup;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.Address;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.citygml.core.CityObjectMember;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.TransformationMatrix4x4;
import org.citygml4j.model.citygml.core.XalAddressProperty;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.base.StringOrRef;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.FeatureMember;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiPoint;
import org.citygml4j.model.gml.geometry.aggregates.MultiPointProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurveSegment;
import org.citygml4j.model.gml.geometry.primitives.Curve;
import org.citygml4j.model.gml.geometry.primitives.CurveSegmentArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.Envelope;
import org.citygml4j.model.gml.geometry.primitives.LineString;
import org.citygml4j.model.gml.geometry.primitives.LineStringSegment;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.xal.AddressDetails;
import org.citygml4j.model.xal.Country;
import org.citygml4j.model.xal.CountryName;
import org.citygml4j.model.xal.Locality;
import org.citygml4j.model.xal.LocalityName;
import org.citygml4j.model.xal.PostalCode;
import org.citygml4j.model.xal.PostalCodeNumber;
import org.citygml4j.model.xal.Thoroughfare;
import org.citygml4j.model.xal.ThoroughfareName;
import org.citygml4j.model.xal.ThoroughfareNumber;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.walker.FeatureWalker;
import org.citygml4j.util.walker.GeometryWalker;

public class CoreUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;
    private final GMLUnmarshaller implicit;
    private List<AbstractGeometryObjectType> templates;
    private ConcurrentHashMap<Integer, AbstractMap.SimpleEntry<String, Integer>> templateInfos;
    private AbstractCityObject appearanceContainer;
    private GMLIdManager gmlIdManager;
    private final String UNMARSHAL_AS_GLOBAL_FEATURE = "org.citygml4j.unmarshal.asGlobalFeature";
    private final String GLOBAL_FEATURES = "org.citygml4j.unmarshal.globalFeature";

    public CoreUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
        this.implicit = new GMLUnmarshaller(this.json);
    }

    public void setGeometryTemplatesInfo(GeometryTemplatesType geometryTemplates) {
        this.templates = geometryTemplates.getTemplates();
        this.implicit.setVertices(geometryTemplates.getTemplatesVertices());
        this.templateInfos = new ConcurrentHashMap();
        this.appearanceContainer = new GenericCityObject();
        this.gmlIdManager = DefaultGMLIdManager.getInstance();
    }

    public void unmarshalAbstractCityObject(AbstractCityObjectType src, AbstractCityObject dest, CityJSON cityJSON) {
        dest.setId(src.getGmlId());
        if (src.isSetGeographicalExtent()) {
            List bbox = src.getGeographicalExtent();
            Envelope envelope = new Envelope();
            envelope.setLowerCorner(new Point((Double)bbox.get(0), (Double)bbox.get(1), (Double)bbox.get(2)));
            envelope.setUpperCorner(new Point((Double)bbox.get(3), (Double)bbox.get(4), (Double)bbox.get(5)));
            envelope.setSrsDimension(3);
            dest.setBoundedBy(new BoundingShape(envelope));
        }
        if (src.isSetExtensionProperties()) {
            for (Map.Entry entry : src.getExtensionProperties().entrySet()) {
                if (this.json.getCityJSONRegistry().hasExtensionProperty((String)entry.getKey(), (ExtensibleType)src)) {
                    this.json.getADEUnmarshaller().unmarshalExtensionProperty((String)entry.getKey(), entry.getValue(), (ExtensibleType)src, cityJSON, dest);
                    continue;
                }
                this.citygml.getGenericsUnmarshaller().unmarshalGenericAttribute((String)entry.getKey(), entry.getValue(), dest);
            }
        }
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetDescription()) {
                dest.setDescription(new StringOrRef(attributes.getDescription()));
            }
            if (attributes.isSetName()) {
                dest.addName(new Code(attributes.getName()));
            }
            if (attributes.isSetCreationDate()) {
                dest.setCreationDate(attributes.getCreationDate());
            }
            if (attributes.isSetTerminationDate()) {
                dest.setTerminationDate(attributes.getTerminationDate());
            }
            if (attributes.isSetExtensionAttributes()) {
                for (Map.Entry entry : attributes.getExtensionAttributes().entrySet()) {
                    if (this.json.getCityJSONRegistry().hasExtensionProperty((String)entry.getKey(), (ExtensibleType)src)) {
                        this.json.getADEUnmarshaller().unmarshalExtensionProperty((String)entry.getKey(), entry.getValue(), (ExtensibleType)src, cityJSON, dest);
                        continue;
                    }
                    this.citygml.getGenericsUnmarshaller().unmarshalGenericAttribute((String)entry.getKey(), entry.getValue(), dest);
                }
            }
        }
        if (src.isSetChildren()) {
            for (String string : src.getChildren()) {
                AbstractFeature feature;
                AbstractCityObjectType abstractCityObjectType = cityJSON.getCityObject(string);
                if (abstractCityObjectType == null || this.json.getCityJSONRegistry().isCoreCityObject(abstractCityObjectType.getType()) || (feature = this.json.getADEUnmarshaller().unmarshalCityObject(abstractCityObjectType, cityJSON, dest)) == null) continue;
                if (feature.hasLocalProperty("org.citygml4j.unmarshal.asGlobalFeature")) {
                    ArrayList<AbstractFeature> features = (ArrayList<AbstractFeature>)dest.getLocalProperty("org.citygml4j.unmarshal.globalFeature");
                    if (features == null) {
                        features = new ArrayList<AbstractFeature>();
                        dest.setLocalProperty("org.citygml4j.unmarshal.globalFeature", features);
                    }
                    features.add(feature);
                }
                if (!feature.hasLocalProperty("org.citygml4j.unknownExtension")) continue;
                String type = abstractCityObjectType.getType();
                if (type.startsWith("+")) {
                    type = type.substring(1);
                }
                dest.addGenericAttribute(new StringAttribute(type, feature.getId()));
            }
        }
    }

    public void unmarshalCityModel(CityJSON src, CityModel dest, CityObjectProcessor processor) throws Exception {
        Object bbox;
        MetadataType metadata;
        if (src.isSetExtensionProperties()) {
            for (Map.Entry entry : src.getExtensionProperties().entrySet()) {
                if (!this.json.getCityJSONRegistry().hasExtensionProperty((String)entry.getKey(), (ExtensibleType)src)) continue;
                this.json.getADEUnmarshaller().unmarshalExtensionProperty((String)entry.getKey(), entry.getValue(), (ExtensibleType)src, src, dest);
            }
        }
        if (src.isSetMetadata() && (metadata = src.getMetadata()).isSetGeographicalExtent() && (bbox = metadata.getGeographicalExtent()).size() > 5) {
            BoundingShape boundedBy = new BoundingShape(new BoundingBox(new Point((Double)bbox.get(0), (Double)bbox.get(1), (Double)bbox.get(2)), new Point((Double)bbox.get(3), (Double)bbox.get(4), (Double)bbox.get(5))));
            if (metadata.isSetReferenceSystem()) {
                boundedBy.getEnvelope().setSrsName(metadata.getReferenceSystem());
            }
            dest.setBoundedBy(boundedBy);
        }
        Set topLevel = Collections.newSetFromMap(new IdentityHashMap());
        for (AbstractCityObjectType type : src.getCityObjects()) {
            if (type.isSetParents()) continue;
            topLevel.add(type);
        }
        Iterator iter = topLevel.iterator();
        while (iter.hasNext()) {
            AbstractFeature cityObject;
            AbstractCityObjectType type;
            type = (AbstractCityObjectType)iter.next();
            if (!this.json.getCityJSONRegistry().isCoreCityObject(type.getType())) {
                cityObject = this.json.getADEUnmarshaller().unmarshalCityObject(type, src, dest);
                if (cityObject == null || !cityObject.hasLocalProperty("org.citygml4j.unmarshal.asGlobalFeature")) {
                    continue;
                }
            } else {
                cityObject = this.citygml.unmarshal(type, src);
            }
            if (!this.json.isSetCityGMLNameFilter() || this.satisfiesCityGMLNameFilter(cityObject)) {
                processor.process(cityObject);
            }
            if (cityObject.hasLocalProperty("org.citygml4j.unmarshal.globalFeature")) {
                for (AbstractFeature feature : (List)cityObject.getLocalProperty("org.citygml4j.unmarshal.globalFeature")) {
                    if (this.json.isSetCityGMLNameFilter() && !this.satisfiesCityGMLNameFilter(feature)) continue;
                    processor.process(feature);
                }
                cityObject.unsetLocalProperty("org.citygml4j.unmarshal.globalFeature");
            }
            if (this.json.isReleaseCityJSONContent()) {
                this.releaseObjectHierarchy(type, src);
                src.removeCityObject(type.getGmlId());
            }
            iter.remove();
        }
    }

    public CityModel unmarshalCityModel(CityJSON src) {
        final CityModel dest = new CityModel();
        try {
            this.unmarshalCityModel(src, dest, feature -> {
                if (feature instanceof AbstractCityObject) {
                    dest.addCityObjectMember(new CityObjectMember((AbstractCityObject)feature));
                } else {
                    dest.addFeatureMember(new FeatureMember(feature));
                }
            });
            dest.accept(new FeatureWalker(){

                @Override
                public void visit(CityObjectGroup group) {
                    CoreUnmarshaller.this.citygml.getCiyCityObjectGroupUnmarshaller().postprocessGroupMembers(group, dest);
                }
            });
            if (!dest.isSetCityObjectMember() && !dest.isSetFeatureMember()) {
                dest.unsetBoundedBy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dest;
    }

    public void unmarshalAsGlobalFeature(AbstractFeature feature) {
        feature.setLocalProperty("org.citygml4j.unmarshal.asGlobalFeature", true);
    }

    public void unmarshalGeometryInstance(GeometryInstanceType src, ImplicitGeometry dest) {
        AbstractMap.SimpleEntry<String, Integer> templateInfo = this.templateInfos.get(src.getTemplate());
        GeometryProperty<AbstractGeometry> property = new GeometryProperty<AbstractGeometry>();
        if (templateInfo == null) {
            AbstractGeometryObjectType template;
            AbstractGeometry geometry;
            if (this.templates != null && this.templates.size() > src.getTemplate() && (geometry = this.implicit.unmarshal(template = this.templates.get(src.getTemplate()), this.appearanceContainer)) != null) {
                geometry.setId(this.gmlIdManager.generateUUID());
                property.setGeometry(geometry);
                dest.setLocalProperty("org.citygml4j.implicitGeometry.lod", template.getLod().intValue());
                this.templateInfos.putIfAbsent(src.getTemplate(), new AbstractMap.SimpleEntry<String, Integer>(geometry.getId(), template.getLod().intValue()));
            }
        } else {
            property.setHref("#" + templateInfo.getKey());
            dest.setLocalProperty("org.citygml4j.implicitGeometry.lod", templateInfo.getValue());
        }
        dest.setRelativeGeometry(property);
        List transformationMatrix = src.getTransformationMatrix();
        if (transformationMatrix != null && transformationMatrix.size() > 15) {
            Matrix matrix = new Matrix(transformationMatrix.subList(0, 16), 4);
            dest.setTransformationMatrix(new TransformationMatrix4x4(matrix));
        }
        MultiPointType referencePoint = new MultiPointType();
        referencePoint.addPoint(src.getReferencePoint());
        MultiPoint multiPoint = this.json.getGMLUnmarshaller().unmarshalMultiPoint(referencePoint);
        if (multiPoint != null) {
            dest.setReferencePoint(multiPoint.getPointMember().get(0));
        }
    }

    public ImplicitGeometry unmarshalGeometryInstance(GeometryInstanceType src) {
        ImplicitGeometry dest = new ImplicitGeometry();
        this.unmarshalGeometryInstance(src, dest);
        return dest;
    }

    public AbstractGeometry unmarshalAndTransformGeometryInstance(GeometryInstanceType src, AbstractCityObject parent) {
        if (this.templates == null || this.templates.size() <= src.getTemplate()) {
            return null;
        }
        AbstractGeometryObjectType template = this.templates.get(src.getTemplate());
        AbstractGeometry geometry = this.implicit.unmarshal(template, parent);
        if (geometry == null) {
            return null;
        }
        List transformationMatrix = src.getTransformationMatrix();
        MultiPointType referencePoint = new MultiPointType();
        referencePoint.addPoint(src.getReferencePoint());
        MultiPoint multiPoint = this.json.getGMLUnmarshaller().unmarshalMultiPoint(referencePoint);
        if (transformationMatrix == null || transformationMatrix.size() < 16 || multiPoint == null) {
            return null;
        }
        Matrix matrix = new Matrix(transformationMatrix.subList(0, 16), 4);
        List<Double> point = multiPoint.getPointMember().get(0).getPoint().toList3d();
        matrix.set(0, 3, matrix.get(0, 3) + point.get(0));
        matrix.set(1, 3, matrix.get(1, 3) + point.get(1));
        matrix.set(2, 3, matrix.get(2, 3) + point.get(2));
        final AffineTransform transformer = new AffineTransform(matrix);
        geometry.accept(new GeometryWalker(){

            @Override
            public void visit(org.citygml4j.model.gml.geometry.primitives.Point point) {
                List<Double> vertex = point.toList3d();
                if (!vertex.isEmpty()) {
                    transformer.transform(vertex);
                    point.getPos().setValue(vertex);
                }
            }

            @Override
            public void visit(LineString lineString) {
                List<Double> vertices = lineString.toList3d();
                if (!vertices.isEmpty()) {
                    transformer.transform(vertices);
                    lineString.getPosList().setValue(vertices);
                }
            }

            @Override
            public void visit(Curve curve) {
                CurveSegmentArrayProperty arrayProperty;
                if (curve.isSetSegments() && (arrayProperty = curve.getSegments()).isSetCurveSegment()) {
                    for (AbstractCurveSegment abstractCurveSegment : arrayProperty.getCurveSegment()) {
                        List<Double> vertices;
                        if (abstractCurveSegment.getGMLClass() != GMLClass.LINE_STRING_SEGMENT || (vertices = abstractCurveSegment.toList3d()).isEmpty()) continue;
                        transformer.transform(vertices);
                        ((LineStringSegment)abstractCurveSegment).getPosList().setValue(vertices);
                    }
                }
            }

            @Override
            public void visit(LinearRing linearRing) {
                List<Double> vertices = linearRing.toList3d();
                if (!vertices.isEmpty()) {
                    transformer.transform(vertices);
                    linearRing.getPosList().setValue(vertices);
                }
            }
        });
        geometry.setLocalProperty("org.citygml4j.implicitGeometry.lod", template.getLod().intValue());
        return geometry;
    }

    public void unmarshalAddress(AddressType src, Address dest) {
        AddressDetails addressDetails = new AddressDetails();
        Country country = new Country();
        if (src.isSetCountryName()) {
            country.addCountryName(new CountryName(src.getCountryName()));
        }
        Locality locality = new Locality();
        locality.setType("City");
        if (src.isSetLocalityName()) {
            locality.addLocalityName(new LocalityName(src.getLocalityName()));
        }
        if (src.isSetThoroughfareName() || src.isSetThoroughfareNumber()) {
            Thoroughfare thoroughfare = new Thoroughfare();
            thoroughfare.setType("Street");
            locality.setThoroughfare(thoroughfare);
            if (src.isSetThoroughfareName()) {
                thoroughfare.addThoroughfareName(new ThoroughfareName(src.getThoroughfareName()));
            }
            if (src.isSetThoroughfareNumber()) {
                thoroughfare.addThoroughfareNumber(new ThoroughfareNumber(src.getThoroughfareNumber()));
            }
        }
        if (src.isSetPostalCode()) {
            PostalCode postalCode = new PostalCode();
            postalCode.addPostalCodeNumber(new PostalCodeNumber(src.getPostalCode()));
            locality.setPostalCode(postalCode);
        }
        if (locality.isSetLocalityName() || locality.isSetThoroughfare() || locality.isSetPostalCode()) {
            country.setLocality(locality);
        }
        if (country.isSetCountryName() || country.isSetLocality()) {
            addressDetails.setCountry(country);
        }
        if (src.isSetLocation()) {
            dest.setMultiPoint(new MultiPointProperty(this.json.getGMLUnmarshaller().unmarshalMultiPoint(src.getLocation())));
        }
        dest.setXalAddress(new XalAddressProperty(addressDetails));
    }

    public Address unmarshalAddress(AddressType src) {
        Address dest = new Address();
        this.unmarshalAddress(src, dest);
        return dest;
    }

    public void unmarshalSemanticsAttributes(SemanticsType src, AbstractCityObject dest) {
        dest.setId(src.isSetId() ? src.getId() : DefaultGMLIdManager.getInstance().generateUUID());
        if (src.isSetDescription()) {
            dest.setDescription(new StringOrRef(src.getDescription()));
        }
        if (src.isSetName()) {
            dest.addName(new Code(src.getName()));
        }
        if (src.isSetCreationDate()) {
            dest.setCreationDate(src.getCreationDate());
        }
        if (src.isSetTerminationDate()) {
            dest.setTerminationDate(src.getTerminationDate());
        }
        if (src.isSetAttributes()) {
            this.citygml.getGenericsUnmarshaller().unmarshalGenericAttributes(src.getAttributes(), dest);
        }
    }

    public boolean hasGlobalAppearances() {
        return this.appearanceContainer != null && this.appearanceContainer.isSetAppearance() && (!this.json.isSetCityGMLNameFilter() || this.json.getCityGMLNameFilter().accept(new QName(AppearanceModule.v2_0_0.getNamespaceURI(), "Appearance")) || this.json.getCityGMLNameFilter().accept(new QName(AppearanceModule.v1_0_0.getNamespaceURI(), "Appearance")));
    }

    public List<Appearance> getGlobalAppearances() {
        List<Appearance> result;
        if (this.hasGlobalAppearances()) {
            result = this.appearanceContainer.getAppearance().stream().map(AppearanceProperty::getAppearance).collect(Collectors.toList());
            this.templates = null;
            this.templateInfos = null;
            this.appearanceContainer = null;
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private void releaseObjectHierarchy(AbstractCityObjectType parent, CityJSON src) {
        if (parent.isSetChildren()) {
            for (String gmlId : parent.getChildren()) {
                AbstractCityObjectType child = src.getCityObject(gmlId);
                if (!child.isSetParents() || child.getParents().size() != 1) continue;
                this.releaseObjectHierarchy(child, src);
                src.removeCityObject(gmlId);
            }
        }
    }

    private boolean satisfiesCityGMLNameFilter(AbstractFeature cityObject) {
        boolean accept = false;
        for (Module module : Modules.getModules()) {
            QName name;
            if (!(module instanceof CityGMLModule) && !(module instanceof ADEModule) || (name = module.getFeatureName(cityObject.getClass())) == null || !this.json.getCityGMLNameFilter().accept(name)) continue;
            accept = true;
            break;
        }
        return accept;
    }
}

