/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.tunnel;

import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractTunnelType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.TunnelAttributes;
import org.citygml4j.cityjson.feature.TunnelInstallationType;
import org.citygml4j.cityjson.feature.TunnelPartType;
import org.citygml4j.cityjson.feature.TunnelType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.citygml.tunnel.AbstractBoundarySurface;
import org.citygml4j.model.citygml.tunnel.AbstractOpening;
import org.citygml4j.model.citygml.tunnel.AbstractTunnel;
import org.citygml4j.model.citygml.tunnel.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.tunnel.ClosureSurface;
import org.citygml4j.model.citygml.tunnel.Door;
import org.citygml4j.model.citygml.tunnel.GroundSurface;
import org.citygml4j.model.citygml.tunnel.OpeningProperty;
import org.citygml4j.model.citygml.tunnel.OuterCeilingSurface;
import org.citygml4j.model.citygml.tunnel.OuterFloorSurface;
import org.citygml4j.model.citygml.tunnel.RoofSurface;
import org.citygml4j.model.citygml.tunnel.Tunnel;
import org.citygml4j.model.citygml.tunnel.TunnelInstallation;
import org.citygml4j.model.citygml.tunnel.TunnelInstallationProperty;
import org.citygml4j.model.citygml.tunnel.TunnelPart;
import org.citygml4j.model.citygml.tunnel.TunnelPartProperty;
import org.citygml4j.model.citygml.tunnel.WallSurface;
import org.citygml4j.model.citygml.tunnel.Window;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractSolid;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class TunnelUnmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> typeMapper;

    public TunnelUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(TunnelType.class, this::unmarshalTunnel).with(TunnelPartType.class, this::unmarshalTunnelPart).with(TunnelInstallationType.class, this::unmarshalTunnelInstallation);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public AbstractCityObject unmarshalSemantics(SemanticsType semanticsType, List<AbstractSurface> surfaces, Number lod, AbstractCityObject parent) {
        boolean success;
        AbstractCityObject cityObject = null;
        switch (semanticsType.getType()) {
            case "RoofSurface": {
                cityObject = this.unmarshalRoofSurface(semanticsType, surfaces, lod);
                break;
            }
            case "GroundSurface": {
                cityObject = this.unmarshalGroundSurface(semanticsType, surfaces, lod);
                break;
            }
            case "WallSurface": {
                cityObject = this.unmarshalWallSurface(semanticsType, surfaces, lod);
                break;
            }
            case "ClosureSurface": {
                cityObject = this.unmarshalClosureSurface(semanticsType, surfaces, lod);
                break;
            }
            case "OuterCeilingSurface": {
                cityObject = this.unmarshalOuterCeilingSurface(semanticsType, surfaces, lod);
                break;
            }
            case "OuterFloorSurface": {
                cityObject = this.unmarshalOuterFloorSurface(semanticsType, surfaces, lod);
                break;
            }
            case "Window": {
                cityObject = this.unmarshalWindow(semanticsType, surfaces, lod);
                break;
            }
            case "Door": {
                cityObject = this.unmarshalDoor(semanticsType, surfaces, lod);
                break;
            }
            default: {
                return null;
            }
        }
        if (parent instanceof ADEModelObject && (success = this.json.getADEUnmarshaller().assignSemanticSurface(cityObject, lod, parent))) {
            return cityObject;
        }
        if (cityObject instanceof AbstractBoundarySurface) {
            AbstractBoundarySurface boundarySurface = cityObject;
            if (parent instanceof AbstractTunnel) {
                ((AbstractTunnel)parent).addBoundedBySurface(new BoundarySurfaceProperty(boundarySurface));
            } else if (parent instanceof TunnelInstallation) {
                ((TunnelInstallation)parent).addBoundedBySurface(new BoundarySurfaceProperty(boundarySurface));
            }
        } else if (cityObject != null) {
            AbstractOpening opening = (AbstractOpening)cityObject;
            if (parent instanceof AbstractBoundarySurface) {
                ((AbstractBoundarySurface)parent).addOpening(new OpeningProperty(opening));
            } else {
                List<BoundarySurfaceProperty> boundedBy = null;
                if (parent instanceof AbstractTunnel) {
                    boundedBy = ((AbstractTunnel)parent).getBoundedBySurface();
                } else if (parent instanceof TunnelInstallation) {
                    boundedBy = ((TunnelInstallation)parent).getBoundedBySurface();
                }
                if (boundedBy != null && !boundedBy.isEmpty()) {
                    AbstractBoundarySurface boundarySurface = boundedBy.get(boundedBy.size() - 1).getBoundarySurface();
                    boundarySurface.addOpening(new OpeningProperty(opening));
                }
            }
        }
        return cityObject;
    }

    public void unmarshalAbstractTunnel(AbstractTunnelType src, AbstractTunnel dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject((AbstractCityObjectType)src, dest, cityJSON);
        if (src.isSetAttributes()) {
            TunnelAttributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
            if (attributes.isSetYearOfConstruction()) {
                dest.setYearOfConstruction(LocalDate.of((int)attributes.getYearOfConstruction(), 1, 1));
            }
            if (attributes.isSetYearOfDemolition()) {
                dest.setYearOfConstruction(LocalDate.of((int)attributes.getYearOfDemolition(), 1, 1));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGeometry geometry = null;
            int lod = 0;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                lod = geometryObject.getLod().intValue();
            } else if (geometryType instanceof GeometryInstanceType) {
                GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
                geometry = this.citygml.getCoreUnmarshaller().unmarshalAndTransformGeometryInstance(geometryInstance, dest);
                lod = (Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod");
            }
            if (geometry == null) continue;
            if (geometry instanceof MultiSurface) {
                MultiSurface multiSurface = (MultiSurface)geometry;
                switch (lod) {
                    case 1: {
                        dest.setLod1MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 2: {
                        dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 3: {
                        dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
                    }
                }
                continue;
            }
            if (!(geometry instanceof AbstractSolid)) continue;
            AbstractSolid solid = (AbstractSolid)geometry;
            switch (lod) {
                case 1: {
                    dest.setLod1Solid(new SolidProperty(solid));
                    break;
                }
                case 2: {
                    dest.setLod2Solid(new SolidProperty(solid));
                    break;
                }
                case 3: {
                    dest.setLod3Solid(new SolidProperty(solid));
                }
            }
        }
        if (src.isSetChildren()) {
            for (String gmlId : src.getChildren()) {
                AbstractCityObjectType cityObject = cityJSON.getCityObject(gmlId);
                if (cityObject == null || !this.json.getCityJSONRegistry().isCoreCityObject(cityObject.getType())) continue;
                if (cityObject instanceof TunnelInstallationType) {
                    TunnelInstallation installation = this.unmarshalTunnelInstallation((TunnelInstallationType)cityObject, cityJSON);
                    dest.addOuterTunnelInstallation(new TunnelInstallationProperty(installation));
                    continue;
                }
                if (!(cityObject instanceof TunnelPartType) || !(src instanceof TunnelType)) continue;
                TunnelPart part = this.unmarshalTunnelPart((TunnelPartType)cityObject, cityJSON);
                dest.addConsistsOfTunnelPart(new TunnelPartProperty(part));
            }
        }
    }

    public void unmarshalTunnel(TunnelType src, Tunnel dest, CityJSON cityJSON) {
        this.unmarshalAbstractTunnel((AbstractTunnelType)src, dest, cityJSON);
    }

    public Tunnel unmarshalTunnel(TunnelType src, CityJSON cityJSON) {
        Tunnel dest = new Tunnel();
        this.unmarshalTunnel(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalTunnelPart(TunnelPartType src, TunnelPart dest, CityJSON cityJSON) {
        this.unmarshalAbstractTunnel((AbstractTunnelType)src, dest, cityJSON);
    }

    public TunnelPart unmarshalTunnelPart(TunnelPartType src, CityJSON cityJSON) {
        TunnelPart dest = new TunnelPart();
        this.unmarshalTunnelPart(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalTunnelInstallation(TunnelInstallationType src, TunnelInstallation dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject((AbstractCityObjectType)src, dest, cityJSON);
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGML geometry;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                if (geometry == null) continue;
                int lod = geometryObject.getLod().intValue();
                switch (lod) {
                    case 2: {
                        dest.setLod2Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 3: {
                        dest.setLod3Geometry(new GeometryProperty<AbstractGML>(geometry));
                    }
                }
                continue;
            }
            if (!(geometryType instanceof GeometryInstanceType)) continue;
            GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
            geometry = this.citygml.getCoreUnmarshaller().unmarshalGeometryInstance(geometryInstance);
            if (geometry == null) continue;
            switch ((Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod")) {
                case 2: {
                    dest.setLod2ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 3: {
                    dest.setLod3ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                }
            }
        }
    }

    public TunnelInstallation unmarshalTunnelInstallation(TunnelInstallationType src, CityJSON cityJSON) {
        TunnelInstallation dest = new TunnelInstallation();
        this.unmarshalTunnelInstallation(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalAbstractBoundarySurface(SemanticsType src, AbstractBoundarySurface dest, List<AbstractSurface> surfaces, Number lod) {
        this.citygml.getCoreUnmarshaller().unmarshalSemanticsAttributes(src, dest);
        MultiSurface multiSurface = new MultiSurface();
        for (AbstractSurface surface : surfaces) {
            multiSurface.addSurfaceMember(new SurfaceProperty(surface));
        }
        switch (lod.intValue()) {
            case 2: {
                dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                break;
            }
            case 3: {
                dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
            }
        }
    }

    public RoofSurface unmarshalRoofSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        RoofSurface dest = new RoofSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public GroundSurface unmarshalGroundSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        GroundSurface dest = new GroundSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public WallSurface unmarshalWallSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        WallSurface dest = new WallSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public ClosureSurface unmarshalClosureSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        ClosureSurface dest = new ClosureSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public OuterCeilingSurface unmarshalOuterCeilingSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        OuterCeilingSurface dest = new OuterCeilingSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public OuterFloorSurface unmarshalOuterFloorSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        OuterFloorSurface dest = new OuterFloorSurface();
        this.unmarshalAbstractBoundarySurface(src, dest, surfaces, lod);
        return dest;
    }

    public void unmarshalAbstractOpening(SemanticsType src, AbstractOpening dest, List<AbstractSurface> surfaces, Number lod) {
        this.citygml.getCoreUnmarshaller().unmarshalSemanticsAttributes(src, dest);
        if (lod.intValue() == 3) {
            MultiSurface multiSurface = new MultiSurface();
            for (AbstractSurface surface : surfaces) {
                multiSurface.addSurfaceMember(new SurfaceProperty(surface));
            }
            dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
        }
    }

    public Door unmarshalDoor(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        Door dest = new Door();
        this.unmarshalAbstractOpening(src, dest, surfaces, lod);
        return dest;
    }

    public Window unmarshalWindow(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        Window dest = new Window();
        this.unmarshalAbstractOpening(src, dest, surfaces, lod);
        return dest;
    }
}

