/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.vegetation;

import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractVegetationObjectType;
import org.citygml4j.cityjson.feature.PlantCoverAttributes;
import org.citygml4j.cityjson.feature.PlantCoverType;
import org.citygml4j.cityjson.feature.SolitaryVegetationObjectAttributes;
import org.citygml4j.cityjson.feature.SolitaryVegetationObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.citygml.vegetation.AbstractVegetationObject;
import org.citygml4j.model.citygml.vegetation.PlantCover;
import org.citygml4j.model.citygml.vegetation.SolitaryVegetationObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolid;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolidProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.measures.Length;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class VegetationUnmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> typeMapper;

    public VegetationUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(PlantCoverType.class, this::unmarshalPlantCover).with(SolitaryVegetationObjectType.class, this::unmarshalSolitaryVegetationObject);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public void unmarshalAbstractVegetationObject(AbstractVegetationObjectType src, AbstractVegetationObject dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject((AbstractCityObjectType)src, dest, cityJSON);
    }

    public void unmarshalPlantCover(PlantCoverType src, PlantCover dest, CityJSON cityJSON) {
        this.unmarshalAbstractVegetationObject((AbstractVegetationObjectType)src, dest, cityJSON);
        if (src.isSetAttributes()) {
            PlantCoverAttributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
            if (attributes.isSetAverageHeight()) {
                dest.setAverageHeight(new Length(attributes.getAverageHeight()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGeometry geometry = null;
            int lod = 0;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                lod = geometryObject.getLod().intValue();
            } else if (geometryType instanceof GeometryInstanceType) {
                GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
                geometry = this.citygml.getCoreUnmarshaller().unmarshalAndTransformGeometryInstance(geometryInstance, dest);
                lod = (Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod");
            }
            if (geometry == null) continue;
            if (geometry instanceof MultiSurface) {
                MultiSurface multiSurface = (MultiSurface)geometry;
                switch (lod) {
                    case 1: {
                        dest.setLod1MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 2: {
                        dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 3: {
                        dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
                    }
                }
                continue;
            }
            if (!(geometry instanceof MultiSolid)) continue;
            MultiSolid multiSolid = (MultiSolid)geometry;
            switch (lod) {
                case 1: {
                    dest.setLod1MultiSolid(new MultiSolidProperty(multiSolid));
                    break;
                }
                case 2: {
                    dest.setLod2MultiSolid(new MultiSolidProperty(multiSolid));
                    break;
                }
                case 3: {
                    dest.setLod3MultiSolid(new MultiSolidProperty(multiSolid));
                }
            }
        }
    }

    public PlantCover unmarshalPlantCover(PlantCoverType src, CityJSON cityJSON) {
        PlantCover dest = new PlantCover();
        this.unmarshalPlantCover(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalSolitaryVegetationObject(SolitaryVegetationObjectType src, SolitaryVegetationObject dest, CityJSON cityJSON) {
        this.unmarshalAbstractVegetationObject((AbstractVegetationObjectType)src, dest, cityJSON);
        if (src.isSetAttributes()) {
            SolitaryVegetationObjectAttributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
            if (attributes.isSetSpecies()) {
                dest.setSpecies(new Code(attributes.getSpecies()));
            }
            if (attributes.isSetTrunkDiameter()) {
                dest.setTrunkDiameter(new Length(attributes.getTrunkDiameter()));
            }
            if (attributes.isSetCrownDiameter()) {
                dest.setCrownDiameter(new Length(attributes.getCrownDiameter()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGML geometry;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                if (geometry == null) continue;
                int lod = geometryObject.getLod().intValue();
                switch (lod) {
                    case 1: {
                        dest.setLod1Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 2: {
                        dest.setLod2Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 3: {
                        dest.setLod3Geometry(new GeometryProperty<AbstractGML>(geometry));
                    }
                }
                continue;
            }
            if (!(geometryType instanceof GeometryInstanceType)) continue;
            GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
            geometry = this.citygml.getCoreUnmarshaller().unmarshalGeometryInstance(geometryInstance);
            if (geometry == null) continue;
            switch ((Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod")) {
                case 1: {
                    dest.setLod1ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 2: {
                    dest.setLod2ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 3: {
                    dest.setLod3ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                }
            }
        }
    }

    public SolitaryVegetationObject unmarshalSolitaryVegetationObject(SolitaryVegetationObjectType src, CityJSON cityJSON) {
        SolitaryVegetationObject dest = new SolitaryVegetationObject();
        this.unmarshalSolitaryVegetationObject(src, dest, cityJSON);
        return dest;
    }
}

