/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.cityjson.appearance.AbstractMaterialObject;
import org.citygml4j.cityjson.appearance.AbstractTextureObject;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractSemanticsObject;
import org.citygml4j.cityjson.geometry.AbstractSolidCollectionType;
import org.citygml4j.cityjson.geometry.AbstractSurfaceCollectionType;
import org.citygml4j.cityjson.geometry.CompositeSolidType;
import org.citygml4j.cityjson.geometry.CompositeSurfaceType;
import org.citygml4j.cityjson.geometry.MultiLineStringType;
import org.citygml4j.cityjson.geometry.MultiPointType;
import org.citygml4j.cityjson.geometry.MultiSolidType;
import org.citygml4j.cityjson.geometry.MultiSurfaceType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.cityjson.geometry.SolidType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurve;
import org.citygml4j.model.gml.geometry.aggregates.MultiPoint;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolid;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.complexes.CompositeCurve;
import org.citygml4j.model.gml.geometry.complexes.CompositeSolid;
import org.citygml4j.model.gml.geometry.complexes.CompositeSurface;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.CurveProperty;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;
import org.citygml4j.model.gml.geometry.primitives.DirectPositionList;
import org.citygml4j.model.gml.geometry.primitives.Exterior;
import org.citygml4j.model.gml.geometry.primitives.Interior;
import org.citygml4j.model.gml.geometry.primitives.LineString;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.model.gml.geometry.primitives.Point;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.model.gml.geometry.primitives.Solid;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.Triangle;
import org.citygml4j.model.gml.geometry.primitives.TrianglePatchArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.TriangulatedSurface;
import org.citygml4j.util.child.ChildInfo;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class GMLUnmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONUnmarshaller json;
    private final ChildInfo info;
    private BiFunctionTypeMapper<AbstractCityObject, AbstractGeometry> typeMapper;
    private int numVertices;
    private List<List<Double>> vertices;

    public GMLUnmarshaller(CityJSONUnmarshaller json) {
        this.json = json;
        this.info = new ChildInfo();
    }

    private BiFunctionTypeMapper<AbstractCityObject, AbstractGeometry> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(MultiPointType.class, this::unmarshalMultiPoint).with(MultiLineStringType.class, this::unmarshalMultiLineString).with(MultiSurfaceType.class, this::unmarshalMultiSurface).with(CompositeSurfaceType.class, this::unmarshalCompositeSurface).with(SolidType.class, this::unmarshalSolid).with(MultiSolidType.class, this::unmarshalMultiSolid).with(CompositeSolidType.class, this::unmarshalCompositeSolid);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractGeometry unmarshal(AbstractGeometryObjectType geometry, AbstractCityObject cityObject) {
        return this.getTypeMapper().apply(geometry, cityObject);
    }

    public AbstractGeometry unmarshal(AbstractGeometryObjectType geometry) {
        return this.getTypeMapper().apply(geometry, null);
    }

    public void setVertices(List<List<Double>> vertices) {
        this.vertices = vertices;
        this.numVertices = vertices != null ? vertices.size() : 0;
    }

    public void applyTransformation(TransformType transform) {
        if (transform.isSetScale() && transform.isSetTranslate() && this.numVertices > 0) {
            for (List<Double> vertex : this.vertices) {
                for (int i = 0; i < vertex.size(); ++i) {
                    vertex.set(i, vertex.get(i) * (Double)transform.getScale().get(i) + (Double)transform.getTranslate().get(i));
                }
            }
        }
    }

    public void unmarshalMultiPoint(MultiPointType src, MultiPoint dest) {
        List<Double> points = this.getVertices(src.getPoints());
        for (int i = 0; i < points.size(); i += 3) {
            Point point = new Point();
            DirectPosition pos = new DirectPosition();
            pos.setValue(points.subList(i, i + 3));
            pos.setSrsDimension(3);
            point.setPos(pos);
            dest.addPointMember(new PointProperty(point));
        }
    }

    public MultiPoint unmarshalMultiPoint(MultiPointType src) {
        MultiPoint dest = new MultiPoint();
        this.unmarshalMultiPoint(src, dest);
        return dest;
    }

    public MultiPoint unmarshalMultiPoint(MultiPointType src, AbstractCityObject cityObject) {
        return this.unmarshalMultiPoint(src);
    }

    public void unmarshalMultiLineString(MultiLineStringType src, MultiCurve dest) {
        for (List lineString : src.getLineStrings()) {
            List<Double> value = this.getVertices(lineString);
            if (value.isEmpty()) continue;
            LineString curve = new LineString();
            DirectPositionList posList = new DirectPositionList();
            posList.setValue(value);
            posList.setSrsDimension(3);
            curve.setPosList(posList);
            dest.addCurveMember(new CurveProperty(curve));
        }
    }

    public MultiCurve unmarshalMultiLineString(MultiLineStringType src) {
        MultiCurve dest = new MultiCurve();
        this.unmarshalMultiLineString(src, dest);
        return dest;
    }

    public MultiCurve unmarshalMultiLineString(MultiLineStringType src, AbstractCityObject cityObject) {
        return this.unmarshalMultiLineString(src);
    }

    public AbstractCurve unmarshalCurve(MultiLineStringType src) {
        MultiCurve multiCurve = new MultiCurve();
        this.unmarshalMultiLineString(src, multiCurve);
        AbstractCurve dest = null;
        if (multiCurve.isSetCurveMember()) {
            if (multiCurve.getCurveMember().size() == 1) {
                dest = multiCurve.getCurveMember().get(0).getCurve();
            } else {
                dest = new CompositeCurve();
                dest.setCurveMember(multiCurve.getCurveMember());
            }
        }
        return dest;
    }

    public List<SurfaceProperty> unmarshalSurfaceCollection(AbstractSurfaceCollectionType src, AbstractCityObject cityObject, boolean useXLinks) {
        ArrayList<SurfaceProperty> dest = new ArrayList<SurfaceProperty>();
        ArrayList<AbstractSurface> surfaces = new ArrayList<AbstractSurface>();
        for (List list : src.getSurfaces()) {
            Polygon polygon = this.unmarshalPolygon(list);
            if (polygon == null) continue;
            surfaces.add(polygon);
        }
        if (src.isSetSemantics()) {
            this.unmarshalSemantics((AbstractSemanticsObject)src.getSemantics(), surfaces, src.getLod(), cityObject);
        }
        for (AbstractSurface abstractSurface : surfaces) {
            if (!abstractSurface.isSetId()) {
                dest.add(new SurfaceProperty(abstractSurface));
                continue;
            }
            if (!useXLinks) continue;
            dest.add(new SurfaceProperty("#" + abstractSurface.getId()));
        }
        if (src.isSetMaterial()) {
            this.unmarshalMaterial(src.getMaterial(), surfaces, cityObject);
        }
        if (src.isSetTexture()) {
            this.unmarshalTexture((Collection<? extends AbstractTextureObject>)src.getTexture(), surfaces, cityObject);
        }
        return dest;
    }

    public MultiSurface unmarshalMultiSurface(AbstractSurfaceCollectionType src, AbstractCityObject cityObject) {
        MultiSurface dest = new MultiSurface();
        for (SurfaceProperty property : this.unmarshalSurfaceCollection(src, cityObject, false)) {
            dest.addSurfaceMember(property);
        }
        return dest.isSetSurfaceMember() ? dest : null;
    }

    public CompositeSurface unmarshalCompositeSurface(CompositeSurfaceType src, AbstractCityObject cityObject) {
        CompositeSurface dest = new CompositeSurface();
        for (SurfaceProperty property : this.unmarshalSurfaceCollection((AbstractSurfaceCollectionType)src, cityObject, true)) {
            dest.addSurfaceMember(property);
        }
        return dest;
    }

    public void unmarshalTriangulatedSurface(CompositeSurfaceType src, TriangulatedSurface dest, AbstractCityObject cityObject) {
        TrianglePatchArrayProperty trianglePatches = new TrianglePatchArrayProperty();
        for (List surface : src.getSurfaces()) {
            Triangle triangle = this.unmarshalTriangle(surface);
            if (triangle == null) continue;
            trianglePatches.addTriangle(triangle);
        }
        if (trianglePatches.isSetTriangle()) {
            dest.setTrianglePatches(trianglePatches);
            if (src.isSetMaterial()) {
                this.unmarshalMaterial(src.getMaterial(), Collections.singletonList(dest), cityObject);
            }
            if (src.isSetTexture()) {
                this.unmarshalTexture((Collection<? extends AbstractTextureObject>)src.getTexture(), dest, cityObject);
            }
        }
    }

    public TriangulatedSurface unmarshalTriangulatedSurface(CompositeSurfaceType src, AbstractCityObject cityObject) {
        TriangulatedSurface dest = new TriangulatedSurface();
        this.unmarshalTriangulatedSurface(src, dest, cityObject);
        return dest;
    }

    public void unmarshalSolid(SolidType src, Solid dest, AbstractCityObject cityObject) {
        Object surface;
        ArrayList<Integer> shells = new ArrayList<Integer>();
        ArrayList<AbstractSurface> surfaces = new ArrayList<AbstractSurface>();
        int index = 0;
        for (Object shell : src.getShells()) {
            shells.add(index);
            Iterator iterator = shell.iterator();
            while (iterator.hasNext()) {
                surface = (List)iterator.next();
                Polygon polygon = this.unmarshalPolygon((List<List<Integer>>)surface);
                if (polygon == null) continue;
                surfaces.add(polygon);
                ++index;
            }
        }
        shells.add(index);
        if (src.isSetSemantics()) {
            this.unmarshalSemantics((AbstractSemanticsObject)src.getSemantics(), surfaces, src.getLod(), cityObject);
        }
        for (int i = 0; i < shells.size() - 1; ++i) {
            Object shell;
            shell = new CompositeSurface();
            if (i == 0) {
                dest.setExterior(new SurfaceProperty((AbstractSurface)shell));
            } else {
                dest.addInterior(new SurfaceProperty((AbstractSurface)shell));
            }
            for (int j = ((Integer)shells.get(i)).intValue(); j < (Integer)shells.get(i + 1); ++j) {
                surface = (AbstractSurface)surfaces.get(j);
                if (((AbstractGML)surface).isSetId()) {
                    ((CompositeSurface)shell).addSurfaceMember(new SurfaceProperty("#" + ((AbstractGML)surface).getId()));
                    continue;
                }
                ((CompositeSurface)shell).addSurfaceMember(new SurfaceProperty((AbstractSurface)surface));
            }
        }
        if (src.isSetMaterial()) {
            this.unmarshalMaterial(src.getMaterial(), surfaces, cityObject);
        }
        if (src.isSetTexture()) {
            this.unmarshalTexture((Collection<? extends AbstractTextureObject>)src.getTexture(), surfaces, cityObject);
        }
    }

    public Solid unmarshalSolid(SolidType src, AbstractCityObject cityObject) {
        Solid dest = new Solid();
        this.unmarshalSolid(src, dest, cityObject);
        return dest;
    }

    public List<Solid> unmarshalSolidCollection(AbstractSolidCollectionType src, AbstractCityObject cityObject) {
        Object surface;
        ArrayList<Solid> dest = new ArrayList<Solid>();
        ArrayList solids = new ArrayList();
        ArrayList<AbstractSurface> surfaces = new ArrayList<AbstractSurface>();
        int index = 0;
        for (List list : src.getSolids()) {
            ArrayList<Integer> shells = new ArrayList<Integer>();
            for (Object shell : list) {
                shells.add(index);
                Iterator iterator = shell.iterator();
                while (iterator.hasNext()) {
                    surface = (List)iterator.next();
                    Polygon polygon = this.unmarshalPolygon((List<List<Integer>>)surface);
                    if (polygon == null) continue;
                    surfaces.add(polygon);
                    ++index;
                }
            }
            shells.add(index);
            solids.add(shells);
        }
        if (src.isSetSemantics()) {
            this.unmarshalSemantics((AbstractSemanticsObject)src.getSemantics(), surfaces, src.getLod(), cityObject);
        }
        for (List list : solids) {
            Solid solid = new Solid();
            for (int j = 0; j < list.size() - 1; ++j) {
                Object shell;
                shell = new CompositeSurface();
                if (j == 0) {
                    solid.setExterior(new SurfaceProperty((AbstractSurface)shell));
                } else {
                    solid.addInterior(new SurfaceProperty((AbstractSurface)shell));
                }
                for (int k = ((Integer)list.get(j)).intValue(); k < (Integer)list.get(j + 1); ++k) {
                    surface = (AbstractSurface)surfaces.get(k);
                    if (((AbstractGML)surface).isSetId()) {
                        ((CompositeSurface)shell).addSurfaceMember(new SurfaceProperty("#" + ((AbstractGML)surface).getId()));
                        continue;
                    }
                    ((CompositeSurface)shell).addSurfaceMember(new SurfaceProperty((AbstractSurface)surface));
                }
            }
            dest.add(solid);
        }
        if (src.isSetMaterial()) {
            this.unmarshalMaterial(src.getMaterial(), surfaces, cityObject);
        }
        if (src.isSetTexture()) {
            this.unmarshalTexture((Collection<? extends AbstractTextureObject>)src.getTexture(), surfaces, cityObject);
        }
        return dest;
    }

    public CompositeSolid unmarshalCompositeSolid(CompositeSolidType src, AbstractCityObject cityObject) {
        CompositeSolid dest = new CompositeSolid();
        for (Solid solid : this.unmarshalSolidCollection((AbstractSolidCollectionType)src, cityObject)) {
            dest.addSolidMember(new SolidProperty(solid));
        }
        return dest;
    }

    public MultiSolid unmarshalMultiSolid(MultiSolidType src, AbstractCityObject cityObject) {
        MultiSolid dest = new MultiSolid();
        for (Solid solid : this.unmarshalSolidCollection((AbstractSolidCollectionType)src, cityObject)) {
            dest.addSolidMember(new SolidProperty(solid));
        }
        return dest;
    }

    private Polygon unmarshalPolygon(List<List<Integer>> indexes) {
        Polygon dest = new Polygon();
        if (indexes != null && !indexes.isEmpty()) {
            List<Double> vertices = this.getVertices(indexes.get(0));
            if (vertices.isEmpty()) {
                return null;
            }
            vertices.addAll(vertices.subList(0, 3));
            LinearRing exterior = new LinearRing();
            DirectPositionList posList = new DirectPositionList();
            posList.setValue(vertices);
            posList.setSrsDimension(3);
            exterior.setPosList(posList);
            dest.setExterior(new Exterior(exterior));
            if (indexes.size() > 1) {
                for (int i = 1; i < indexes.size(); ++i) {
                    vertices = this.getVertices(indexes.get(i));
                    if (vertices.isEmpty()) continue;
                    vertices.addAll(vertices.subList(0, 3));
                    LinearRing interior = new LinearRing();
                    posList = new DirectPositionList();
                    posList.setValue(vertices);
                    posList.setSrsDimension(3);
                    interior.setPosList(posList);
                    dest.addInterior(new Interior(interior));
                }
            }
        }
        return dest.isSetExterior() ? dest : null;
    }

    private Triangle unmarshalTriangle(List<List<Integer>> indexes) {
        Triangle dest = new Triangle();
        if (indexes != null && !indexes.isEmpty()) {
            List<Double> vertices = this.getVertices(indexes.get(0));
            if (vertices.size() != 9) {
                return null;
            }
            vertices.addAll(vertices.subList(0, 3));
            LinearRing exterior = new LinearRing();
            DirectPositionList posList = new DirectPositionList();
            posList.setValue(vertices);
            posList.setSrsDimension(3);
            exterior.setPosList(posList);
            dest.setExterior(new Exterior(exterior));
        }
        return dest.isSetExterior() ? dest : null;
    }

    private void unmarshalSemantics(AbstractSemanticsObject semanticsObject, List<AbstractSurface> surfaces, Number lod, AbstractCityObject cityObject) {
        if (lod.intValue() < 2) {
            return;
        }
        Map<Integer, List<AbstractSurface>> semantics = this.collectSurfaces(semanticsObject.flatValues(), surfaces);
        Iterator<Object> iterator = semanticsObject.getSurfaces().iterator();
        block0: while (iterator.hasNext()) {
            SemanticsType type;
            SemanticsType parent = type = (SemanticsType)iterator.next();
            while (parent != null && parent.isSetParent()) {
                if (parent.getParent() < 0 || parent.getParent() >= semanticsObject.getNumSurfaces()) {
                    parent.unsetParent();
                    continue block0;
                }
                parent = (SemanticsType)semanticsObject.getSurfaces().get(parent.getParent());
                if (parent != type) continue;
                type.unsetParent();
                continue block0;
            }
        }
        this.json.getCityGMLUnmarshaller().unmarshalSemantics(semanticsObject, semantics, lod, cityObject);
        for (AbstractSurface surface : surfaces) {
            if (surface == null || this.info.getParentCityObject(surface) == null) continue;
            surface.setId(DefaultGMLIdManager.getInstance().generateUUID());
        }
    }

    private void unmarshalMaterial(Collection<? extends AbstractMaterialObject> materialObjects, List<AbstractSurface> surfaces, AbstractCityObject cityObject) {
        for (AbstractMaterialObject abstractMaterialObject : materialObjects) {
            Map<Integer, List<AbstractSurface>> materials;
            if (abstractMaterialObject.isSetValues()) {
                materials = this.collectSurfaces(abstractMaterialObject.flatValues(), surfaces);
            } else {
                if (!abstractMaterialObject.isSetValue()) continue;
                materials = new HashMap<Integer, List<AbstractSurface>>();
                materials.put(abstractMaterialObject.getValue(), surfaces);
            }
            this.json.getCityGMLUnmarshaller().getAppearanceUnmarshaller().unmarshalMaterial(abstractMaterialObject, materials, cityObject);
        }
    }

    public void unmarshalTexture(Collection<? extends AbstractTextureObject> textureObjects, List<AbstractSurface> surfaces, AbstractCityObject cityObject) {
        for (AbstractTextureObject abstractTextureObject : textureObjects) {
            HashMap<Integer, List<AbstractSurface>> textures = new HashMap<Integer, List<AbstractSurface>>();
            List values = abstractTextureObject.flatValues();
            for (int i = 0; i < values.size(); ++i) {
                Integer textureIndex;
                List exterior;
                List value = (List)values.get(i);
                if (value == null || (exterior = (List)value.get(0)) == null || (textureIndex = (Integer)exterior.get(0)) == null) continue;
                if (i >= surfaces.size()) break;
                AbstractSurface surface = surfaces.get(i);
                if (surface == null) continue;
                List tmp = textures.computeIfAbsent(textureIndex, k -> new ArrayList());
                surface.setLocalProperty("org.citygml4j.textureCoordinates", value);
                tmp.add(surface);
            }
            this.json.getCityGMLUnmarshaller().getAppearanceUnmarshaller().unmarshalParameterizedTexture(abstractTextureObject, textures, cityObject);
        }
    }

    public void unmarshalTexture(Collection<? extends AbstractTextureObject> textureObjects, TriangulatedSurface surface, AbstractCityObject cityObject) {
        for (AbstractTextureObject abstractTextureObject : textureObjects) {
            List values = abstractTextureObject.flatValues();
            Integer texture = null;
            ArrayList<List> textureCoordinates = new ArrayList<List>();
            for (int i = 0; i < values.size(); ++i) {
                Integer textureIndex;
                List exterior;
                List value = (List)values.get(i);
                if (value == null || (exterior = (List)value.get(0)) == null || (textureIndex = (Integer)exterior.get(0)) == null) continue;
                if (texture == null) {
                    texture = textureIndex;
                } else if (!texture.equals(textureIndex)) {
                    texture = null;
                    break;
                }
                if (i >= surface.getTrianglePatches().getTriangle().size()) break;
                textureCoordinates.add(exterior);
            }
            if (texture == null || textureCoordinates.isEmpty()) continue;
            HashMap<Integer, List<AbstractSurface>> textures = new HashMap<Integer, List<AbstractSurface>>();
            textures.put(texture, Collections.singletonList(surface));
            surface.setLocalProperty("org.citygml4j.textureCoordinates", textureCoordinates);
            this.json.getCityGMLUnmarshaller().getAppearanceUnmarshaller().unmarshalParameterizedTexture(abstractTextureObject, textures, cityObject);
        }
    }

    private Map<Integer, List<AbstractSurface>> collectSurfaces(List<Integer> values, List<AbstractSurface> surfaces) {
        HashMap<Integer, List<AbstractSurface>> result = new HashMap<Integer, List<AbstractSurface>>();
        for (int i = 0; i < values.size(); ++i) {
            Integer value = values.get(i);
            if (value == null) continue;
            if (i >= surfaces.size()) break;
            AbstractSurface surface = surfaces.get(i);
            if (surface == null) continue;
            List tmp = result.computeIfAbsent(value, k -> new ArrayList());
            tmp.add(surface);
        }
        return result;
    }

    private List<Double> getVertices(List<Integer> indexes) {
        ArrayList<Double> vertices = new ArrayList<Double>();
        for (Integer index : indexes) {
            List<Double> vertex;
            if (index == null || index >= this.numVertices || (vertex = this.vertices.get(index)) == null || vertex.size() != 3) continue;
            vertices.addAll(vertex);
        }
        return vertices;
    }
}

