/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.copy;

import java.lang.reflect.Field;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.builder.copy.DeepCopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.child.Child;

public class ObjectCopier {
    private ObjectCopier() {
    }

    public static <T> T copyTo(T source, T target, CopyBuilder copyBuilder) {
        return ObjectCopier.copyTo(source, target, source.getClass(), copyBuilder);
    }

    public static <T> T copyTo(T source, T target, Class<T> type, CopyBuilder copyBuilder) {
        ModelObject tmp = null;
        if (copyBuilder instanceof DeepCopyBuilder && target instanceof ModelObject) {
            DeepCopyBuilder deepCopyBuilder = (DeepCopyBuilder)copyBuilder;
            tmp = deepCopyBuilder.getTarget();
            deepCopyBuilder.setTarget((ModelObject)target);
        }
        for (Field sourceField : type.getDeclaredFields()) {
            try {
                Field targetField = type.getDeclaredField(sourceField.getName());
                if (targetField == null) continue;
                sourceField.setAccessible(true);
                targetField.setAccessible(true);
                Object value = sourceField.get(source);
                Object copy = copyBuilder.copy(value);
                if (copy == null) continue;
                targetField.set(target, copy);
                if (value == copy || !(copy instanceof Child) || !(target instanceof ModelObject)) continue;
                ((Child)copy).setParent((ModelObject)target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (copyBuilder instanceof DeepCopyBuilder) {
            ((DeepCopyBuilder)copyBuilder).setTarget(tmp);
        }
        if (target instanceof Child) {
            ((Child)target).unsetParent();
        }
        return target;
    }
}

