/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal.citygml.generics;

import java.math.BigInteger;
import java.time.LocalDate;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.generics._2.AbstractGenericAttributeType;
import net.opengis.citygml.generics._2.DateAttributeType;
import net.opengis.citygml.generics._2.DoubleAttributeType;
import net.opengis.citygml.generics._2.GenericAttributeSetType;
import net.opengis.citygml.generics._2.GenericCityObjectType;
import net.opengis.citygml.generics._2.IntAttributeType;
import net.opengis.citygml.generics._2.MeasureAttributeType;
import net.opengis.citygml.generics._2.ObjectFactory;
import net.opengis.citygml.generics._2.StringAttributeType;
import net.opengis.citygml.generics._2.UriAttributeType;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.citygml.generics.DateAttribute;
import org.citygml4j.model.citygml.generics.DoubleAttribute;
import org.citygml4j.model.citygml.generics.GenericAttributeSet;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.citygml.generics.IntAttribute;
import org.citygml4j.model.citygml.generics.MeasureAttribute;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.citygml.generics.UriAttribute;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.TypeMapper;

public class Generics200Marshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectFactory gen = new ObjectFactory();
    private final JAXBMarshaller jaxb;
    private final CityGMLMarshaller citygml;
    private TypeMapper<JAXBElement<?>> elementMapper;
    private TypeMapper<Object> typeMapper;

    public Generics200Marshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBMarshaller();
    }

    private TypeMapper<JAXBElement<?>> getElementMapper() {
        if (this.elementMapper == null) {
            this.lock.lock();
            try {
                if (this.elementMapper == null) {
                    this.elementMapper = TypeMapper.create().with(GenericCityObject.class, this::createGenericCityObject).with(DateAttribute.class, this::createDateAttribute).with(DoubleAttribute.class, this::createDoubleAttribute).with(IntAttribute.class, this::createIntAttribute).with(StringAttribute.class, this::createStringAttribute).with(UriAttribute.class, this::createUriAttribute).with(MeasureAttribute.class, this::createMeasureAttribute).with(GenericAttributeSet.class, this::createGenericAttributeSet);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.elementMapper;
    }

    private TypeMapper<Object> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(GenericCityObject.class, this::marshalGenericCityObject).with(DateAttribute.class, this::marshalDateAttribute).with(DoubleAttribute.class, this::marshalDoubleAttribute).with(IntAttribute.class, this::marshalIntAttribute).with(StringAttribute.class, this::marshalStringAttribute).with(UriAttribute.class, this::marshalUriAttribute).with(MeasureAttribute.class, this::marshalMeasureAttribute).with(GenericAttributeSet.class, this::marshalGenericAttributeSet);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        return this.getElementMapper().apply(src);
    }

    public Object marshal(ModelObject src) {
        return this.getTypeMapper().apply(src);
    }

    public void marshalAbstractGenericAttribute(AbstractGenericAttribute src, AbstractGenericAttributeType dest) {
        if (src.isSetName()) {
            dest.setName(src.getName());
        }
    }

    public void marshalGenericCityObject(GenericCityObject src, GenericCityObjectType dest) {
        this.citygml.getCore200Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(this.jaxb.getGMLMarshaller().marshalCode(src.getClazz()));
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(this.jaxb.getGMLMarshaller().marshalCode(function));
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(this.jaxb.getGMLMarshaller().marshalCode(usage));
            }
        }
        if (src.isSetLod0Geometry()) {
            dest.setLod0Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod0Geometry()));
        }
        if (src.isSetLod1Geometry()) {
            dest.setLod1Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod1Geometry()));
        }
        if (src.isSetLod2Geometry()) {
            dest.setLod2Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry()));
        }
        if (src.isSetLod3Geometry()) {
            dest.setLod3Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry()));
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetLod0ImplicitRepresentation()) {
            dest.setLod0ImplicitRepresentation(this.citygml.getCore200Marshaller().marshalImplicitRepresentationProperty(src.getLod0ImplicitRepresentation()));
        }
        if (src.isSetLod1ImplicitRepresentation()) {
            dest.setLod1ImplicitRepresentation(this.citygml.getCore200Marshaller().marshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation()));
        }
        if (src.isSetLod2ImplicitRepresentation()) {
            dest.setLod2ImplicitRepresentation(this.citygml.getCore200Marshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation()));
        }
        if (src.isSetLod3ImplicitRepresentation()) {
            dest.setLod3ImplicitRepresentation(this.citygml.getCore200Marshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation()));
        }
        if (src.isSetLod4ImplicitRepresentation()) {
            dest.setLod4ImplicitRepresentation(this.citygml.getCore200Marshaller().marshalImplicitRepresentationProperty(src.getLod4ImplicitRepresentation()));
        }
        if (src.isSetLod0TerrainIntersection()) {
            dest.setLod0TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod0TerrainIntersection()));
        }
        if (src.isSetLod1TerrainIntersection()) {
            dest.setLod1TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod1TerrainIntersection()));
        }
        if (src.isSetLod2TerrainIntersection()) {
            dest.setLod2TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod2TerrainIntersection()));
        }
        if (src.isSetLod3TerrainIntersection()) {
            dest.setLod3TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod3TerrainIntersection()));
        }
        if (src.isSetLod4TerrainIntersection()) {
            dest.setLod4TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod4TerrainIntersection()));
        }
    }

    public GenericCityObjectType marshalGenericCityObject(GenericCityObject src) {
        GenericCityObjectType dest = this.gen.createGenericCityObjectType();
        this.marshalGenericCityObject(src, dest);
        return dest;
    }

    public void marshalDateAttribute(DateAttribute src, DateAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            LocalDate date = src.getValue();
            dest.setValue(this.jaxb.getDataTypeFactory().newXMLGregorianCalendarDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), Integer.MIN_VALUE));
        }
    }

    public DateAttributeType marshalDateAttribute(DateAttribute src) {
        DateAttributeType dest = this.gen.createDateAttributeType();
        this.marshalDateAttribute(src, dest);
        return dest;
    }

    public void marshalDoubleAttribute(DoubleAttribute src, DoubleAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public DoubleAttributeType marshalDoubleAttribute(DoubleAttribute src) {
        DoubleAttributeType dest = this.gen.createDoubleAttributeType();
        this.marshalDoubleAttribute(src, dest);
        return dest;
    }

    public void marshalIntAttribute(IntAttribute src, IntAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(BigInteger.valueOf(src.getValue().intValue()));
        }
    }

    public IntAttributeType marshalIntAttribute(IntAttribute src) {
        IntAttributeType dest = this.gen.createIntAttributeType();
        this.marshalIntAttribute(src, dest);
        return dest;
    }

    public void marshalStringAttribute(StringAttribute src, StringAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public StringAttributeType marshalStringAttribute(StringAttribute src) {
        StringAttributeType dest = this.gen.createStringAttributeType();
        this.marshalStringAttribute(src, dest);
        return dest;
    }

    public void marshalUriAttribute(UriAttribute src, UriAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public UriAttributeType marshalUriAttribute(UriAttribute src) {
        UriAttributeType dest = this.gen.createUriAttributeType();
        this.marshalUriAttribute(src, dest);
        return dest;
    }

    public void marshalMeasureAttribute(MeasureAttribute src, MeasureAttributeType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(this.jaxb.getGMLMarshaller().marshalMeasure(src.getValue()));
        }
    }

    public MeasureAttributeType marshalMeasureAttribute(MeasureAttribute src) {
        MeasureAttributeType dest = this.gen.createMeasureAttributeType();
        this.marshalMeasureAttribute(src, dest);
        return dest;
    }

    public GenericAttributeSetType marshalGenericAttributeSet(GenericAttributeSet src) {
        GenericAttributeSetType dest = this.gen.createGenericAttributeSetType();
        this.marshalGenericAttributeSet(src, dest);
        return dest;
    }

    private void marshalGenericAttributeSet(GenericAttributeSet src, GenericAttributeSetType dest) {
        this.marshalAbstractGenericAttribute(src, dest);
        if (src.isSetCodeSpace()) {
            dest.setCodeSpace(src.getCodeSpace());
        }
        if (src.isSetGenericAttribute()) {
            for (AbstractGenericAttribute genericAttribute : src.getGenericAttribute()) {
                JAXBElement<?> elem = this.marshalJAXBElement(genericAttribute);
                if (elem == null || !(elem.getValue() instanceof AbstractGenericAttributeType)) continue;
                dest.get_GenericAttribute().add(elem);
            }
        }
    }

    private JAXBElement<?> createGenericCityObject(GenericCityObject src) {
        return this.gen.createGenericCityObject(this.marshalGenericCityObject(src));
    }

    private JAXBElement<?> createDateAttribute(DateAttribute src) {
        return this.gen.createDateAttribute(this.marshalDateAttribute(src));
    }

    private JAXBElement<?> createDoubleAttribute(DoubleAttribute src) {
        return this.gen.createDoubleAttribute(this.marshalDoubleAttribute(src));
    }

    private JAXBElement<?> createIntAttribute(IntAttribute src) {
        return this.gen.createIntAttribute(this.marshalIntAttribute(src));
    }

    private JAXBElement<?> createStringAttribute(StringAttribute src) {
        return this.gen.createStringAttribute(this.marshalStringAttribute(src));
    }

    private JAXBElement<?> createUriAttribute(UriAttribute src) {
        return this.gen.createUriAttribute(this.marshalUriAttribute(src));
    }

    private JAXBElement<?> createMeasureAttribute(MeasureAttribute src) {
        return this.gen.createMeasureAttribute(this.marshalMeasureAttribute(src));
    }

    private JAXBElement<?> createGenericAttributeSet(GenericAttributeSet src) {
        return this.gen.createGenericAttributeSet(this.marshalGenericAttributeSet(src));
    }
}

