/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal.citygml.texturedsurface;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.texturedsurface._2.AbstractAppearanceType;
import net.opengis.citygml.texturedsurface._2.AppearancePropertyType;
import net.opengis.citygml.texturedsurface._2.MaterialType;
import net.opengis.citygml.texturedsurface._2.ObjectFactory;
import net.opengis.citygml.texturedsurface._2.SimpleTextureType;
import net.opengis.citygml.texturedsurface._2.TextureTypeType;
import net.opengis.citygml.texturedsurface._2.TexturedSurfaceType;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.model.citygml.texturedsurface._AbstractAppearance;
import org.citygml4j.model.citygml.texturedsurface._AppearanceProperty;
import org.citygml4j.model.citygml.texturedsurface._Color;
import org.citygml4j.model.citygml.texturedsurface._Material;
import org.citygml4j.model.citygml.texturedsurface._SimpleTexture;
import org.citygml4j.model.citygml.texturedsurface._TextureType;
import org.citygml4j.model.citygml.texturedsurface._TexturedSurface;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.util.mapper.TypeMapper;
import org.w3._1999.xlink.ActuateType;
import org.w3._1999.xlink.ShowType;
import org.w3._1999.xlink.TypeType;

public class TexturedSurface200Marshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectFactory tex = new ObjectFactory();
    private final JAXBMarshaller jaxb;
    private TypeMapper<JAXBElement<?>> elementMapper;
    private TypeMapper<Object> typeMapper;

    public TexturedSurface200Marshaller(CityGMLMarshaller citygml) {
        this.jaxb = citygml.getJAXBMarshaller();
    }

    private TypeMapper<JAXBElement<?>> getElementMapper() {
        if (this.elementMapper == null) {
            this.lock.lock();
            try {
                if (this.elementMapper == null) {
                    this.elementMapper = TypeMapper.create().with(_Material.class, this::createMaterial).with(_SimpleTexture.class, this::createSimpleTexture).with(_TexturedSurface.class, this::createTexturedSurface);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.elementMapper;
    }

    private TypeMapper<Object> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(_AppearanceProperty.class, this::marshalAppearanceProperty).with(_Color.class, this::marshalColor).with(_Material.class, this::marshalMaterial).with(_SimpleTexture.class, this::marshalSimpleTexture).with(_TexturedSurface.class, this::marshalTexturedSurface).with(_TextureType.class, this::marshalTextureType);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        return this.getElementMapper().apply(src);
    }

    public Object marshal(ModelObject src) {
        return this.getTypeMapper().apply(src);
    }

    public void marshalAbstractAppearance(_AbstractAppearance src, AbstractAppearanceType dest) {
        this.jaxb.getGMLMarshaller().marshalAbstractGML(src, dest);
    }

    public AppearancePropertyType marshalAppearanceProperty(_AppearanceProperty src) {
        JAXBElement<?> elem;
        AppearancePropertyType dest = this.tex.createAppearancePropertyType();
        if (src.isSetOrientation()) {
            dest.setOrientation(src.getOrientation().getValue());
        }
        if (src.isSetAppearance() && (elem = this.jaxb.marshalJAXBElement(src.getAppearance())) != null && elem.getValue() instanceof AbstractAppearanceType) {
            dest.set_Appearance(elem);
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(TypeType.fromValue(src.getType().getValue()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(ShowType.fromValue(src.getShow().getValue()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(ActuateType.fromValue(src.getActuate().getValue()));
        }
        return dest;
    }

    public List<Double> marshalColor(_Color src) {
        return src.toList();
    }

    public void marshalMaterial(_Material src, MaterialType dest) {
        this.marshalAbstractAppearance(src, dest);
        if (src.isSetShininess()) {
            dest.setShininess(src.getShininess());
        }
        if (src.isSetTransparency()) {
            dest.setTransparency(src.getTransparency());
        }
        if (src.isSetAmbientIntensity()) {
            dest.setAmbientIntensity(src.getAmbientIntensity());
        }
        if (src.isSetSpecularColor()) {
            dest.setSpecularColor(this.marshalColor(src.getSpecularColor()));
        }
        if (src.isSetDiffuseColor()) {
            dest.setDiffuseColor(this.marshalColor(src.getDiffuseColor()));
        }
        if (src.isSetEmissiveColor()) {
            dest.setEmissiveColor(this.marshalColor(src.getEmissiveColor()));
        }
    }

    public MaterialType marshalMaterial(_Material src) {
        MaterialType dest = this.tex.createMaterialType();
        this.marshalMaterial(src, dest);
        return dest;
    }

    public void marshalSimpleTexture(_SimpleTexture src, SimpleTextureType dest) {
        this.marshalAbstractAppearance(src, dest);
        if (src.isSetTextureMap()) {
            dest.setTextureMap(src.getTextureMap());
        }
        if (src.isSetTextureCoordinates()) {
            dest.setTextureCoordinates(src.getTextureCoordinates());
        }
        if (src.isSetTextureType()) {
            dest.setTextureType(this.marshalTextureType(src.getTextureType()));
        }
        if (src.isSetRepeat()) {
            dest.setRepeat(src.getRepeat());
        }
    }

    public SimpleTextureType marshalSimpleTexture(_SimpleTexture src) {
        SimpleTextureType dest = this.tex.createSimpleTextureType();
        this.marshalSimpleTexture(src, dest);
        return dest;
    }

    public void marshalTexturedSurface(_TexturedSurface src, TexturedSurfaceType dest) {
        this.jaxb.getGMLMarshaller().marshalOrientableSurface(src, dest);
        if (src.isSetAppearance()) {
            for (_AppearanceProperty appearanceProperty : src.getAppearance()) {
                dest.getAppearance().add(this.marshalAppearanceProperty(appearanceProperty));
            }
        }
    }

    public TexturedSurfaceType marshalTexturedSurface(_TexturedSurface src) {
        TexturedSurfaceType dest = this.tex.createTexturedSurfaceType();
        this.marshalTexturedSurface(src, dest);
        return dest;
    }

    public TextureTypeType marshalTextureType(_TextureType src) {
        return TextureTypeType.fromValue(src.getValue());
    }

    private JAXBElement<?> createMaterial(_Material src) {
        return this.tex.createMaterial(this.marshalMaterial(src));
    }

    private JAXBElement<?> createSimpleTexture(_SimpleTexture src) {
        return this.tex.createSimpleTexture(this.marshalSimpleTexture(src));
    }

    private JAXBElement<?> createTexturedSurface(_TexturedSurface src) {
        return this.tex.createTexturedSurface(this.marshalTexturedSurface(src));
    }
}

