/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal.citygml.vegetation;

import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.vegetation._1.AbstractVegetationObjectType;
import net.opengis.citygml.vegetation._1.ObjectFactory;
import net.opengis.citygml.vegetation._1.PlantCoverType;
import net.opengis.citygml.vegetation._1.SolitaryVegetationObjectType;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.vegetation.AbstractVegetationObject;
import org.citygml4j.model.citygml.vegetation.PlantCover;
import org.citygml4j.model.citygml.vegetation.SolitaryVegetationObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.TypeMapper;

public class Vegetation100Marshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectFactory veg = new ObjectFactory();
    private final JAXBMarshaller jaxb;
    private final CityGMLMarshaller citygml;
    private TypeMapper<JAXBElement<?>> elementMapper;
    private TypeMapper<Object> typeMapper;

    public Vegetation100Marshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBMarshaller();
    }

    private TypeMapper<JAXBElement<?>> getElementMapper() {
        if (this.elementMapper == null) {
            this.lock.lock();
            try {
                if (this.elementMapper == null) {
                    this.elementMapper = TypeMapper.create().with(PlantCover.class, this::createPlantCover).with(SolitaryVegetationObject.class, this::createSolitaryVegetationObject);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.elementMapper;
    }

    private TypeMapper<Object> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(PlantCover.class, this::marshalPlantCover).with(SolitaryVegetationObject.class, this::marshalSolitaryVegetationObject);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        return this.getElementMapper().apply(src);
    }

    public Object marshal(ModelObject src) {
        return this.getTypeMapper().apply(src);
    }

    public void marshalVegetationObject(AbstractVegetationObject src, AbstractVegetationObjectType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetGenericApplicationPropertyOfVegetationObject()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfVegetationObject()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfVegetationObject().add(jaxbElement);
            }
        }
    }

    public void marshalPlantCover(PlantCover src, PlantCoverType dest) {
        this.marshalVegetationObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetAverageHeight()) {
            dest.setAverageHeight(this.jaxb.getGMLMarshaller().marshalLength(src.getAverageHeight()));
        }
        if (src.isSetLod1MultiSurface()) {
            dest.setLod1MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod1MultiSurface()));
        }
        if (src.isSetLod2MultiSurface()) {
            dest.setLod2MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod2MultiSurface()));
        }
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetLod1MultiSolid()) {
            dest.setLod1MultiSolid(this.jaxb.getGMLMarshaller().marshalMultiSolidProperty(src.getLod1MultiSolid()));
        }
        if (src.isSetLod2MultiSolid()) {
            dest.setLod2MultiSolid(this.jaxb.getGMLMarshaller().marshalMultiSolidProperty(src.getLod2MultiSolid()));
        }
        if (src.isSetLod3MultiSolid()) {
            dest.setLod3MultiSolid(this.jaxb.getGMLMarshaller().marshalMultiSolidProperty(src.getLod3MultiSolid()));
        }
        if (src.isSetGenericApplicationPropertyOfPlantCover()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfPlantCover()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfPlantCover().add(jaxbElement);
            }
        }
    }

    public PlantCoverType marshalPlantCover(PlantCover src) {
        PlantCoverType dest = this.veg.createPlantCoverType();
        this.marshalPlantCover(src, dest);
        return dest;
    }

    public void marshalSolitaryVegetationObject(SolitaryVegetationObject src, SolitaryVegetationObjectType dest) {
        this.marshalVegetationObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetSpecies()) {
            dest.setSpecies(src.getSpecies().getValue());
        }
        if (src.isSetHeight()) {
            dest.setHeight(this.jaxb.getGMLMarshaller().marshalLength(src.getHeight()));
        }
        if (src.isSetTrunkDiameter()) {
            dest.setTrunkDiameter(this.jaxb.getGMLMarshaller().marshalLength(src.getTrunkDiameter()));
        }
        if (src.isSetCrownDiameter()) {
            dest.setCrownDiameter(this.jaxb.getGMLMarshaller().marshalLength(src.getCrownDiameter()));
        }
        if (src.isSetLod1Geometry()) {
            dest.setLod1Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod1Geometry()));
        }
        if (src.isSetLod2Geometry()) {
            dest.setLod2Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry()));
        }
        if (src.isSetLod3Geometry()) {
            dest.setLod3Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry()));
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetLod1ImplicitRepresentation()) {
            dest.setLod1ImplicitRepresentation(this.citygml.getCore100Marshaller().marshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation()));
        }
        if (src.isSetLod2ImplicitRepresentation()) {
            dest.setLod2ImplicitRepresentation(this.citygml.getCore100Marshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation()));
        }
        if (src.isSetLod3ImplicitRepresentation()) {
            dest.setLod3ImplicitRepresentation(this.citygml.getCore100Marshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation()));
        }
        if (src.isSetLod4ImplicitRepresentation()) {
            dest.setLod4ImplicitRepresentation(this.citygml.getCore100Marshaller().marshalImplicitRepresentationProperty(src.getLod4ImplicitRepresentation()));
        }
        if (src.isSetGenericApplicationPropertyOfSolitaryVegetationObject()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfSolitaryVegetationObject()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfSolitaryVegetationObject().add(jaxbElement);
            }
        }
    }

    public SolitaryVegetationObjectType marshalSolitaryVegetationObject(SolitaryVegetationObject src) {
        SolitaryVegetationObjectType dest = this.veg.createSolitaryVegetationObjectType();
        this.marshalSolitaryVegetationObject(src, dest);
        return dest;
    }

    private JAXBElement<?> createPlantCover(PlantCover src) {
        return this.veg.createPlantCover(this.marshalPlantCover(src));
    }

    private JAXBElement<?> createSolitaryVegetationObject(SolitaryVegetationObject src) {
        return this.veg.createSolitaryVegetationObject(this.marshalSolitaryVegetationObject(src));
    }
}

