/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.appearance;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.opengis.citygml.appearance._2.AbstractSurfaceDataType;
import net.opengis.citygml.appearance._2.AbstractTextureParameterizationType;
import net.opengis.citygml.appearance._2.AbstractTextureType;
import net.opengis.citygml.appearance._2.AppearancePropertyElement;
import net.opengis.citygml.appearance._2.AppearancePropertyType;
import net.opengis.citygml.appearance._2.AppearanceType;
import net.opengis.citygml.appearance._2.GeoreferencedTextureType;
import net.opengis.citygml.appearance._2.ParameterizedTextureType;
import net.opengis.citygml.appearance._2.SurfaceDataPropertyType;
import net.opengis.citygml.appearance._2.TexCoordGenType;
import net.opengis.citygml.appearance._2.TexCoordListType;
import net.opengis.citygml.appearance._2.TextureAssociationType;
import net.opengis.citygml.appearance._2.TextureTypeType;
import net.opengis.citygml.appearance._2.WrapModeType;
import net.opengis.citygml.appearance._2.X3DMaterialType;
import net.opengis.gml.FeaturePropertyType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.AbstractSurfaceData;
import org.citygml4j.model.citygml.appearance.AbstractTexture;
import org.citygml4j.model.citygml.appearance.AbstractTextureParameterization;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.appearance.Color;
import org.citygml4j.model.citygml.appearance.ColorPlusOpacity;
import org.citygml4j.model.citygml.appearance.GeoreferencedTexture;
import org.citygml4j.model.citygml.appearance.ParameterizedTexture;
import org.citygml4j.model.citygml.appearance.SurfaceDataProperty;
import org.citygml4j.model.citygml.appearance.TexCoordGen;
import org.citygml4j.model.citygml.appearance.TexCoordList;
import org.citygml4j.model.citygml.appearance.TextureAssociation;
import org.citygml4j.model.citygml.appearance.TextureCoordinates;
import org.citygml4j.model.citygml.appearance.TextureType;
import org.citygml4j.model.citygml.appearance.WorldToTexture;
import org.citygml4j.model.citygml.appearance.WrapMode;
import org.citygml4j.model.citygml.appearance.X3DMaterial;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.xlink.XLinkActuate;
import org.citygml4j.model.gml.xlink.XLinkShow;
import org.citygml4j.model.gml.xlink.XLinkType;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.w3c.dom.Element;

public class Appearance200Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final AppearanceModule module = AppearanceModule.v2_0_0;
    private final JAXBUnmarshaller jaxb;
    private final CityGMLUnmarshaller citygml;
    private CheckedTypeMapper<CityGML> typeMapper;

    public Appearance200Unmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(AppearanceType.class, this::unmarshalAppearance).with(AppearancePropertyType.class, this::unmarshalAppearanceProperty).with(AppearancePropertyElement.class, this::unmarshalAppearanceProperty).with(GeoreferencedTextureType.class, this::unmarshalGeoreferencedTexture).with(ParameterizedTextureType.class, this::unmarshalParameterizedTexture).with(SurfaceDataPropertyType.class, this::unmarshalSurfaceDataProperty).with(TexCoordGenType.class, this::unmarshalTexCoordGen).with(TexCoordListType.class, this::unmarshalTexCoordList).with(TextureAssociationType.class, this::unmarshalTextureAssociation).with(TexCoordListType.TextureCoordinates.class, this::unmarshalTextureCoordinates).with(TextureTypeType.class, this::unmarshalTextureType).with(TexCoordGenType.WorldToTexture.class, this::unmarshalWorldToTexture).with(WrapModeType.class, this::unmarshalWrapMode).with(X3DMaterialType.class, this::unmarshalX3DMaterial).with(FeaturePropertyType.class, this::unmarshalAppearanceProperty).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalAbstractSurfaceData(AbstractSurfaceDataType src, AbstractSurfaceData dest) throws MissingADESchemaException {
        this.jaxb.getGMLUnmarshaller().unmarshalAbstractFeature(src, dest);
        if (src.isSetIsFront()) {
            dest.setIsFront(src.isIsFront());
        }
        if (src.isSet_GenericApplicationPropertyOfSurfaceData()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfSurfaceData()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfSurfaceData(ade);
            }
        }
    }

    public void unmarshalAbstractTexture(AbstractTextureType src, AbstractTexture dest) throws MissingADESchemaException {
        this.unmarshalAbstractSurfaceData(src, dest);
        if (src.isSetImageURI()) {
            dest.setImageURI(src.getImageURI());
        }
        if (src.isSetMimeType()) {
            dest.setMimeType(this.jaxb.getGMLUnmarshaller().unmarshalCode(src.getMimeType()));
        }
        if (src.isSetTextureType()) {
            dest.setTextureType(this.unmarshalTextureType(src.getTextureType()));
        }
        if (src.isSetWrapMode()) {
            dest.setWrapMode(this.unmarshalWrapMode(src.getWrapMode()));
        }
        if (src.isSetBorderColor()) {
            dest.setBorderColor(this.unmarshalColorPlusOpacity(src.getBorderColor()));
        }
        if (src.isSet_GenericApplicationPropertyOfTexture()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfTexture()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfTexture(ade);
            }
        }
    }

    public void unmarshalAbstractTextureParameterization(AbstractTextureParameterizationType src, AbstractTextureParameterization dest) throws MissingADESchemaException {
        ADEComponent ade;
        this.jaxb.getGMLUnmarshaller().unmarshalAbstractGML(src, dest);
        if (!this.jaxb.isSkipGenericADEContent() && src.isSet_ADEComponent()) {
            for (Element element : src.get_ADEComponent()) {
                ade = this.jaxb.getADEUnmarshaller().unmarshal(element);
                if (ade == null || this.jaxb.getCityGMLUnmarshaller().assignGenericProperty((ADEGenericElement)ade, src, dest)) continue;
                dest.addGenericADEElement((ADEGenericElement)ade);
            }
        }
        if (src.isSet_GenericApplicationPropertyOfTextureParameterization()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfTextureParameterization()) {
                ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfTextureParameterization(ade);
            }
        }
    }

    public void unmarshalAppearance(AppearanceType src, Appearance dest) throws MissingADESchemaException {
        this.jaxb.getGMLUnmarshaller().unmarshalAbstractFeature(src, dest);
        if (src.isSetTheme()) {
            dest.setTheme(src.getTheme());
        }
        if (src.isSetSurfaceDataMember()) {
            for (SurfaceDataPropertyType surfaceDataPropertyType : src.getSurfaceDataMember()) {
                dest.addSurfaceDataMember(this.unmarshalSurfaceDataProperty(surfaceDataPropertyType));
            }
        }
        if (src.isSet_GenericApplicationPropertyOfAppearance()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfAppearance()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfAppearance(ade);
            }
        }
    }

    public Appearance unmarshalAppearance(AppearanceType src) throws MissingADESchemaException {
        Appearance dest = new Appearance(this.module);
        this.unmarshalAppearance(src, dest);
        return dest;
    }

    public AppearanceMember unmarshalAppearanceMember(FeaturePropertyType src) throws MissingADESchemaException {
        ModelObject abstractFeature;
        AppearanceMember dest = new AppearanceMember();
        this.jaxb.getGMLUnmarshaller().unmarshalFeatureProperty(src, (FeatureProperty<? extends AbstractFeature>)dest);
        if (src.isSet_Feature() && (abstractFeature = this.jaxb.unmarshal(src.get_Feature())) instanceof Appearance) {
            dest.setAppearance((Appearance)abstractFeature);
        }
        return dest;
    }

    public void unmarshalAppearanceProperty(AppearancePropertyType src, AppearanceProperty dest) throws MissingADESchemaException {
        ModelObject object;
        if (src.isSet_Feature() && (object = this.jaxb.unmarshal(src.get_Feature())) instanceof Appearance) {
            dest.setAppearance((Appearance)object);
        }
        if (!this.jaxb.isSkipGenericADEContent() && src.isSet_ADEComponent()) {
            dest.setGenericADEElement(this.jaxb.getADEUnmarshaller().unmarshal(src.get_ADEComponent()));
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
    }

    public AppearanceProperty unmarshalAppearanceProperty(AppearancePropertyType src) throws MissingADESchemaException {
        AppearanceProperty dest = new AppearanceProperty();
        this.unmarshalAppearanceProperty(src, dest);
        return dest;
    }

    public AppearanceProperty unmarshalAppearanceProperty(AppearancePropertyElement src) throws MissingADESchemaException {
        AppearanceProperty dest = null;
        if (src.getValue() != null) {
            dest = new AppearanceProperty();
            this.unmarshalAppearanceProperty((AppearancePropertyType)src.getValue(), dest);
        }
        return dest;
    }

    public AppearanceProperty unmarshalAppearanceProperty(FeaturePropertyType src) throws MissingADESchemaException {
        ModelObject abstractFeature;
        AppearanceProperty dest = new AppearanceProperty();
        this.jaxb.getGMLUnmarshaller().unmarshalFeatureProperty(src, (FeatureProperty<? extends AbstractFeature>)dest);
        if (src.isSet_Feature() && (abstractFeature = this.jaxb.unmarshal(src.get_Feature())) instanceof Appearance) {
            dest.setAppearance((Appearance)abstractFeature);
        }
        return dest;
    }

    public Color unmarshalColor(List<Double> src) {
        Color dest = new Color();
        dest.setColor(src);
        return dest;
    }

    public ColorPlusOpacity unmarshalColorPlusOpacity(List<Double> src) {
        ColorPlusOpacity dest = new ColorPlusOpacity();
        dest.setColorPlusOpacity(src);
        return dest;
    }

    public void unmarshalGeoreferencedTexture(GeoreferencedTextureType src, GeoreferencedTexture dest) throws MissingADESchemaException {
        this.unmarshalAbstractTexture(src, dest);
        if (src.isSetPreferWorldFile()) {
            dest.setPreferWorldFile(src.isPreferWorldFile());
        }
        if (src.isSetReferencePoint()) {
            dest.setReferencePoint(this.jaxb.getGMLUnmarshaller().unmarshalPointProperty(src.getReferencePoint()));
        }
        if (src.isSetOrientation()) {
            dest.setOrientation(this.citygml.getCore200Unmarshaller().unmarshalTransformationMatrix2x2(src.getOrientation()));
        }
        if (src.isSetTarget()) {
            dest.setTarget(src.getTarget());
        }
        if (src.isSet_GenericApplicationPropertyOfGeoreferencedTexture()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfGeoreferencedTexture()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfGeoreferencedTexture(ade);
            }
        }
    }

    public GeoreferencedTexture unmarshalGeoreferencedTexture(GeoreferencedTextureType src) throws MissingADESchemaException {
        GeoreferencedTexture dest = new GeoreferencedTexture(this.module);
        this.unmarshalGeoreferencedTexture(src, dest);
        return dest;
    }

    public void unmarshalParameterizedTexture(ParameterizedTextureType src, ParameterizedTexture dest) throws MissingADESchemaException {
        this.unmarshalAbstractTexture(src, dest);
        if (src.isSetTarget()) {
            for (TextureAssociationType textureAssociationType : src.getTarget()) {
                dest.addTarget(this.unmarshalTextureAssociation(textureAssociationType));
            }
        }
        if (src.isSet_GenericApplicationPropertyOfParameterizedTexture()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfParameterizedTexture()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfParameterizedTexture(ade);
            }
        }
    }

    public ParameterizedTexture unmarshalParameterizedTexture(ParameterizedTextureType src) throws MissingADESchemaException {
        ParameterizedTexture dest = new ParameterizedTexture(this.module);
        this.unmarshalParameterizedTexture(src, dest);
        return dest;
    }

    public SurfaceDataProperty unmarshalSurfaceDataProperty(SurfaceDataPropertyType src) throws MissingADESchemaException {
        ModelObject surfaceData;
        SurfaceDataProperty dest = new SurfaceDataProperty();
        if (src.isSet_SurfaceData() && (surfaceData = this.jaxb.unmarshal(src.get_SurfaceData())) instanceof AbstractSurfaceData) {
            dest.setSurfaceData((AbstractSurfaceData)surfaceData);
        }
        if (!this.jaxb.isSkipGenericADEContent() && src.isSet_ADEComponent()) {
            dest.setGenericADEElement(this.jaxb.getADEUnmarshaller().unmarshal(src.get_ADEComponent()));
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public void unmarshalTexCoordGen(TexCoordGenType src, TexCoordGen dest) throws MissingADESchemaException {
        this.unmarshalAbstractTextureParameterization(src, dest);
        if (src.isSetWorldToTexture()) {
            dest.setWorldToTexture(this.unmarshalWorldToTexture(src.getWorldToTexture()));
        }
        if (src.isSet_GenericApplicationPropertyOfTexCoordGen()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfTexCoordGen()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfTexCoordGen(ade);
            }
        }
    }

    public TexCoordGen unmarshalTexCoordGen(TexCoordGenType src) throws MissingADESchemaException {
        TexCoordGen dest = new TexCoordGen(this.module);
        this.unmarshalTexCoordGen(src, dest);
        return dest;
    }

    public void unmarshalTexCoordList(TexCoordListType src, TexCoordList dest) throws MissingADESchemaException {
        this.unmarshalAbstractTextureParameterization(src, dest);
        if (src.isSetTextureCoordinates()) {
            for (TexCoordListType.TextureCoordinates textureCoordinates : src.getTextureCoordinates()) {
                dest.addTextureCoordinates(this.unmarshalTextureCoordinates(textureCoordinates));
            }
        }
        if (src.isSet_GenericApplicationPropertyOfTexCoordList()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfTexCoordList()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfTexCoordList(ade);
            }
        }
    }

    public TexCoordList unmarshalTexCoordList(TexCoordListType src) throws MissingADESchemaException {
        TexCoordList dest = new TexCoordList(this.module);
        this.unmarshalTexCoordList(src, dest);
        return dest;
    }

    public TextureAssociation unmarshalTextureAssociation(TextureAssociationType src) throws MissingADESchemaException {
        ModelObject textureParameterization;
        TextureAssociation dest = new TextureAssociation();
        if (src.isSet_TextureParameterization() && (textureParameterization = this.jaxb.unmarshal(src.get_TextureParameterization())) instanceof AbstractTextureParameterization) {
            dest.setTextureParameterization((AbstractTextureParameterization)textureParameterization);
        }
        if (src.isSetUri()) {
            dest.setUri(src.getUri());
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public void unmarshalTextureCoordinates(TexCoordListType.TextureCoordinates src, TextureCoordinates dest) {
        if (src.isSetRing()) {
            dest.setRing(src.getRing());
        }
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public TextureCoordinates unmarshalTextureCoordinates(TexCoordListType.TextureCoordinates src) {
        TextureCoordinates dest = new TextureCoordinates();
        this.unmarshalTextureCoordinates(src, dest);
        return dest;
    }

    public TextureType unmarshalTextureType(TextureTypeType src) {
        return TextureType.fromValue(src.value());
    }

    public void unmarshalWorldToTexture(TexCoordGenType.WorldToTexture src, WorldToTexture dest) {
        if (src.isSetValue()) {
            try {
                Matrix matrix = new Matrix(3, 4);
                matrix.setMatrix(src.getValue());
                dest.setMatrix(matrix);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (src.isSetSrsName()) {
            dest.setSrsName(src.getSrsName());
        }
        if (src.isSetSrsDimension()) {
            dest.setSrsDimension(src.getSrsDimension().intValue());
        }
        if (src.isSetAxisLabels()) {
            dest.setAxisLabels(src.getAxisLabels());
        }
        if (src.isSetUomLabels()) {
            dest.setUomLabels(src.getUomLabels());
        }
    }

    public WorldToTexture unmarshalWorldToTexture(TexCoordGenType.WorldToTexture src) {
        WorldToTexture dest = new WorldToTexture();
        this.unmarshalWorldToTexture(src, dest);
        return dest;
    }

    public WrapMode unmarshalWrapMode(WrapModeType src) {
        return WrapMode.fromValue(src.value());
    }

    public void unmarshalX3DMaterial(X3DMaterialType src, X3DMaterial dest) throws MissingADESchemaException {
        this.unmarshalAbstractSurfaceData(src, dest);
        if (src.isSetAmbientIntensity()) {
            dest.setAmbientIntensity(src.getAmbientIntensity());
        }
        if (src.isSetDiffuseColor()) {
            dest.setDiffuseColor(this.unmarshalColor(src.getDiffuseColor()));
        }
        if (src.isSetEmissiveColor()) {
            dest.setEmissiveColor(this.unmarshalColor(src.getEmissiveColor()));
        }
        if (src.isSetSpecularColor()) {
            dest.setSpecularColor(this.unmarshalColor(src.getSpecularColor()));
        }
        if (src.isSetShininess()) {
            dest.setShininess(src.getShininess());
        }
        if (src.isSetTransparency()) {
            dest.setTransparency(src.getTransparency());
        }
        if (src.isSetIsSmooth()) {
            dest.setIsSmooth(src.isIsSmooth());
        }
        if (src.isSetTarget()) {
            dest.setTarget(src.getTarget());
        }
        if (src.isSet_GenericApplicationPropertyOfX3DMaterial()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfX3DMaterial()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfX3DMaterial(ade);
            }
        }
    }

    public X3DMaterial unmarshalX3DMaterial(X3DMaterialType src) throws MissingADESchemaException {
        X3DMaterial dest = new X3DMaterial(this.module);
        this.unmarshalX3DMaterial(src, dest);
        return dest;
    }

    public boolean assignGenericProperty(ADEGenericElement genericProperty, QName substitutionGroup, AbstractGML dest) {
        String name = substitutionGroup.getLocalPart();
        boolean success = true;
        if (dest instanceof AbstractSurfaceData && name.equals("_GenericApplicationPropertyOfSurfaceData")) {
            ((AbstractSurfaceData)dest).addGenericApplicationPropertyOfSurfaceData(genericProperty);
        } else if (dest instanceof AbstractTexture && name.equals("_GenericApplicationPropertyOfTexture")) {
            ((AbstractTexture)dest).addGenericApplicationPropertyOfTexture(genericProperty);
        } else if (dest instanceof AbstractTextureParameterization && name.equals("_GenericApplicationPropertyOfTextureParameterization")) {
            ((AbstractTextureParameterization)dest).addGenericApplicationPropertyOfTextureParameterization(genericProperty);
        } else if (dest instanceof Appearance && name.equals("_GenericApplicationPropertyOfAppearance")) {
            ((Appearance)dest).addGenericApplicationPropertyOfAppearance(genericProperty);
        } else if (dest instanceof GeoreferencedTexture && name.equals("_GenericApplicationPropertyOfGeoreferencedTexture")) {
            ((GeoreferencedTexture)dest).addGenericApplicationPropertyOfGeoreferencedTexture(genericProperty);
        } else if (dest instanceof ParameterizedTexture && name.equals("_GenericApplicationPropertyOfParameterizedTexture")) {
            ((ParameterizedTexture)dest).addGenericApplicationPropertyOfParameterizedTexture(genericProperty);
        } else if (dest instanceof TexCoordGen && name.equals("_GenericApplicationPropertyOfTexCoordGen")) {
            ((TexCoordGen)dest).addGenericApplicationPropertyOfTexCoordGen(genericProperty);
        } else if (dest instanceof TexCoordList && name.equals("_GenericApplicationPropertyOfTexCoordList")) {
            ((TexCoordList)dest).addGenericApplicationPropertyOfTexCoordList(genericProperty);
        } else if (dest instanceof X3DMaterial && name.equals("_GenericApplicationPropertyOfX3DMaterial")) {
            ((X3DMaterial)dest).addGenericApplicationPropertyOfX3DMaterial(genericProperty);
        } else {
            success = false;
        }
        return success;
    }
}

