/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.generics;

import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.generics._1.AbstractGenericAttributeType;
import net.opengis.citygml.generics._1.DateAttributeType;
import net.opengis.citygml.generics._1.DoubleAttributeType;
import net.opengis.citygml.generics._1.GenericCityObjectType;
import net.opengis.citygml.generics._1.IntAttributeType;
import net.opengis.citygml.generics._1.StringAttributeType;
import net.opengis.citygml.generics._1.UriAttributeType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.citygml.generics.DateAttribute;
import org.citygml4j.model.citygml.generics.DoubleAttribute;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.citygml.generics.IntAttribute;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.citygml.generics.UriAttribute;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.module.citygml.GenericsModule;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;

public class Generics100Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final GenericsModule module = GenericsModule.v1_0_0;
    private final JAXBUnmarshaller jaxb;
    private final CityGMLUnmarshaller citygml;
    private CheckedTypeMapper<CityGML> typeMapper;

    public Generics100Unmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(GenericCityObjectType.class, this::unmarshalGenericCityObject).with(DateAttributeType.class, this::unmarshalDateAttribute).with(DoubleAttributeType.class, this::unmarshalDoubleAttribute).with(IntAttributeType.class, this::unmarshalIntAttribute).with(StringAttributeType.class, this::unmarshalStringAttribute).with(UriAttributeType.class, this::unmarshalUriAttribute).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalAbstractGenericAttribute(AbstractGenericAttributeType src, AbstractGenericAttribute dest) {
        if (src.isSetName()) {
            dest.setName(src.getName());
        }
    }

    public void unmarshalGenericCityObject(GenericCityObjectType src, GenericCityObject dest) throws MissingADESchemaException {
        this.citygml.getCore100Unmarshaller().unmarshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(new Code(src.getClazz()));
        }
        if (src.isSetFunction()) {
            for (String function : src.getFunction()) {
                dest.addFunction(new Code(function));
            }
        }
        if (src.isSetUsage()) {
            for (String usage : src.getUsage()) {
                dest.addUsage(new Code(usage));
            }
        }
        if (src.isSetLod0Geometry()) {
            dest.setLod0Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod0Geometry()));
        }
        if (src.isSetLod1Geometry()) {
            dest.setLod1Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod1Geometry()));
        }
        if (src.isSetLod2Geometry()) {
            dest.setLod2Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod2Geometry()));
        }
        if (src.isSetLod3Geometry()) {
            dest.setLod3Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod3Geometry()));
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetLod0ImplicitRepresentation()) {
            dest.setLod0ImplicitRepresentation(this.citygml.getCore100Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod0ImplicitRepresentation()));
        }
        if (src.isSetLod1ImplicitRepresentation()) {
            dest.setLod1ImplicitRepresentation(this.citygml.getCore100Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation()));
        }
        if (src.isSetLod2ImplicitRepresentation()) {
            dest.setLod2ImplicitRepresentation(this.citygml.getCore100Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation()));
        }
        if (src.isSetLod3ImplicitRepresentation()) {
            dest.setLod3ImplicitRepresentation(this.citygml.getCore100Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation()));
        }
        if (src.isSetLod4ImplicitRepresentation()) {
            dest.setLod4ImplicitRepresentation(this.citygml.getCore100Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod4ImplicitRepresentation()));
        }
        if (src.isSetLod0TerrainIntersection()) {
            dest.setLod0TerrainIntersection(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getLod0TerrainIntersection()));
        }
        if (src.isSetLod1TerrainIntersection()) {
            dest.setLod1TerrainIntersection(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getLod1TerrainIntersection()));
        }
        if (src.isSetLod2TerrainIntersection()) {
            dest.setLod2TerrainIntersection(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getLod2TerrainIntersection()));
        }
        if (src.isSetLod3TerrainIntersection()) {
            dest.setLod3TerrainIntersection(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getLod3TerrainIntersection()));
        }
        if (src.isSetLod4TerrainIntersection()) {
            dest.setLod4TerrainIntersection(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getLod4TerrainIntersection()));
        }
    }

    public GenericCityObject unmarshalGenericCityObject(GenericCityObjectType src) throws MissingADESchemaException {
        GenericCityObject dest = new GenericCityObject(this.module);
        this.unmarshalGenericCityObject(src, dest);
        return dest;
    }

    public void unmarshalDateAttribute(DateAttributeType src, DateAttribute dest) {
        this.unmarshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue().toGregorianCalendar().toZonedDateTime().toLocalDate());
        }
    }

    public DateAttribute unmarshalDateAttribute(DateAttributeType src) {
        DateAttribute dest = new DateAttribute();
        this.unmarshalDateAttribute(src, dest);
        return dest;
    }

    public void unmarshalDoubleAttribute(DoubleAttributeType src, DoubleAttribute dest) {
        this.unmarshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public DoubleAttribute unmarshalDoubleAttribute(DoubleAttributeType src) {
        DoubleAttribute dest = new DoubleAttribute();
        this.unmarshalDoubleAttribute(src, dest);
        return dest;
    }

    public void unmarshalIntAttribute(IntAttributeType src, IntAttribute dest) {
        this.unmarshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue().intValue());
        }
    }

    public IntAttribute unmarshalIntAttribute(IntAttributeType src) {
        IntAttribute dest = new IntAttribute();
        this.unmarshalIntAttribute(src, dest);
        return dest;
    }

    public void unmarshalStringAttribute(StringAttributeType src, StringAttribute dest) {
        this.unmarshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public StringAttribute unmarshalStringAttribute(StringAttributeType src) {
        StringAttribute dest = new StringAttribute();
        this.unmarshalStringAttribute(src, dest);
        return dest;
    }

    public void unmarshalUriAttribute(UriAttributeType src, UriAttribute dest) {
        this.unmarshalAbstractGenericAttribute(src, dest);
        if (src.isSetValue()) {
            dest.setValue(src.getValue());
        }
    }

    public UriAttribute unmarshalUriAttribute(UriAttributeType src) {
        UriAttribute dest = new UriAttribute();
        this.unmarshalUriAttribute(src, dest);
        return dest;
    }
}

