/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.landuse;

import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.opengis.citygml.landuse._2.LandUseType;
import net.opengis.gml.CodeType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.landuse.LandUse;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.module.citygml.LandUseModule;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;

public class LandUse200Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final LandUseModule module = LandUseModule.v2_0_0;
    private final JAXBUnmarshaller jaxb;
    private final CityGMLUnmarshaller citygml;
    private CheckedTypeMapper<CityGML> typeMapper;

    public LandUse200Unmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(LandUseType.class, this::unmarshalLandUse).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalLandUse(LandUseType src, LandUse dest) throws MissingADESchemaException {
        this.citygml.getCore200Unmarshaller().unmarshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(this.jaxb.getGMLUnmarshaller().unmarshalCode(src.getClazz()));
        }
        if (src.isSetFunction()) {
            for (CodeType codeType : src.getFunction()) {
                dest.addFunction(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetUsage()) {
            for (CodeType codeType : src.getUsage()) {
                dest.addUsage(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetLod0MultiSurface()) {
            dest.setLod0MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod0MultiSurface()));
        }
        if (src.isSetLod1MultiSurface()) {
            dest.setLod1MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod1MultiSurface()));
        }
        if (src.isSetLod2MultiSurface()) {
            dest.setLod2MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod2MultiSurface()));
        }
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSet_GenericApplicationPropertyOfLandUse()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfLandUse()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfLandUse(ade);
            }
        }
    }

    public LandUse unmarshalLandUse(LandUseType src) throws MissingADESchemaException {
        LandUse dest = new LandUse(this.module);
        this.unmarshalLandUse(src, dest);
        return dest;
    }

    public boolean assignGenericProperty(ADEGenericElement genericProperty, QName substitutionGroup, AbstractGML dest) {
        String name = substitutionGroup.getLocalPart();
        boolean success = true;
        if (dest instanceof LandUse && name.equals("_GenericApplicationPropertyOfLandUse")) {
            ((LandUse)dest).addGenericApplicationPropertyOfLandUse(genericProperty);
        } else {
            success = false;
        }
        return success;
    }
}

