/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.relief;

import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.opengis.citygml.relief._2.AbstractReliefComponentType;
import net.opengis.citygml.relief._2.BreaklineReliefType;
import net.opengis.citygml.relief._2.GridPropertyType;
import net.opengis.citygml.relief._2.MassPointReliefType;
import net.opengis.citygml.relief._2.RasterReliefType;
import net.opengis.citygml.relief._2.ReliefComponentPropertyType;
import net.opengis.citygml.relief._2.ReliefFeatureType;
import net.opengis.citygml.relief._2.TINReliefType;
import net.opengis.citygml.relief._2.TinPropertyType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.relief.AbstractReliefComponent;
import org.citygml4j.model.citygml.relief.BreaklineRelief;
import org.citygml4j.model.citygml.relief.GridProperty;
import org.citygml4j.model.citygml.relief.MassPointRelief;
import org.citygml4j.model.citygml.relief.RasterRelief;
import org.citygml4j.model.citygml.relief.ReliefComponentProperty;
import org.citygml4j.model.citygml.relief.ReliefFeature;
import org.citygml4j.model.citygml.relief.TINRelief;
import org.citygml4j.model.citygml.relief.TinProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.coverage.RectifiedGridCoverage;
import org.citygml4j.model.gml.geometry.primitives.TriangulatedSurface;
import org.citygml4j.model.gml.xlink.XLinkActuate;
import org.citygml4j.model.gml.xlink.XLinkShow;
import org.citygml4j.model.gml.xlink.XLinkType;
import org.citygml4j.model.module.citygml.ReliefModule;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;

public class Relief200Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ReliefModule module = ReliefModule.v2_0_0;
    private final JAXBUnmarshaller jaxb;
    private final CityGMLUnmarshaller citygml;
    private CheckedTypeMapper<CityGML> typeMapper;

    public Relief200Unmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(BreaklineReliefType.class, this::unmarshalBreaklineRelief).with(GridPropertyType.class, this::unmarshalGridProperty).with(MassPointReliefType.class, this::unmarshalMassPointRelief).with(RasterReliefType.class, this::unmarshalRasterRelief).with(ReliefComponentPropertyType.class, this::unmarshalReliefComponentProperty).with(ReliefFeatureType.class, this::unmarshalReliefFeature).with(TinPropertyType.class, this::unmarshalTinProperty).with(TINReliefType.class, this::unmarshalTINRelief).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalAbstractReliefComponent(AbstractReliefComponentType src, AbstractReliefComponent dest) throws MissingADESchemaException {
        this.citygml.getCore200Unmarshaller().unmarshalAbstractCityObject(src, dest);
        if (src.isSetLod()) {
            dest.setLod(src.getLod());
        }
        if (src.isSetExtent()) {
            dest.setExtent(this.jaxb.getGMLUnmarshaller().unmarshalPolygonProperty(src.getExtent()));
        }
        if (src.isSet_GenericApplicationPropertyOfReliefComponent()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfReliefComponent()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfReliefComponent(ade);
            }
        }
    }

    public void unmarshalBreaklineRelief(BreaklineReliefType src, BreaklineRelief dest) throws MissingADESchemaException {
        this.unmarshalAbstractReliefComponent(src, dest);
        if (src.isSetRidgeOrValleyLines()) {
            dest.setRidgeOrValleyLines(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getRidgeOrValleyLines()));
        }
        if (src.isSetBreaklines()) {
            dest.setBreaklines(this.jaxb.getGMLUnmarshaller().unmarshalMultiCurveProperty(src.getBreaklines()));
        }
        if (src.isSet_GenericApplicationPropertyOfBreaklineRelief()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfBreaklineRelief()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfBreaklineRelief(ade);
            }
        }
    }

    public BreaklineRelief unmarshalBreaklineRelief(BreaklineReliefType src) throws MissingADESchemaException {
        BreaklineRelief dest = new BreaklineRelief(this.module);
        this.unmarshalBreaklineRelief(src, dest);
        return dest;
    }

    public GridProperty unmarshalGridProperty(GridPropertyType src) throws MissingADESchemaException {
        ModelObject object;
        GridProperty dest = new GridProperty();
        if (src.isSet_Object() && (object = this.jaxb.unmarshal(src.get_Object())) instanceof RectifiedGridCoverage) {
            dest.setRectifiedGridCoverage((RectifiedGridCoverage)object);
        }
        if (!this.jaxb.isSkipGenericADEContent() && src.isSet_ADEComponent()) {
            dest.setGenericADEElement(this.jaxb.getADEUnmarshaller().unmarshal(src.get_ADEComponent()));
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public void unmarshalMassPointRelief(MassPointReliefType src, MassPointRelief dest) throws MissingADESchemaException {
        this.unmarshalAbstractReliefComponent(src, dest);
        if (src.isSetReliefPoints()) {
            dest.setReliefPoints(this.jaxb.getGMLUnmarshaller().unmarshalMultiPointProperty(src.getReliefPoints()));
        }
        if (src.isSet_GenericApplicationPropertyOfMassPointRelief()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfMassPointRelief()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfMassPointRelief(ade);
            }
        }
    }

    public MassPointRelief unmarshalMassPointRelief(MassPointReliefType src) throws MissingADESchemaException {
        MassPointRelief dest = new MassPointRelief(this.module);
        this.unmarshalMassPointRelief(src, dest);
        return dest;
    }

    public void unmarshalRasterRelief(RasterReliefType src, RasterRelief dest) throws MissingADESchemaException {
        this.unmarshalAbstractReliefComponent(src, dest);
        if (src.isSetGrid()) {
            dest.setGrid(this.unmarshalGridProperty(src.getGrid()));
        }
        if (src.isSet_GenericApplicationPropertyOfRasterRelief()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfRasterRelief()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfRasterRelief(ade);
            }
        }
    }

    public RasterRelief unmarshalRasterRelief(RasterReliefType src) throws MissingADESchemaException {
        RasterRelief dest = new RasterRelief(this.module);
        this.unmarshalRasterRelief(src, dest);
        return dest;
    }

    public ReliefComponentProperty unmarshalReliefComponentProperty(ReliefComponentPropertyType src) throws MissingADESchemaException {
        ModelObject object;
        ReliefComponentProperty dest = new ReliefComponentProperty();
        if (src.isSet_ReliefComponent() && (object = this.jaxb.unmarshal(src.get_ReliefComponent())) instanceof AbstractReliefComponent) {
            dest.setObject((AbstractReliefComponent)object);
        }
        if (!this.jaxb.isSkipGenericADEContent() && src.isSet_ADEComponent()) {
            dest.setGenericADEElement(this.jaxb.getADEUnmarshaller().unmarshal(src.get_ADEComponent()));
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public void unmarshalReliefFeature(ReliefFeatureType src, ReliefFeature dest) throws MissingADESchemaException {
        this.citygml.getCore200Unmarshaller().unmarshalAbstractCityObject(src, dest);
        if (src.isSetLod()) {
            dest.setLod(src.getLod());
        }
        if (src.isSetReliefComponent()) {
            for (ReliefComponentPropertyType reliefComponentPropertyType : src.getReliefComponent()) {
                dest.addReliefComponent(this.unmarshalReliefComponentProperty(reliefComponentPropertyType));
            }
        }
        if (src.isSet_GenericApplicationPropertyOfReliefFeature()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfReliefFeature()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfReliefFeature(ade);
            }
        }
    }

    public ReliefFeature unmarshalReliefFeature(ReliefFeatureType src) throws MissingADESchemaException {
        ReliefFeature dest = new ReliefFeature(this.module);
        this.unmarshalReliefFeature(src, dest);
        return dest;
    }

    public TinProperty unmarshalTinProperty(TinPropertyType src) throws MissingADESchemaException {
        ModelObject object;
        TinProperty dest = new TinProperty();
        if (src.isSetTriangulatedSurface() && (object = this.jaxb.unmarshal(src.getTriangulatedSurface())) instanceof TriangulatedSurface) {
            dest.setObject((TriangulatedSurface)object);
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public void unmarshalTINRelief(TINReliefType src, TINRelief dest) throws MissingADESchemaException {
        this.unmarshalAbstractReliefComponent(src, dest);
        if (src.isSetTin()) {
            dest.setTin(this.unmarshalTinProperty(src.getTin()));
        }
        if (src.isSet_GenericApplicationPropertyOfTinRelief()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfTinRelief()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfTinRelief(ade);
            }
        }
    }

    public TINRelief unmarshalTINRelief(TINReliefType src) throws MissingADESchemaException {
        TINRelief dest = new TINRelief(this.module);
        this.unmarshalTINRelief(src, dest);
        return dest;
    }

    public boolean assignGenericProperty(ADEGenericElement genericProperty, QName substitutionGroup, AbstractGML dest) {
        String name = substitutionGroup.getLocalPart();
        boolean success = true;
        if (dest instanceof AbstractReliefComponent && name.equals("_GenericApplicationPropertyOfReliefComponent")) {
            ((AbstractReliefComponent)dest).addGenericApplicationPropertyOfReliefComponent(genericProperty);
        } else if (dest instanceof BreaklineRelief && name.equals("_GenericApplicationPropertyOfBreaklineRelief")) {
            ((BreaklineRelief)dest).addGenericApplicationPropertyOfBreaklineRelief(genericProperty);
        } else if (dest instanceof MassPointRelief && name.equals("_GenericApplicationPropertyOfMassPointRelief")) {
            ((MassPointRelief)dest).addGenericApplicationPropertyOfMassPointRelief(genericProperty);
        } else if (dest instanceof RasterRelief && name.equals("_GenericApplicationPropertyOfRasterRelief")) {
            ((RasterRelief)dest).addGenericApplicationPropertyOfRasterRelief(genericProperty);
        } else if (dest instanceof ReliefFeature && name.equals("_GenericApplicationPropertyOfReliefFeature")) {
            ((ReliefFeature)dest).addGenericApplicationPropertyOfReliefFeature(genericProperty);
        } else if (dest instanceof TINRelief && name.equals("_GenericApplicationPropertyOfTinRelief")) {
            ((TINRelief)dest).addGenericApplicationPropertyOfTinRelief(genericProperty);
        } else {
            success = false;
        }
        return success;
    }
}

