/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.texturedsurface;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.texturedsurface._1.AbstractAppearanceType;
import net.opengis.citygml.texturedsurface._1.AppearancePropertyType;
import net.opengis.citygml.texturedsurface._1.MaterialType;
import net.opengis.citygml.texturedsurface._1.SimpleTextureType;
import net.opengis.citygml.texturedsurface._1.TextureTypeType;
import net.opengis.citygml.texturedsurface._1.TexturedSurfaceType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.texturedsurface._AbstractAppearance;
import org.citygml4j.model.citygml.texturedsurface._AppearanceProperty;
import org.citygml4j.model.citygml.texturedsurface._Color;
import org.citygml4j.model.citygml.texturedsurface._Material;
import org.citygml4j.model.citygml.texturedsurface._SimpleTexture;
import org.citygml4j.model.citygml.texturedsurface._TextureType;
import org.citygml4j.model.citygml.texturedsurface._TexturedSurface;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.geometry.primitives.Sign;
import org.citygml4j.model.gml.xlink.XLinkActuate;
import org.citygml4j.model.gml.xlink.XLinkShow;
import org.citygml4j.model.gml.xlink.XLinkType;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;

public class TexturedSurface100Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final JAXBUnmarshaller jaxb;
    private CheckedTypeMapper<CityGML> typeMapper;

    public TexturedSurface100Unmarshaller(CityGMLUnmarshaller citygml) {
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(AppearancePropertyType.class, this::unmarshalAppearanceProperty).with(MaterialType.class, this::unmarshalMaterial).with(SimpleTextureType.class, this::unmarshalSimpleTexture).with(TexturedSurfaceType.class, this::unmarshalTexturedSurface).with(TextureTypeType.class, this::unmarshalTextureType).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalAbstractAppearance(AbstractAppearanceType src, _AbstractAppearance dest) {
        this.jaxb.getGMLUnmarshaller().unmarshalAbstractGML(src, dest);
    }

    public _AppearanceProperty unmarshalAppearanceProperty(AppearancePropertyType src) {
        _AppearanceProperty dest = new _AppearanceProperty();
        if (src.isSetOrientation()) {
            dest.setOrientation(Sign.fromValue(src.getOrientation()));
        }
        if (src.isSet_Appearance()) {
            try {
                ModelObject appearance = this.jaxb.unmarshal(src.get_Appearance());
                if (appearance instanceof _AbstractAppearance) {
                    dest.setAppearance((_AbstractAppearance)appearance);
                }
            }
            catch (MissingADESchemaException missingADESchemaException) {
                // empty catch block
            }
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(XLinkType.fromValue(src.getType().value()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(XLinkShow.fromValue(src.getShow().value()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(XLinkActuate.fromValue(src.getActuate().value()));
        }
        return dest;
    }

    public _Color unmarshalColor(List<Double> src) {
        _Color dest = new _Color();
        dest.setColor(src);
        return dest;
    }

    public void unmarshalMaterial(MaterialType src, _Material dest) {
        this.unmarshalAbstractAppearance(src, dest);
        if (src.isSetShininess()) {
            dest.setShininess(src.getShininess());
        }
        if (src.isSetTransparency()) {
            dest.setTransparency(src.getTransparency());
        }
        if (src.isSetAmbientIntensity()) {
            dest.setAmbientIntensity(src.getAmbientIntensity());
        }
        if (src.isSetSpecularColor()) {
            dest.setSpecularColor(this.unmarshalColor(src.getSpecularColor()));
        }
        if (src.isSetDiffuseColor()) {
            dest.setDiffuseColor(this.unmarshalColor(src.getDiffuseColor()));
        }
        if (src.isSetEmissiveColor()) {
            dest.setEmissiveColor(this.unmarshalColor(src.getEmissiveColor()));
        }
    }

    public _Material unmarshalMaterial(MaterialType src) {
        _Material dest = new _Material();
        this.unmarshalMaterial(src, dest);
        return dest;
    }

    public void unmarshalSimpleTexture(SimpleTextureType src, _SimpleTexture dest) {
        this.unmarshalAbstractAppearance(src, dest);
        if (src.isSetTextureMap()) {
            dest.setTextureMap(src.getTextureMap());
        }
        if (src.isSetTextureCoordinates()) {
            dest.setTextureCoordinates(src.getTextureCoordinates());
        }
        if (src.isSetTextureType()) {
            dest.setTextureType(this.unmarshalTextureType(src.getTextureType()));
        }
        if (src.isSetRepeat()) {
            dest.setRepeat(src.isRepeat());
        }
    }

    public _SimpleTexture unmarshalSimpleTexture(SimpleTextureType src) {
        _SimpleTexture dest = new _SimpleTexture();
        this.unmarshalSimpleTexture(src, dest);
        return dest;
    }

    public void unmarshalTexturedSurface(TexturedSurfaceType src, _TexturedSurface dest) {
        this.jaxb.getGMLUnmarshaller().unmarshalOrientableSurface(src, dest);
        if (src.isSetAppearance()) {
            for (AppearancePropertyType appearanceProperty : src.getAppearance()) {
                dest.addAppearance(this.unmarshalAppearanceProperty(appearanceProperty));
            }
        }
    }

    public _TexturedSurface unmarshalTexturedSurface(TexturedSurfaceType src) {
        _TexturedSurface dest = new _TexturedSurface();
        this.unmarshalTexturedSurface(src, dest);
        return dest;
    }

    public _TextureType unmarshalTextureType(TextureTypeType src) {
        return _TextureType.fromValue(src.value());
    }
}

