/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.xml.io.reader.CityGMLNamespaceMapper;
import org.citygml4j.builder.jaxb.xml.io.reader.JAXBInputFactory;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLElementChecker;
import org.citygml4j.builder.jaxb.xml.validation.ValidationSchemaHandler;
import org.citygml4j.util.internal.xml.TransformerChainFactory;
import org.citygml4j.xml.io.reader.CityGMLInputFilter;
import org.citygml4j.xml.io.reader.CityGMLReadException;
import org.citygml4j.xml.io.reader.FeatureReadMode;
import org.citygml4j.xml.schema.SchemaHandler;
import org.xml.sax.SAXException;

public abstract class AbstractJAXBReader {
    final XMLStreamReader reader;
    final InputStream in;
    JAXBInputFactory factory;
    SchemaHandler schemaHandler;
    JAXBUnmarshaller jaxbUnmarshaller;
    XMLElementChecker elementChecker;
    TransformerChainFactory transformerChainFactory;
    boolean useValidation;
    boolean parseSchema;
    ValidationSchemaHandler validationSchemaHandler;
    ValidationEventHandler validationEventHandler;
    CityGMLInputFilter filter;
    URI baseURI;

    public AbstractJAXBReader(XMLStreamReader reader, InputStream in, JAXBInputFactory factory, URI baseURI) throws CityGMLReadException {
        if (((Boolean)factory.getProperty("org.citygml4j.supportCityGML040")).booleanValue()) {
            reader = new CityGMLNamespaceMapper(reader);
        }
        this.reader = reader;
        this.in = in;
        this.factory = factory;
        this.baseURI = baseURI;
        this.transformerChainFactory = factory.getTransformerChainFactory();
        this.parseSchema = (Boolean)factory.getProperty("org.citygml4j.parseSchema");
        this.useValidation = (Boolean)factory.getProperty("org.citygml4j.useValidation");
        boolean failOnMissingADESchema = (Boolean)factory.getProperty("org.citygml4j.failOnMissingADESchema");
        this.schemaHandler = factory.getSchemaHandler();
        this.jaxbUnmarshaller = factory.builder.createJAXBUnmarshaller(this.schemaHandler);
        this.jaxbUnmarshaller.setThrowMissingADESchema(failOnMissingADESchema);
        this.jaxbUnmarshaller.setSkipGenericADEContent((Boolean)factory.getProperty("org.citygml4j.skipGenericADEContent"));
        this.elementChecker = new XMLElementChecker(this.schemaHandler, (FeatureReadMode)((Object)factory.getProperty("org.citygml4j.featureReadMode")), (Boolean)factory.getProperty("org.citygml4j.keepInlineAppearance"), this.parseSchema, failOnMissingADESchema, (List)factory.getProperty("org.citygml4j.excludeFromSplitting"), (List)factory.getProperty("org.citygml4j.splitAtFeatureProperty"));
        if (this.useValidation) {
            this.validationSchemaHandler = new ValidationSchemaHandler(this.schemaHandler);
            this.validationEventHandler = factory.getValidationEventHandler();
        }
    }

    public void close() throws CityGMLReadException {
        try {
            this.factory = null;
            this.schemaHandler = null;
            this.jaxbUnmarshaller = null;
            this.elementChecker = null;
            this.validationSchemaHandler = null;
            this.validationEventHandler = null;
            this.filter = null;
            if (this.reader != null) {
                this.reader.close();
                this.in.close();
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
    }

    public boolean isFilteredReader() {
        return this.filter != null;
    }

    public String getBaseURI() {
        return this.baseURI.toString();
    }

    void parseSchema(String schemaLocation) throws SAXException {
        String[] split = schemaLocation.trim().split("\\s+");
        if (split.length % 2 == 0) {
            for (int i = 0; i < split.length; i += 2) {
                this.schemaHandler.parseSchema(split[i], this.baseURI.resolve(split[i + 1]).toString());
            }
        }
    }
}

