/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.CityGMLBuilderException;
import org.citygml4j.builder.jaxb.xml.io.reader.AbstractJAXBReader;
import org.citygml4j.builder.jaxb.xml.io.reader.JAXBChunkReader;
import org.citygml4j.builder.jaxb.xml.io.reader.JAXBSimpleReader;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.internal.xml.SystemIDResolver;
import org.citygml4j.util.internal.xml.TransformerChainFactory;
import org.citygml4j.xml.io.CityGMLInputFactory;
import org.citygml4j.xml.io.reader.CityGMLInputFilter;
import org.citygml4j.xml.io.reader.CityGMLReadException;
import org.citygml4j.xml.io.reader.CityGMLReader;
import org.citygml4j.xml.io.reader.FeatureReadMode;
import org.citygml4j.xml.io.writer.CityGMLWriteException;
import org.citygml4j.xml.schema.SchemaHandler;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JAXBInputFactory
implements CityGMLInputFactory {
    final CityGMLBuilder builder;
    private final List<QName> excludes;
    private final List<QName> splitAtFeatureProperties;
    private SchemaHandler schemaHandler;
    private XMLInputFactory xmlInputFactory;
    private GMLIdManager gmlIdManager;
    private ValidationEventHandler validationEventHandler;
    private TransformerChainFactory transformerChainFactory;
    private FeatureReadMode featureReadMode;
    private boolean keepInlineAppearance;
    private boolean parseSchema;
    private boolean useValidation;
    private boolean failOnMissingADESchema;
    private boolean skipGenericADEContent;
    private boolean supportCityGML040;

    public JAXBInputFactory(CityGMLBuilder builder, SchemaHandler schemaHandler) {
        this.builder = builder;
        this.schemaHandler = schemaHandler;
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.gmlIdManager = DefaultGMLIdManager.getInstance();
        this.validationEventHandler = null;
        this.featureReadMode = FeatureReadMode.NO_SPLIT;
        this.excludes = new ArrayList<QName>();
        this.splitAtFeatureProperties = new ArrayList<QName>();
        this.keepInlineAppearance = true;
        this.parseSchema = true;
        this.failOnMissingADESchema = true;
    }

    public JAXBInputFactory(CityGMLBuilder builder) throws CityGMLBuilderException {
        this(builder, builder.getDefaultSchemaHandler());
    }

    @Override
    public CityGMLReader createCityGMLReader(String systemId, InputStream in) throws CityGMLReadException {
        try {
            XMLStreamReader streamReader = this.xmlInputFactory.createXMLStreamReader(systemId, in);
            URI baseURI = this.toURI(systemId != null ? SystemIDResolver.getAbsoluteURI(systemId) : null);
            switch (this.featureReadMode) {
                case SPLIT_PER_COLLECTION_MEMBER: 
                case SPLIT_PER_FEATURE: {
                    return new JAXBChunkReader(streamReader, in, this, baseURI);
                }
            }
            return new JAXBSimpleReader(streamReader, in, this, baseURI);
        }
        catch (XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLReader createCityGMLReader(String systemId, InputStream in, String encoding) throws CityGMLReadException {
        try {
            XMLStreamReader streamReader = this.xmlInputFactory.createXMLStreamReader(in, encoding);
            URI baseURI = this.toURI(systemId != null ? SystemIDResolver.getAbsoluteURI(systemId) : null);
            switch (this.featureReadMode) {
                case SPLIT_PER_COLLECTION_MEMBER: 
                case SPLIT_PER_FEATURE: {
                    return new JAXBChunkReader(streamReader, in, this, baseURI);
                }
            }
            return new JAXBSimpleReader(streamReader, in, this, baseURI);
        }
        catch (XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLReader createCityGMLReader(File file, String encoding) throws CityGMLReadException {
        try {
            FileInputStream in = new FileInputStream(file);
            XMLStreamReader streamReader = this.xmlInputFactory.createXMLStreamReader(in, encoding);
            switch (this.featureReadMode) {
                case SPLIT_PER_COLLECTION_MEMBER: 
                case SPLIT_PER_FEATURE: {
                    return new JAXBChunkReader(streamReader, in, this, file.toURI().normalize());
                }
            }
            return new JAXBSimpleReader(streamReader, in, this, file.toURI().normalize());
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLReader createCityGMLReader(File file) throws CityGMLReadException {
        try {
            FileInputStream in = new FileInputStream(file);
            XMLStreamReader streamReader = this.xmlInputFactory.createXMLStreamReader(in);
            switch (this.featureReadMode) {
                case SPLIT_PER_COLLECTION_MEMBER: 
                case SPLIT_PER_FEATURE: {
                    return new JAXBChunkReader(streamReader, in, this, file.toURI().normalize());
                }
            }
            return new JAXBSimpleReader(streamReader, in, this, file.toURI().normalize());
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLReader createFilteredCityGMLReader(CityGMLReader reader, CityGMLInputFilter filter) {
        if (!(reader instanceof AbstractJAXBReader)) {
            throw new IllegalArgumentException("CityGML reader must be a JAXB based reader.");
        }
        ((AbstractJAXBReader)((Object)reader)).filter = filter;
        return reader;
    }

    @Override
    public XMLInputFactory getXMLInputFactory() {
        return this.xmlInputFactory;
    }

    @Override
    public void setXMLInputFactory(XMLInputFactory xmlInputFactory) {
        if (xmlInputFactory == null) {
            throw new IllegalArgumentException("xml input factory may not be null.");
        }
        this.xmlInputFactory = xmlInputFactory;
    }

    @Override
    public GMLIdManager getGMLIdManager() {
        return this.gmlIdManager;
    }

    @Override
    public void setGMLIdManager(GMLIdManager gmlIdManager) {
        if (gmlIdManager == null) {
            throw new IllegalArgumentException("gml:id manager may not be null.");
        }
        this.gmlIdManager = gmlIdManager;
    }

    @Override
    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    @Override
    public void setSchemaHandler(SchemaHandler schemaHandler) {
        if (schemaHandler == null) {
            throw new IllegalArgumentException("schema handler may not be null.");
        }
        this.schemaHandler = schemaHandler;
    }

    @Override
    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    @Override
    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        if (validationEventHandler == null) {
            throw new IllegalArgumentException("validation event handler may not be null.");
        }
        this.validationEventHandler = validationEventHandler;
    }

    @Override
    public void setTransformationTemplates(Templates ... transformationTemplates) throws CityGMLWriteException {
        if (transformationTemplates == null) {
            throw new IllegalArgumentException("transformation templates may not be null.");
        }
        try {
            if (this.transformerChainFactory == null) {
                this.transformerChainFactory = new TransformerChainFactory(transformationTemplates);
            } else {
                this.transformerChainFactory.updateTemplates(transformationTemplates);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public Templates[] getTransformationTemplates() {
        return this.transformerChainFactory == null ? null : this.transformerChainFactory.getTemplates();
    }

    public TransformerChainFactory getTransformerChainFactory() {
        return this.transformerChainFactory;
    }

    @Override
    public Object getProperty(String name) {
        Objects.requireNonNull(name, "property name may not be null.");
        if (name.equals("org.citygml4j.featureReadMode")) {
            return this.featureReadMode;
        }
        if (name.equals("org.citygml4j.keepInlineAppearance")) {
            return this.keepInlineAppearance;
        }
        if (name.equals("org.citygml4j.parseSchema")) {
            return this.parseSchema;
        }
        if (name.equals("org.citygml4j.useValidation")) {
            return this.useValidation;
        }
        if (name.equals("org.citygml4j.excludeFromSplitting")) {
            return this.excludes;
        }
        if (name.equals("org.citygml4j.splitAtFeatureProperty")) {
            return this.splitAtFeatureProperties;
        }
        if (name.equals("org.citygml4j.failOnMissingADESchema")) {
            return this.failOnMissingADESchema;
        }
        if (name.equals("org.citygml4j.skipGenericADEContent")) {
            return this.skipGenericADEContent;
        }
        if (name.equals("org.citygml4j.supportCityGML040")) {
            return this.supportCityGML040;
        }
        throw new IllegalArgumentException("the property '" + name + "' is not supported.");
    }

    @Override
    public void setProperty(String name, Object value) {
        Objects.requireNonNull(name, "property name may not be null.");
        if (name.equals("org.citygml4j.featureReadMode")) {
            FeatureReadMode mode = FeatureReadMode.fromValue(value.toString());
            if (mode != null) {
                this.featureReadMode = mode;
            }
            return;
        }
        if (name.equals("org.citygml4j.keepInlineAppearance")) {
            if (value instanceof Boolean) {
                this.keepInlineAppearance = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.parseSchema")) {
            if (value instanceof Boolean) {
                this.parseSchema = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.useValidation")) {
            if (value instanceof Boolean) {
                this.useValidation = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.excludeFromSplitting")) {
            if (value instanceof QName) {
                this.excludes.add((QName)value);
                return;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (o instanceof QName) {
                        this.excludes.add((QName)o);
                        continue;
                    }
                    throw new IllegalArgumentException("exclude must be of type java.xml.namespace.QName.");
                }
                return;
            }
            if (value instanceof Object[]) {
                for (Object o : (Object[])value) {
                    if (!(o instanceof QName)) {
                        throw new IllegalArgumentException("exclude must be of type java.xml.namespace.QName.");
                    }
                    this.excludes.add((QName)o);
                }
                return;
            }
        }
        if (name.equals("org.citygml4j.splitAtFeatureProperty")) {
            if (value instanceof QName) {
                this.splitAtFeatureProperties.add((QName)value);
                return;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (o instanceof QName) {
                        this.splitAtFeatureProperties.add((QName)o);
                        continue;
                    }
                    throw new IllegalArgumentException("feature property must be specified using java.xml.namespace.QName.");
                }
                return;
            }
            if (value instanceof Object[]) {
                for (Object o : (Object[])value) {
                    if (!(o instanceof QName)) {
                        throw new IllegalArgumentException("feature property must be specified using java.xml.namespace.QName.");
                    }
                    this.splitAtFeatureProperties.add((QName)o);
                }
                return;
            }
        }
        if (name.equals("org.citygml4j.failOnMissingADESchema")) {
            if (value instanceof Boolean) {
                this.failOnMissingADESchema = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.skipGenericADEContent")) {
            if (value instanceof Boolean) {
                this.skipGenericADEContent = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.supportCityGML040")) {
            if (value instanceof Boolean) {
                this.supportCityGML040 = (Boolean)value;
            }
            return;
        }
        throw new IllegalArgumentException("the key-value pair '" + name + " - " + value.getClass().getName() + "' is not supported.");
    }

    @Override
    public boolean registerSchemaLocation(String namespaceURI, File schemaLocation) {
        return this.schemaHandler.registerSchemaLocation(namespaceURI, schemaLocation);
    }

    @Override
    public void parseSchema(File schemaLocation) throws SAXException {
        this.schemaHandler.parseSchema(schemaLocation);
    }

    @Override
    public void parseSchema(String namespaceURI, String schemaLocation) throws SAXException {
        this.schemaHandler.parseSchema(namespaceURI, schemaLocation);
    }

    @Override
    public void parseSchema(Element element) throws SAXException {
        this.schemaHandler.parseSchema(element);
    }

    private URI toURI(String baseURI) {
        URI uri;
        try {
            uri = new URI(baseURI).normalize();
        }
        catch (Exception e) {
            uri = URI.create("");
        }
        return uri;
    }
}

