/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.io.InputStream;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.builder.jaxb.xml.io.reader.AbstractJAXBReader;
import org.citygml4j.builder.jaxb.xml.io.reader.JAXBInputFactory;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLChunkImpl;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLElementChecker;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.util.internal.xml.TransformerChain;
import org.citygml4j.util.xml.SAXEventBuffer;
import org.citygml4j.util.xml.StAXStream2SAX;
import org.citygml4j.xml.io.reader.CityGMLReadException;
import org.citygml4j.xml.io.reader.CityGMLReader;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.io.reader.ParentInfo;
import org.citygml4j.xml.io.reader.XMLChunk;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JAXBSimpleReader
extends AbstractJAXBReader
implements CityGMLReader {
    private boolean iterator;
    private XMLElementChecker.ElementInfo elementInfo;

    public JAXBSimpleReader(XMLStreamReader reader, InputStream in, JAXBInputFactory factory, URI baseURI) throws CityGMLReadException {
        super(reader, in, factory, baseURI);
        this.jaxbUnmarshaller.setParseSchema(this.parseSchema);
    }

    @Override
    public void close() throws CityGMLReadException {
        super.close();
        this.elementInfo = null;
    }

    @Override
    public boolean hasNext() throws CityGMLReadException {
        this.iterator = false;
        this.elementInfo = null;
        try {
            while (this.reader.hasNext()) {
                if (this.reader.getEventType() == 1) {
                    if (this.parseSchema) {
                        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                            if (this.reader.getAttributeLocalName(i).equals("schemaLocation")) {
                                this.parseSchema(this.reader.getAttributeValue(i));
                                continue;
                            }
                            if (!this.reader.getAttributeLocalName(i).equals("noNamespaceSchemaLocation")) continue;
                            this.schemaHandler.parseSchema("", this.reader.getAttributeValue(i));
                        }
                    }
                    this.elementInfo = this.elementChecker.getElementInfo(this.reader.getName());
                    if (this.elementInfo != null && this.elementInfo.isFeature()) {
                        if (!this.isFilteredReader() || this.filter.accept(this.reader.getName())) {
                            this.iterator = true;
                            break;
                        }
                        int depth = 1;
                        while (depth > 0) {
                            this.reader.next();
                            if (this.reader.getEventType() == 1) {
                                ++depth;
                                continue;
                            }
                            if (this.reader.getEventType() != 2) continue;
                            --depth;
                        }
                    }
                }
                this.reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
        catch (SAXException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
        catch (MissingADESchemaException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
        return this.iterator;
    }

    @Override
    public CityGML nextFeature() throws CityGMLReadException {
        CityGML next = null;
        if (this.iterator || this.hasNext()) {
            try {
                ModelObject citygml;
                Object result;
                Unmarshaller unmarshaller = this.factory.builder.getJAXBContext().createUnmarshaller();
                if (this.useValidation) {
                    unmarshaller.setSchema(this.validationSchemaHandler.getSchema());
                    if (this.validationEventHandler != null) {
                        unmarshaller.setEventHandler(this.validationEventHandler);
                    }
                }
                if (this.transformerChainFactory == null) {
                    result = unmarshaller.unmarshal(this.reader);
                } else {
                    UnmarshallerHandler handler = unmarshaller.getUnmarshallerHandler();
                    TransformerChain chain = this.transformerChainFactory.buildChain();
                    chain.tail().setResult(new SAXResult((ContentHandler)handler));
                    SAXEventBuffer buffer = new SAXEventBuffer();
                    StAXStream2SAX mapper = new StAXStream2SAX(buffer);
                    mapper.bridgeEvent(this.reader);
                    int depth = 1;
                    while (depth > 0) {
                        this.reader.next();
                        mapper.bridgeEvent(this.reader);
                        if (this.reader.getEventType() == 1) {
                            ++depth;
                            continue;
                        }
                        if (this.reader.getEventType() != 2) continue;
                        --depth;
                    }
                    chain.head().startDocument();
                    buffer.send(chain.head(), true);
                    chain.head().endDocument();
                    result = handler.getResult();
                }
                if (result instanceof JAXBElement && (citygml = this.jaxbUnmarshaller.unmarshal((JAXBElement)result)) instanceof AbstractFeature) {
                    next = (CityGML)citygml;
                }
            }
            catch (JAXBException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
            catch (SAXException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
            catch (MissingADESchemaException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
            catch (TransformerConfigurationException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
            catch (XMLStreamException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
        }
        if (next == null) {
            throw new NoSuchElementException();
        }
        this.iterator = false;
        return next;
    }

    @Override
    public XMLChunk nextChunk() throws CityGMLReadException {
        XMLChunkImpl next = null;
        if (this.iterator || this.hasNext()) {
            try {
                next = new XMLChunkImpl(this, null);
                while (this.reader.hasNext()) {
                    next.addEvent(this.reader);
                    if (!next.isComplete()) {
                        this.reader.next();
                        continue;
                    }
                    break;
                }
            }
            catch (XMLStreamException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
        }
        if (next == null) {
            throw new NoSuchElementException();
        }
        this.iterator = false;
        return next;
    }

    @Override
    public boolean isSetParentInfo() {
        return false;
    }

    @Override
    public ParentInfo getParentInfo() {
        return null;
    }
}

