/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.builder.jaxb.xml.io.reader.AbstractJAXBReader;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLElementChecker;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.base.MetaDataProperty;
import org.citygml4j.model.gml.base.StringOrRef;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.feature.LocationProperty;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.util.internal.xml.TransformerChain;
import org.citygml4j.util.xml.SAXEventBuffer;
import org.citygml4j.util.xml.StAXStream2SAX;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.io.reader.ParentInfo;
import org.citygml4j.xml.io.reader.UnmarshalException;
import org.citygml4j.xml.io.reader.XMLChunk;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLChunkImpl
implements XMLChunk {
    private final AbstractJAXBReader jaxbReader;
    private final XMLChunkImpl parentChunk;
    private final SAXEventBuffer buffer;
    private final StAXStream2SAX stax2sax;
    private CityGML citygml;
    private ParentInfo featureInfo;
    private CityGMLClass type = CityGMLClass.UNDEFINED;
    private QName firstElement;
    private AtomicBoolean parentInfoResolved = new AtomicBoolean(false);
    private AtomicBoolean citygmlResolved = new AtomicBoolean(false);
    private AtomicBoolean typeResolved = new AtomicBoolean(false);
    private boolean isFiltered = false;
    private int depth = 0;
    private boolean hasPassedXMLValidation = false;

    XMLChunkImpl(AbstractJAXBReader chunkReader, XMLChunkImpl parentChunk) {
        this.jaxbReader = chunkReader;
        this.parentChunk = parentChunk;
        this.buffer = new SAXEventBuffer();
        this.stax2sax = new StAXStream2SAX(this.buffer);
    }

    @Override
    public QName getTypeName() {
        return this.firstElement;
    }

    @Override
    public boolean isSetParentInfo() {
        return this.getParentInfo() != null;
    }

    @Override
    public ParentInfo getParentInfo() {
        return this.parentChunk != null ? this.parentChunk.unmarshalFeatureInfo() : null;
    }

    @Override
    public boolean hasPassedXMLValidation() {
        return this.hasPassedXMLValidation;
    }

    protected void removeTrailingCharacters() {
        this.buffer.removeTrailingCharacters();
    }

    protected boolean isComplete() {
        return this.depth == 0 && !this.buffer.isEmpty();
    }

    protected boolean isFiltered() {
        return this.isFiltered;
    }

    protected void setIsFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
    }

    protected void setFirstElement(QName firstElement) {
        this.firstElement = firstElement;
    }

    protected void addEvent(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        if (this.buffer.isEmpty() && event != 1) {
            throw new XMLStreamException("chunk expects a START_ELEMENT as first element.");
        }
        if (this.isComplete() && (event == 1 || event == 2)) {
            throw new XMLStreamException("chunk does not accept further START_ELEMENT or END_ELEMENT events.");
        }
        this.stax2sax.bridgeEvent(reader);
        switch (event) {
            case 1: {
                ++this.depth;
                break;
            }
            case 2: {
                --this.depth;
            }
        }
    }

    protected void addAttribute(String uri, String localName, String prefix, String type, String value) {
        this.buffer.addAttribute(uri, localName, prefix, type, value);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        if (this.citygmlResolved.get()) {
            return this.citygml.getCityGMLClass();
        }
        if (this.typeResolved.compareAndSet(false, true)) {
            try {
                XMLElementChecker.ElementInfo info = this.jaxbReader.elementChecker.getElementInfo(this.firstElement);
                if (info != null) {
                    this.type = info.getFeatureClass() != null && this.jaxbReader.elementChecker.isCityGMLElement(this.firstElement) && CityGML.class.isAssignableFrom(info.getFeatureClass()) ? CityGMLClass.fromModelClass(info.getFeatureClass().asSubclass(CityGML.class)) : CityGMLClass.ADE_COMPONENT;
                }
            }
            catch (MissingADESchemaException missingADESchemaException) {
                // empty catch block
            }
        }
        return this.type;
    }

    @Override
    public void send(ContentHandler handler, boolean release) throws SAXException {
        if (this.citygmlResolved.get()) {
            throw new IllegalStateException("Unmarshalled chunks cannot be forwarded to a ContentHandler.");
        }
        this.buffer.send(handler, release);
    }

    private ParentInfo unmarshalFeatureInfo() {
        if (!this.buffer.isEmpty() && this.parentInfoResolved.compareAndSet(false, true)) {
            try {
                final SAXEventBuffer tmp = new SAXEventBuffer();
                ContentHandler handler = new ContentHandler(){
                    int depth = 0;
                    boolean captureElements = true;

                    @Override
                    public void startPrefixMapping(String prefix, String uri) throws SAXException {
                        tmp.startPrefixMapping(prefix, uri);
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                        if (this.depth == 1) {
                            this.captureElements = ((XMLChunkImpl)XMLChunkImpl.this).jaxbReader.elementChecker.isParentInfoElement(uri, localName);
                        }
                        if (this.captureElements) {
                            tmp.startElement(uri, localName, qName, atts);
                        }
                        ++this.depth;
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.captureElements) {
                            tmp.endElement(uri, localName, qName);
                        }
                        --this.depth;
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.captureElements) {
                            tmp.characters(ch, start, length);
                        }
                    }

                    @Override
                    public void endDocument() throws SAXException {
                        tmp.addEndElement();
                        if (this.captureElements) {
                            tmp.addEndElement();
                        }
                    }

                    @Override
                    public void startDocument() throws SAXException {
                    }

                    @Override
                    public void skippedEntity(String name) throws SAXException {
                    }

                    @Override
                    public void setDocumentLocator(Locator locator) {
                    }

                    @Override
                    public void processingInstruction(String target, String data) throws SAXException {
                    }

                    @Override
                    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    }

                    @Override
                    public void endPrefixMapping(String prefix) throws SAXException {
                    }
                };
                this.buffer.send(handler, false);
                handler.endDocument();
                CityGML citygml = this.unmarshal(tmp, false);
                if (citygml instanceof AbstractFeature) {
                    this.featureInfo = new FeatureInfoImpl((AbstractFeature)((Object)citygml));
                }
            }
            catch (MissingADESchemaException | UnmarshalException | SAXException exception) {
                // empty catch block
            }
        }
        return this.featureInfo;
    }

    @Override
    public CityGML unmarshal() throws UnmarshalException, MissingADESchemaException {
        if (this.citygmlResolved.compareAndSet(false, true)) {
            this.citygml = this.unmarshal(this.buffer, this.jaxbReader.useValidation);
        }
        return this.citygml;
    }

    private CityGML unmarshal(SAXEventBuffer buffer, boolean useValidation) throws UnmarshalException, MissingADESchemaException {
        try {
            CityGML citygml = null;
            QName fakeRoot = this.getFakeRoot();
            Unmarshaller unmarshaller = this.jaxbReader.factory.builder.getJAXBContext().createUnmarshaller();
            if (useValidation) {
                this.hasPassedXMLValidation = true;
                unmarshaller.setSchema(this.jaxbReader.validationSchemaHandler.getSchema());
                if (this.jaxbReader.validationEventHandler != null) {
                    unmarshaller.setEventHandler(new ValidationEventHandler(){

                        public boolean handleEvent(ValidationEvent event) {
                            XMLChunkImpl.this.hasPassedXMLValidation = false;
                            return ((XMLChunkImpl)XMLChunkImpl.this).jaxbReader.validationEventHandler.handleEvent(event);
                        }
                    });
                }
            }
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            Object contentHandler = null;
            if (this.jaxbReader.transformerChainFactory == null) {
                contentHandler = unmarshallerHandler;
            } else {
                TransformerChain chain = this.jaxbReader.transformerChainFactory.buildChain();
                chain.tail().setResult(new SAXResult((ContentHandler)unmarshallerHandler));
                contentHandler = chain.head();
            }
            contentHandler.startDocument();
            if (fakeRoot != null) {
                contentHandler.startElement(fakeRoot.getNamespaceURI(), fakeRoot.getLocalPart(), "", new AttributesImpl());
            }
            buffer.send((ContentHandler)contentHandler, true);
            if (fakeRoot != null) {
                contentHandler.endElement(fakeRoot.getNamespaceURI(), fakeRoot.getLocalPart(), "");
            }
            contentHandler.endDocument();
            Object result = unmarshallerHandler.getResult();
            unmarshaller = null;
            unmarshallerHandler = null;
            if (result instanceof JAXBElement) {
                ModelObject gml = this.jaxbReader.jaxbUnmarshaller.unmarshal((JAXBElement)result);
                if (gml instanceof AbstractFeature) {
                    citygml = (CityGML)gml;
                } else if (gml instanceof AppearanceProperty) {
                    Appearance appearance = ((AppearanceProperty)gml).getAppearance();
                    appearance.unsetParent();
                    citygml = appearance;
                } else if (gml instanceof FeatureProperty) {
                    FeatureProperty property = (FeatureProperty)gml;
                    if (property.isSetFeature()) {
                        Object feature = property.getFeature();
                        ((AbstractGML)feature).unsetParent();
                        citygml = (CityGML)feature;
                    } else {
                        citygml = ((FeatureProperty)gml).getGenericADEElement();
                    }
                }
            }
            return citygml;
        }
        catch (JAXBException | TransformerConfigurationException | SAXException e) {
            throw new UnmarshalException("Unmarshal exception caused by: ", e);
        }
    }

    private QName getFakeRoot() {
        if (!this.jaxbReader.elementChecker.isCityGMLElement(this.firstElement.getNamespaceURI())) {
            return new QName(GMLCoreModule.v3_1_1.getNamespaceURI(), "featureProperty");
        }
        if (this.firstElement.getLocalPart().equals("Appearance")) {
            return new QName(this.firstElement.getNamespaceURI(), "appearanceMember");
        }
        return null;
    }

    private final class FeatureInfoImpl
    implements ParentInfo {
        private final AbstractFeature feature;

        private FeatureInfoImpl(AbstractFeature feature) {
            this.feature = feature;
        }

        @Override
        public boolean isSetId() {
            return this.feature.isSetId();
        }

        @Override
        public String getId() {
            return this.feature.getId();
        }

        @Override
        public boolean isSetName() {
            return this.feature.isSetName();
        }

        @Override
        public List<Code> getName() {
            return this.feature.getName();
        }

        @Override
        public boolean isSetDescription() {
            return this.feature.isSetDescription();
        }

        @Override
        public StringOrRef getDescription() {
            return this.feature.getDescription();
        }

        @Override
        public boolean isSetMetaDataProperty() {
            return this.feature.isSetMetaDataProperty();
        }

        @Override
        public List<MetaDataProperty> getMetaDataProperty() {
            return this.feature.getMetaDataProperty();
        }

        @Override
        public boolean isSetBoundedBy() {
            return this.feature.isSetBoundedBy();
        }

        @Override
        public BoundingShape getBoundedBy() {
            return this.feature.getBoundedBy();
        }

        @Override
        public boolean isSetLocation() {
            return this.feature.isSetLocation();
        }

        @Override
        public LocationProperty getLocation() {
            return this.feature.getLocation();
        }

        @Override
        public boolean isSetAppearance() {
            if (this.feature instanceof AbstractCityObject) {
                return ((AbstractCityObject)this.feature).isSetAppearance();
            }
            if (this.feature instanceof CityModel) {
                return ((CityModel)this.feature).isSetAppearanceMember();
            }
            return false;
        }

        @Override
        public List<? extends AppearanceProperty> getAppearance() {
            if (this.feature instanceof AbstractCityObject) {
                return ((AbstractCityObject)this.feature).getAppearance();
            }
            if (this.feature instanceof CityModel) {
                return ((CityModel)this.feature).getAppearanceMember();
            }
            return null;
        }

        @Override
        public CityGMLClass getCityGMLClass() {
            return this.feature instanceof CityGML ? ((CityGML)((Object)this.feature)).getCityGMLClass() : CityGMLClass.UNDEFINED;
        }

        @Override
        public boolean isSetParentInfo() {
            return this.getParentInfo() != null;
        }

        @Override
        public ParentInfo getParentInfo() {
            return XMLChunkImpl.this.parentChunk != null ? XMLChunkImpl.this.parentChunk.unmarshalFeatureInfo() : null;
        }
    }
}

