/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.xml.io.writer.JAXBModelWriter;
import org.citygml4j.builder.jaxb.xml.io.writer.JAXBSimpleWriter;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.citygml.CityGMLVersion;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.internal.xml.TransformerChainFactory;
import org.citygml4j.util.xml.SAXWriter;
import org.citygml4j.xml.io.CityGMLOutputFactory;
import org.citygml4j.xml.io.writer.CityGMLWriteException;
import org.citygml4j.xml.io.writer.CityGMLWriter;
import org.citygml4j.xml.io.writer.CityModelWriter;
import org.citygml4j.xml.io.writer.FeatureWriteMode;
import org.citygml4j.xml.schema.SchemaHandler;

public class JAXBOutputFactory
implements CityGMLOutputFactory {
    CityGMLBuilder builder;
    private SchemaHandler schemaHandler;
    private ModuleContext moduleContext;
    private GMLIdManager gmlIdManager;
    private ValidationEventHandler validationEventHandler;
    private TransformerChainFactory transformerChainFactory;
    private FeatureWriteMode featureWriteMode;
    private Set<Class<? extends CityGML>> excludes;
    private boolean keepInlineAppearance;
    private boolean splitCopy;
    private boolean useValidation;

    public JAXBOutputFactory(CityGMLBuilder builder, ModuleContext moduleContext, SchemaHandler schemaHandler) {
        this.builder = builder;
        this.schemaHandler = schemaHandler;
        this.moduleContext = moduleContext;
        this.gmlIdManager = DefaultGMLIdManager.getInstance();
        this.featureWriteMode = FeatureWriteMode.NO_SPLIT;
        this.excludes = new HashSet<Class<? extends CityGML>>();
        this.keepInlineAppearance = true;
        this.splitCopy = true;
    }

    public JAXBOutputFactory(CityGMLBuilder builder) {
        this(builder, new ModuleContext(), null);
    }

    public JAXBOutputFactory(CityGMLBuilder builder, ModuleContext moduleContext) {
        this(builder, moduleContext, null);
    }

    public JAXBOutputFactory(CityGMLBuilder builder, SchemaHandler schemaHandler) {
        this(builder, new ModuleContext(), schemaHandler);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(File file, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new JAXBSimpleWriter(new SAXWriter(new OutputStreamWriter(new FileOutputStream(file))), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(File file, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new JAXBSimpleWriter(new SAXWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding)), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(OutputStream outputStream, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBSimpleWriter(new SAXWriter(outputStream), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(OutputStream outputStream, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBSimpleWriter(new SAXWriter(outputStream, encoding), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(StreamResult streamResult, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBSimpleWriter(new SAXWriter(streamResult, encoding), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(Writer writer, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBSimpleWriter(new SAXWriter(writer), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityGMLWriter createCityGMLWriter(File file, String encoding) throws CityGMLWriteException {
        return this.createCityGMLWriter(file, encoding, this.moduleContext);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(File file) throws CityGMLWriteException {
        return this.createCityGMLWriter(file, this.moduleContext);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(OutputStream outputStream, String encoding) throws CityGMLWriteException {
        return this.createCityGMLWriter(outputStream, encoding, this.moduleContext);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(OutputStream outputStream) throws CityGMLWriteException {
        return this.createCityGMLWriter(outputStream, this.moduleContext);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(StreamResult streamResult, String encoding) throws CityGMLWriteException {
        return this.createCityGMLWriter(streamResult, encoding, this.moduleContext);
    }

    @Override
    public CityGMLWriter createCityGMLWriter(Writer writer) throws CityGMLWriteException {
        return this.createCityGMLWriter(writer, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(File file, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new JAXBModelWriter(new SAXWriter(new OutputStreamWriter(new FileOutputStream(file))), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(File file, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            this.createParentDirectories(file.toPath());
            return new JAXBModelWriter(new SAXWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding)), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(OutputStream outputStream, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBModelWriter(new SAXWriter(outputStream), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(OutputStream outputStream, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBModelWriter(new SAXWriter(outputStream, encoding), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(StreamResult streamResult, String encoding, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBModelWriter(new SAXWriter(streamResult, encoding), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(Writer writer, ModuleContext moduleContext) throws CityGMLWriteException {
        try {
            return new JAXBModelWriter(new SAXWriter(writer), this, moduleContext);
        }
        catch (IOException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public CityModelWriter createCityModelWriter(File file, String encoding) throws CityGMLWriteException {
        return this.createCityModelWriter(file, encoding, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(File file) throws CityGMLWriteException {
        return this.createCityModelWriter(file, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(OutputStream outputStream, String encoding) throws CityGMLWriteException {
        return this.createCityModelWriter(outputStream, encoding, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(OutputStream outputStream) throws CityGMLWriteException {
        return this.createCityModelWriter(outputStream, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(StreamResult streamResult, String encoding) throws CityGMLWriteException {
        return this.createCityModelWriter(streamResult, encoding, this.moduleContext);
    }

    @Override
    public CityModelWriter createCityModelWriter(Writer writer) throws CityGMLWriteException {
        return this.createCityModelWriter(writer, this.moduleContext);
    }

    @Override
    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    @Override
    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    @Override
    public void setSchemaHandler(SchemaHandler schemaHandler) {
        if (schemaHandler == null) {
            throw new IllegalArgumentException("schema handler may not be null.");
        }
        this.schemaHandler = schemaHandler;
    }

    @Override
    public void setModuleContext(ModuleContext moduleContext) {
        if (moduleContext == null) {
            throw new IllegalArgumentException("module context may not be null.");
        }
        this.moduleContext = moduleContext;
    }

    @Override
    public void setCityGMLVersion(CityGMLVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("CityGML version may not be null.");
        }
        this.moduleContext = new ModuleContext(version);
    }

    @Override
    public GMLIdManager getGMLIdManager() {
        return this.gmlIdManager;
    }

    @Override
    public void setGMLIdManager(GMLIdManager gmlIdManager) {
        if (gmlIdManager == null) {
            throw new IllegalArgumentException("gml:id manager may not be null.");
        }
        this.gmlIdManager = gmlIdManager;
    }

    @Override
    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    @Override
    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        if (validationEventHandler == null) {
            throw new IllegalArgumentException("validation event handler may not be null.");
        }
        this.validationEventHandler = validationEventHandler;
    }

    @Override
    public void setTransformationTemplates(Templates ... transformationTemplates) throws CityGMLWriteException {
        if (transformationTemplates == null) {
            throw new IllegalArgumentException("transformation templates may not be null.");
        }
        try {
            if (this.transformerChainFactory == null) {
                this.transformerChainFactory = new TransformerChainFactory(transformationTemplates);
            } else {
                this.transformerChainFactory.updateTemplates(transformationTemplates);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public Templates[] getTransformationTemplates() {
        return this.transformerChainFactory == null ? null : this.transformerChainFactory.getTemplates();
    }

    public TransformerChainFactory getTransformerChainFactory() {
        return this.transformerChainFactory;
    }

    @Override
    public Object getProperty(String name) {
        Objects.requireNonNull(name, "property name may not be null.");
        if (name.equals("org.citygml4j.featureWriteMode")) {
            return this.featureWriteMode;
        }
        if (name.equals("org.citygml4j.keepInlineAppearance")) {
            return this.keepInlineAppearance;
        }
        if (name.equals("org.citygml4j.splitCopy")) {
            return this.splitCopy;
        }
        if (name.equals("org.citygml4j.useValidation")) {
            return this.useValidation;
        }
        if (name.equals("org.citygml4j.excludeFromSplitting")) {
            return this.excludes;
        }
        throw new IllegalArgumentException("the property '" + name + "' is not supported.");
    }

    @Override
    public void setProperty(String name, Object value) {
        Objects.requireNonNull(name, "property name may not be null.");
        if (name.equals("org.citygml4j.featureWriteMode")) {
            FeatureWriteMode mode = FeatureWriteMode.fromValue(value.toString());
            if (mode != null) {
                this.featureWriteMode = mode;
            }
            return;
        }
        if (name.equals("org.citygml4j.keepInlineAppearance")) {
            if (value instanceof Boolean) {
                this.keepInlineAppearance = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.splitCopy")) {
            if (value instanceof Boolean) {
                this.splitCopy = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.useValidation")) {
            if (value instanceof Boolean) {
                this.useValidation = (Boolean)value;
            }
            return;
        }
        if (name.equals("org.citygml4j.excludeFromSplitting")) {
            if (value instanceof Class) {
                if (!this.isSubclassOfCityGML((Class)value)) {
                    throw new IllegalArgumentException("exclude must be of type Class<? extends CityGML>.");
                }
                this.excludes.add((Class)value);
                return;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (this.isSubclassOfCityGML((Class)o)) {
                        this.excludes.add((Class)o);
                        continue;
                    }
                    throw new IllegalArgumentException("exclude must be of type Class<? extends CityGML>.");
                }
                return;
            }
            if (value instanceof Class[]) {
                for (Class o : (Class[])value) {
                    if (!this.isSubclassOfCityGML(o)) {
                        throw new IllegalArgumentException("exclude must be of type Class<? extends CityGML>.");
                    }
                    this.excludes.add(o);
                }
                return;
            }
        }
        throw new IllegalArgumentException("the key-value pair '" + name + " - " + value.getClass().getName() + "' is not supported.");
    }

    private boolean isSubclassOfCityGML(Class<?> a) {
        if (a == null) {
            return false;
        }
        if (a == CityGML.class) {
            return true;
        }
        for (Class<?> tmp : a.getInterfaces()) {
            if (!this.isSubclassOfCityGML(tmp)) continue;
            return true;
        }
        return a.getSuperclass() != Object.class && this.isSubclassOfCityGML(a.getSuperclass());
    }

    private void createParentDirectories(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

