/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.writer;

import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.builder.jaxb.xml.io.writer.AbstractJAXBWriter;
import org.citygml4j.builder.jaxb.xml.io.writer.JAXBOutputFactory;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.citygml.core.CityObjectMember;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureMember;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.util.internal.xml.TransformerChain;
import org.citygml4j.util.xml.SAXWriter;
import org.citygml4j.xml.io.writer.CityGMLWriteException;
import org.citygml4j.xml.io.writer.CityGMLWriter;
import org.citygml4j.xml.io.writer.CityModelInfo;
import org.citygml4j.xml.io.writer.FeatureWriteMode;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JAXBSimpleWriter
extends AbstractJAXBWriter
implements CityGMLWriter {
    public JAXBSimpleWriter(SAXWriter writer, JAXBOutputFactory factory, ModuleContext moduleContext) throws CityGMLWriteException {
        super(writer, factory, moduleContext);
    }

    @Override
    public void write(AbstractFeature abstractFeature) throws CityGMLWriteException {
        if (this.featureWriteMode == FeatureWriteMode.SPLIT_PER_COLLECTION_MEMBER && this.featureSplitter != null) {
            abstractFeature = this.split(abstractFeature);
        }
        try {
            JAXBElement<?> jaxbElement = this.jaxbMarshaller.marshalJAXBElement(abstractFeature);
            if (jaxbElement != null) {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                if (this.useValidation) {
                    marshaller.setSchema(this.validationSchemaHandler.getSchema());
                    if (this.validationEventHandler != null) {
                        marshaller.setEventHandler(this.validationEventHandler);
                    }
                }
                if (this.transformerChainFactory == null) {
                    marshaller.marshal(jaxbElement, (ContentHandler)this.writer);
                } else {
                    TransformerChain chain = this.transformerChainFactory.buildChain();
                    chain.tail().setResult(new SAXResult(this.writer));
                    marshaller.marshal(jaxbElement, (ContentHandler)chain.head());
                }
                this.writer.flush();
            }
        }
        catch (JAXBException | TransformerConfigurationException | SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    private AbstractFeature split(AbstractFeature input) {
        List<CityGML> results = this.featureSplitter.split(input);
        CityModel cityModel = null;
        CityModel origModel = null;
        HashSet<String> gmlIds = null;
        if (input instanceof CityModel) {
            cityModel = new CityModelInfo((CityModel)input).toCityModel();
            origModel = (CityModel)results.get(0);
            gmlIds = new HashSet<String>();
        } else {
            cityModel = new CityModel();
        }
        for (CityGML cityGML : results) {
            FeatureProperty member;
            if (cityGML instanceof AbstractFeature) {
                if (cityGML == origModel) continue;
                AbstractFeature feature = (AbstractFeature)((Object)cityGML);
                if (gmlIds != null && feature.isSetId()) {
                    gmlIds.add('#' + feature.getId());
                }
                if (feature instanceof AbstractCityObject) {
                    member = new CityObjectMember();
                    ((CityObjectMember)member).setCityObject((AbstractCityObject)feature);
                    cityModel.addCityObjectMember((CityObjectMember)member);
                    continue;
                }
                if (feature instanceof Appearance) {
                    member = new AppearanceMember();
                    ((AppearanceProperty)member).setAppearance((Appearance)feature);
                    cityModel.addAppearanceMember((AppearanceMember)member);
                    continue;
                }
                member = new FeatureMember();
                member.setFeature(feature);
                cityModel.addFeatureMember((FeatureMember)member);
                continue;
            }
            if (!(cityGML instanceof ADEGenericElement)) continue;
            ADEGenericElement ade = (ADEGenericElement)cityGML;
            if (gmlIds != null) {
                String gmlId = ade.getContent().getAttribute("id");
                if (gmlId.length() == 0) {
                    gmlId = ade.getContent().getAttributeNS(GMLCoreModule.v3_1_1.getNamespaceURI(), "id");
                }
                gmlIds.add('#' + gmlId);
            }
            if (this.isCityObject(ade)) {
                member = new CityObjectMember();
                member.setGenericADEElement(ade);
                cityModel.addCityObjectMember((CityObjectMember)member);
                continue;
            }
            member = new FeatureMember();
            member.setGenericADEElement(ade);
            cityModel.addFeatureMember((FeatureMember)member);
        }
        if (origModel != null) {
            if (origModel.isSetCityObjectMember()) {
                for (CityObjectMember cityObjectMember : origModel.getCityObjectMember()) {
                    if (!cityObjectMember.isSetHref() || !gmlIds.contains(cityObjectMember.getHref())) {
                        cityModel.addCityObjectMember(cityObjectMember);
                        continue;
                    }
                    gmlIds.remove(cityObjectMember.getHref());
                }
            }
            if (origModel.isSetAppearanceMember()) {
                for (AppearanceMember appearanceMember : origModel.getAppearanceMember()) {
                    if (!appearanceMember.isSetHref() || !gmlIds.contains(appearanceMember.getHref())) {
                        cityModel.addAppearanceMember(appearanceMember);
                        continue;
                    }
                    gmlIds.remove(appearanceMember.getHref());
                }
            }
            if (origModel.isSetFeatureMember()) {
                for (FeatureMember featureMember : origModel.getFeatureMember()) {
                    if (!featureMember.isSetHref() || !gmlIds.contains(featureMember.getHref())) {
                        cityModel.addFeatureMember(featureMember);
                        continue;
                    }
                    gmlIds.remove(featureMember.getHref());
                }
            }
        }
        return cityModel;
    }
}

