/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.validation;

import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.citygml4j.xml.schema.SchemaHandler;
import org.xml.sax.SAXException;

public class ValidationSchemaHandler {
    private final SchemaFactory schemaFactory;
    private final AtomicInteger size = new AtomicInteger(-1);
    private SchemaHandler schemaHandler;
    private Schema schema;

    public ValidationSchemaHandler(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public Schema getSchema() throws SAXException {
        int currentSize = this.size.get();
        if (currentSize != this.schemaHandler.size() && this.size.compareAndSet(currentSize, this.schemaHandler.size())) {
            this.schema = this.schemaFactory.newSchema(this.schemaHandler.getSchemaSources());
        }
        return this.schema;
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public void setSchemaHandler(SchemaHandler schemaHandler) {
        if (schemaHandler == null) {
            throw new IllegalArgumentException("schema handler may not be null.");
        }
        this.schemaHandler = schemaHandler;
        this.size.set(-1);
    }
}

