/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.geometry;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.Geometry;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.geometry.Point;

public class BoundingBox
implements Geometry {
    private Point lowerCorner;
    private Point upperCorner;

    public BoundingBox() {
        this.lowerCorner = new Point(Double.MAX_VALUE);
        this.upperCorner = new Point(-1.7976931348623157E308);
    }

    public BoundingBox(Point lowerCorner, Point upperCorner) {
        this.lowerCorner = new Point(lowerCorner);
        this.upperCorner = new Point(upperCorner);
    }

    public BoundingBox(BoundingBox boundingBox) {
        this.lowerCorner = new Point(boundingBox.getLowerCorner());
        this.upperCorner = new Point(boundingBox.getUpperCorner());
    }

    public boolean isNull() {
        return this.lowerCorner.isEqual(Double.MAX_VALUE) && this.upperCorner.isEqual(-1.7976931348623157E308);
    }

    public Point getLowerCorner() {
        return this.lowerCorner;
    }

    public void setLowerCorner(Point lowerCorner) {
        this.lowerCorner = lowerCorner;
    }

    public void setLowerCorner(double x, double y, double z) {
        this.lowerCorner.setX(x);
        this.lowerCorner.setY(y);
        this.lowerCorner.setZ(z);
    }

    public Point getUpperCorner() {
        return this.upperCorner;
    }

    public void setUpperCorner(Point upperCorner) {
        this.upperCorner = upperCorner;
    }

    public void setUpperCorner(double x, double y, double z) {
        this.upperCorner.setX(x);
        this.upperCorner.setY(y);
        this.upperCorner.setZ(z);
    }

    public void updateLowerCorner(double x, double y, double z) {
        if (x < this.lowerCorner.getX()) {
            this.lowerCorner.setX(x);
        }
        if (y < this.lowerCorner.getY()) {
            this.lowerCorner.setY(y);
        }
        if (z < this.lowerCorner.getZ()) {
            this.lowerCorner.setZ(z);
        }
    }

    public void updateLowerCorner(Point lowerCorner) {
        this.updateLowerCorner(lowerCorner.getX(), lowerCorner.getY(), lowerCorner.getZ());
    }

    public void updateUpperCorner(double x, double y, double z) {
        if (x > this.upperCorner.getX()) {
            this.upperCorner.setX(x);
        }
        if (y > this.upperCorner.getY()) {
            this.upperCorner.setY(y);
        }
        if (z > this.upperCorner.getZ()) {
            this.upperCorner.setZ(z);
        }
    }

    public void updateUpperCorner(Point upperCorner) {
        this.updateUpperCorner(upperCorner.getX(), upperCorner.getY(), upperCorner.getZ());
    }

    public void update(double x, double y, double z) {
        this.updateLowerCorner(x, y, z);
        this.updateUpperCorner(x, y, z);
    }

    public void update(Point point) {
        this.update(point.getX(), point.getY(), point.getZ());
    }

    public void update(BoundingBox boundingBox) {
        if (boundingBox != null) {
            this.updateLowerCorner(boundingBox.getLowerCorner());
            this.updateUpperCorner(boundingBox.getUpperCorner());
        }
    }

    public void transform3d(Matrix m) {
        if (!this.lowerCorner.isEqual(Double.MAX_VALUE)) {
            this.lowerCorner.transform3D(m);
        }
        if (!this.upperCorner.isEqual(-1.7976931348623157E308)) {
            this.upperCorner.transform3D(m);
        }
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new BoundingBox(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        BoundingBox copy = target == null ? new BoundingBox() : (BoundingBox)target;
        copy.setLowerCorner((Point)copyBuilder.copy(this.lowerCorner));
        copy.setUpperCorner((Point)copyBuilder.copy(this.upperCorner));
        return copy;
    }

    public List<Double> toList() {
        ArrayList<Double> values = new ArrayList<Double>();
        values.addAll(this.lowerCorner.toList());
        values.addAll(this.upperCorner.toList());
        return values;
    }
}

