/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.ade.binding;

import java.util.Arrays;
import java.util.Collection;
import org.citygml4j.model.citygml.ade.binding.ADEGenericApplicationProperty;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.gml.base.ArrayAssociation;
import org.citygml4j.model.gml.base.AssociationByRep;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class ADEBoundingBoxHelper {
    public static BoundingShape calcBoundedBy(ADEModelObject ade, BoundingBoxOptions options) {
        BoundingShape boundedBy = new BoundingShape();
        ADEBoundingBoxHelper.updateEnvelope(ade, boundedBy, options);
        return boundedBy;
    }

    private static void updateEnvelope(Object object, BoundingShape boundedBy, BoundingBoxOptions options) {
        if (object instanceof AbstractGeometry) {
            boundedBy.updateEnvelope(((AbstractGeometry)object).calcBoundingBox());
        } else if (object instanceof AbstractFeature) {
            boundedBy.updateEnvelope(((AbstractFeature)object).calcBoundedBy(options).getEnvelope());
        } else if (object instanceof ADEGenericApplicationProperty) {
            ADEBoundingBoxHelper.updateEnvelope(((ADEGenericApplicationProperty)object).getValue(), boundedBy, options);
        } else if (object instanceof ArrayAssociation) {
            ((ArrayAssociation)object).getObject().forEach(v -> ADEBoundingBoxHelper.updateEnvelope(v, boundedBy, options));
        } else if (object instanceof AssociationByRep) {
            ADEBoundingBoxHelper.updateEnvelope(((AssociationByRep)object).getObject(), boundedBy, options);
        } else if (object instanceof Collection) {
            ((Collection)object).forEach(v -> ADEBoundingBoxHelper.updateEnvelope(v, boundedBy, options));
        } else if (object instanceof Object[]) {
            Arrays.stream((Object[])object).forEach(v -> ADEBoundingBoxHelper.updateEnvelope(v, boundedBy, options));
        }
    }
}

