/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.building;

import java.time.LocalDate;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.building.AbstractBoundarySurface;
import org.citygml4j.model.citygml.building.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.building.BuildingInstallation;
import org.citygml4j.model.citygml.building.BuildingInstallationProperty;
import org.citygml4j.model.citygml.building.BuildingModuleComponent;
import org.citygml4j.model.citygml.building.BuildingPart;
import org.citygml4j.model.citygml.building.BuildingPartProperty;
import org.citygml4j.model.citygml.building.IntBuildingInstallationProperty;
import org.citygml4j.model.citygml.building.InteriorRoomProperty;
import org.citygml4j.model.citygml.core.AbstractSite;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.basicTypes.MeasureOrNullList;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurveProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.gml.measures.Length;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractBuilding
extends AbstractSite
implements BuildingModuleComponent,
StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private LocalDate yearOfConstruction;
    private LocalDate yearOfDemolition;
    private Code roofType;
    private Length measuredHeight;
    private Integer storeysAboveGround;
    private Integer storeysBelowGround;
    private MeasureOrNullList storeyHeightsAboveGround;
    private MeasureOrNullList storeyHeightsBelowGround;
    private SolidProperty lod1Solid;
    private SolidProperty lod2Solid;
    private SolidProperty lod3Solid;
    private SolidProperty lod4Solid;
    private MultiCurveProperty lod1TerrainIntersection;
    private MultiCurveProperty lod2TerrainIntersection;
    private MultiCurveProperty lod3TerrainIntersection;
    private MultiCurveProperty lod4TerrainIntersection;
    private MultiCurveProperty lod2MultiCurve;
    private MultiCurveProperty lod3MultiCurve;
    private MultiCurveProperty lod4MultiCurve;
    private MultiSurfaceProperty lod0FootPrint;
    private MultiSurfaceProperty lod0RoofEdge;
    private MultiSurfaceProperty lod1MultiSurface;
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private List<BuildingInstallationProperty> outerBuildingInstallation;
    private List<IntBuildingInstallationProperty> interiorBuildingInstallation;
    private List<BoundarySurfaceProperty> boundedBySurface;
    private List<BuildingPartProperty> buildingPart;
    private List<InteriorRoomProperty> interiorRoom;
    private List<AddressProperty> address;
    private List<ADEComponent> ade;

    public AbstractBuilding() {
    }

    public AbstractBuilding(Module module) {
        super(module);
    }

    public void addAddress(AddressProperty address) {
        this.getAddress().add(address);
    }

    public void addBoundedBySurface(BoundarySurfaceProperty boundedBySurface) {
        this.getBoundedBySurface().add(boundedBySurface);
    }

    public void addConsistsOfBuildingPart(BuildingPartProperty buildingPart) {
        this.getConsistsOfBuildingPart().add(buildingPart);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfAbstractBuilding(ADEComponent ade) {
        this.getGenericApplicationPropertyOfAbstractBuilding().add(ade);
    }

    public void addInteriorBuildingInstallation(IntBuildingInstallationProperty interiorBuildingInstallation) {
        this.getInteriorBuildingInstallation().add(interiorBuildingInstallation);
    }

    public void addInteriorRoom(InteriorRoomProperty interiorRoom) {
        this.getInteriorRoom().add(interiorRoom);
    }

    public void addOuterBuildingInstallation(BuildingInstallationProperty outerBuildingInstallation) {
        this.getOuterBuildingInstallation().add(outerBuildingInstallation);
    }

    public List<AddressProperty> getAddress() {
        if (this.address == null) {
            this.address = new ChildList<AddressProperty>(this);
        }
        return this.address;
    }

    public List<BoundarySurfaceProperty> getBoundedBySurface() {
        if (this.boundedBySurface == null) {
            this.boundedBySurface = new ChildList<BoundarySurfaceProperty>(this);
        }
        return this.boundedBySurface;
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<BuildingPartProperty> getConsistsOfBuildingPart() {
        if (this.buildingPart == null) {
            this.buildingPart = new ChildList<BuildingPartProperty>(this);
        }
        return this.buildingPart;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfAbstractBuilding() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public List<IntBuildingInstallationProperty> getInteriorBuildingInstallation() {
        if (this.interiorBuildingInstallation == null) {
            this.interiorBuildingInstallation = new ChildList<IntBuildingInstallationProperty>(this);
        }
        return this.interiorBuildingInstallation;
    }

    public List<InteriorRoomProperty> getInteriorRoom() {
        if (this.interiorRoom == null) {
            this.interiorRoom = new ChildList<InteriorRoomProperty>(this);
        }
        return this.interiorRoom;
    }

    public MultiSurfaceProperty getLod1MultiSurface() {
        return this.lod1MultiSurface;
    }

    public SolidProperty getLod1Solid() {
        return this.lod1Solid;
    }

    public MultiCurveProperty getLod1TerrainIntersection() {
        return this.lod1TerrainIntersection;
    }

    public MultiCurveProperty getLod2MultiCurve() {
        return this.lod2MultiCurve;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public SolidProperty getLod2Solid() {
        return this.lod2Solid;
    }

    public MultiCurveProperty getLod2TerrainIntersection() {
        return this.lod2TerrainIntersection;
    }

    public MultiCurveProperty getLod3MultiCurve() {
        return this.lod3MultiCurve;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public SolidProperty getLod3Solid() {
        return this.lod3Solid;
    }

    public MultiCurveProperty getLod3TerrainIntersection() {
        return this.lod3TerrainIntersection;
    }

    public MultiCurveProperty getLod4MultiCurve() {
        return this.lod4MultiCurve;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public SolidProperty getLod4Solid() {
        return this.lod4Solid;
    }

    public MultiCurveProperty getLod4TerrainIntersection() {
        return this.lod4TerrainIntersection;
    }

    public Length getMeasuredHeight() {
        return this.measuredHeight;
    }

    public List<BuildingInstallationProperty> getOuterBuildingInstallation() {
        if (this.outerBuildingInstallation == null) {
            this.outerBuildingInstallation = new ChildList<BuildingInstallationProperty>(this);
        }
        return this.outerBuildingInstallation;
    }

    public Code getRoofType() {
        return this.roofType;
    }

    public MeasureOrNullList getStoreyHeightsAboveGround() {
        return this.storeyHeightsAboveGround;
    }

    public MeasureOrNullList getStoreyHeightsBelowGround() {
        return this.storeyHeightsBelowGround;
    }

    public Integer getStoreysAboveGround() {
        return this.storeysAboveGround;
    }

    public Integer getStoreysBelowGround() {
        return this.storeysBelowGround;
    }

    public LocalDate getYearOfConstruction() {
        return this.yearOfConstruction;
    }

    public LocalDate getYearOfDemolition() {
        return this.yearOfDemolition;
    }

    public boolean isSetAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public boolean isSetBoundedBySurface() {
        return this.boundedBySurface != null && !this.boundedBySurface.isEmpty();
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    public boolean isSetConsistsOfBuildingPart() {
        return this.buildingPart != null && !this.buildingPart.isEmpty();
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfAbstractBuilding() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetInteriorBuildingInstallation() {
        return this.interiorBuildingInstallation != null && !this.interiorBuildingInstallation.isEmpty();
    }

    public boolean isSetInteriorRoom() {
        return this.interiorRoom != null && !this.interiorRoom.isEmpty();
    }

    public boolean isSetLod1MultiSurface() {
        return this.lod1MultiSurface != null;
    }

    public boolean isSetLod1Solid() {
        return this.lod1Solid != null;
    }

    public boolean isSetLod1TerrainIntersection() {
        return this.lod1TerrainIntersection != null;
    }

    public boolean isSetLod2MultiCurve() {
        return this.lod2MultiCurve != null;
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod2Solid() {
        return this.lod2Solid != null;
    }

    public boolean isSetLod2TerrainIntersection() {
        return this.lod2TerrainIntersection != null;
    }

    public boolean isSetLod3MultiCurve() {
        return this.lod3MultiCurve != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod3Solid() {
        return this.lod3Solid != null;
    }

    public boolean isSetLod3TerrainIntersection() {
        return this.lod3TerrainIntersection != null;
    }

    public boolean isSetLod4MultiCurve() {
        return this.lod4MultiCurve != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetLod4Solid() {
        return this.lod4Solid != null;
    }

    public boolean isSetLod4TerrainIntersection() {
        return this.lod4TerrainIntersection != null;
    }

    public boolean isSetMeasuredHeight() {
        return this.measuredHeight != null;
    }

    public boolean isSetOuterBuildingInstallation() {
        return this.outerBuildingInstallation != null && !this.outerBuildingInstallation.isEmpty();
    }

    public boolean isSetRoofType() {
        return this.roofType != null;
    }

    public boolean isSetStoreyHeightsAboveGround() {
        return this.storeyHeightsAboveGround != null;
    }

    public boolean isSetStoreyHeightsBelowGround() {
        return this.storeyHeightsBelowGround != null;
    }

    public boolean isSetStoreysAboveGround() {
        return this.storeysAboveGround != null;
    }

    public boolean isSetStoreysBelowGround() {
        return this.storeysBelowGround != null;
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetYearOfConstruction() {
        return this.yearOfConstruction != null;
    }

    public boolean isSetYearOfDemolition() {
        return this.yearOfDemolition != null;
    }

    public void setAddress(List<AddressProperty> address) {
        this.address = new ChildList<AddressProperty>((ModelObject)this, address);
    }

    public void setBoundedBySurface(List<BoundarySurfaceProperty> boundedBySurface) {
        this.boundedBySurface = new ChildList<BoundarySurfaceProperty>((ModelObject)this, boundedBySurface);
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setConsistsOfBuildingPart(List<BuildingPartProperty> buildingPart) {
        this.buildingPart = new ChildList<BuildingPartProperty>((ModelObject)this, buildingPart);
    }

    public void setGenericApplicationPropertyOfAbstractBuilding(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setInteriorBuildingInstallation(List<IntBuildingInstallationProperty> interiorBuildingInstallation) {
        this.interiorBuildingInstallation = new ChildList<IntBuildingInstallationProperty>((ModelObject)this, interiorBuildingInstallation);
    }

    public void setInteriorRoom(List<InteriorRoomProperty> interiorRoom) {
        this.interiorRoom = new ChildList<InteriorRoomProperty>((ModelObject)this, interiorRoom);
    }

    public void setLod1MultiSurface(MultiSurfaceProperty lod1MultiSurface) {
        this.lod1MultiSurface = ModelObjects.setParent(lod1MultiSurface, (ModelObject)this);
    }

    public void setLod1Solid(SolidProperty lod1Solid) {
        this.lod1Solid = ModelObjects.setParent(lod1Solid, (ModelObject)this);
    }

    public void setLod1TerrainIntersection(MultiCurveProperty lod1TerrainIntersection) {
        this.lod1TerrainIntersection = ModelObjects.setParent(lod1TerrainIntersection, (ModelObject)this);
    }

    public void setLod2MultiCurve(MultiCurveProperty lod2MultiCurve) {
        this.lod2MultiCurve = ModelObjects.setParent(lod2MultiCurve, (ModelObject)this);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod2Solid(SolidProperty lod2Solid) {
        this.lod2Solid = ModelObjects.setParent(lod2Solid, (ModelObject)this);
    }

    public void setLod2TerrainIntersection(MultiCurveProperty lod2TerrainIntersection) {
        this.lod2TerrainIntersection = ModelObjects.setParent(lod2TerrainIntersection, (ModelObject)this);
    }

    public void setLod3MultiCurve(MultiCurveProperty lod3MultiCurve) {
        this.lod3MultiCurve = ModelObjects.setParent(lod3MultiCurve, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod3Solid(SolidProperty lod3Solid) {
        this.lod3Solid = ModelObjects.setParent(lod3Solid, (ModelObject)this);
    }

    public void setLod3TerrainIntersection(MultiCurveProperty lod3TerrainIntersection) {
        this.lod3TerrainIntersection = ModelObjects.setParent(lod3TerrainIntersection, (ModelObject)this);
    }

    public void setLod4MultiCurve(MultiCurveProperty lod4MultiCurve) {
        this.lod4MultiCurve = ModelObjects.setParent(lod4MultiCurve, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setLod4Solid(SolidProperty lod4Solid) {
        this.lod4Solid = ModelObjects.setParent(lod4Solid, (ModelObject)this);
    }

    public void setLod4TerrainIntersection(MultiCurveProperty lod4TerrainIntersection) {
        this.lod4TerrainIntersection = ModelObjects.setParent(lod4TerrainIntersection, (ModelObject)this);
    }

    public void setMeasuredHeight(Length measuredHeight) {
        this.measuredHeight = ModelObjects.setParent(measuredHeight, (ModelObject)this);
    }

    public void setOuterBuildingInstallation(List<BuildingInstallationProperty> outerBuildingInstallation) {
        this.outerBuildingInstallation = new ChildList<BuildingInstallationProperty>((ModelObject)this, outerBuildingInstallation);
    }

    public void setRoofType(Code roofType) {
        this.roofType = ModelObjects.setParent(roofType, (ModelObject)this);
    }

    public void setStoreyHeightsAboveGround(MeasureOrNullList storeyHeightsAboveGround) {
        this.storeyHeightsAboveGround = ModelObjects.setParent(storeyHeightsAboveGround, (ModelObject)this);
    }

    public void setStoreyHeightsBelowGround(MeasureOrNullList storeyHeightsBelowGround) {
        this.storeyHeightsBelowGround = ModelObjects.setParent(storeyHeightsBelowGround, (ModelObject)this);
    }

    public void setStoreysAboveGround(Integer storeysAboveGround) {
        if (storeysAboveGround >= 0) {
            this.storeysAboveGround = storeysAboveGround;
        }
    }

    public void setStoreysBelowGround(Integer storeysBelowGround) {
        if (storeysBelowGround >= 0) {
            this.storeysBelowGround = storeysBelowGround;
        }
    }

    public void setYearOfConstruction(LocalDate yearOfConstruction) {
        this.yearOfConstruction = yearOfConstruction;
    }

    public void setYearOfConstruction(int yearOfConstruction) {
        this.yearOfConstruction = LocalDate.of(yearOfConstruction, 1, 1);
    }

    public void setYearOfDemolition(LocalDate yearOfDemolition) {
        this.yearOfDemolition = yearOfDemolition;
    }

    public void setYearOfDemolition(int yearOfDemolition) {
        this.yearOfDemolition = LocalDate.of(yearOfDemolition, 1, 1);
    }

    public void unsetAddress() {
        this.address = ModelObjects.setNull(this.address);
    }

    public boolean unsetAddress(AddressProperty address) {
        return this.isSetAddress() && this.address.remove(address);
    }

    public void unsetBoundedBySurface() {
        this.boundedBySurface = ModelObjects.setNull(this.boundedBySurface);
    }

    public boolean unsetBoundedBySurface(BoundarySurfaceProperty boundedBySurface) {
        return this.isSetBoundedBySurface() && this.boundedBySurface.remove(boundedBySurface);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    public void unsetConsistsOfBuildingPart() {
        this.buildingPart = ModelObjects.setNull(this.buildingPart);
    }

    public boolean unsetConsistsOfBuildingPart(BuildingPartProperty buildingPart) {
        return this.isSetConsistsOfBuildingPart() && this.buildingPart.remove(buildingPart);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfAbstractBuilding() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfAbstractBuilding(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfAbstractBuilding() && this.ade.remove(ade);
    }

    public void unsetInteriorBuildingInstallation() {
        this.interiorBuildingInstallation = ModelObjects.setNull(this.interiorBuildingInstallation);
    }

    public boolean unsetInteriorBuildingInstallation(IntBuildingInstallationProperty interiorBuildingInstallation) {
        return this.isSetInteriorBuildingInstallation() && this.interiorBuildingInstallation.remove(interiorBuildingInstallation);
    }

    public void unsetInteriorRoom() {
        this.interiorRoom = ModelObjects.setNull(this.interiorRoom);
    }

    public boolean unsetInteriorRoom(InteriorRoomProperty interiorRoom) {
        return this.isSetInteriorRoom() && this.interiorRoom.remove(interiorRoom);
    }

    public void unsetLod1MultiSurface() {
        this.lod1MultiSurface = ModelObjects.setNull(this.lod1MultiSurface);
    }

    public void unsetLod1Solid() {
        this.lod1Solid = ModelObjects.setNull(this.lod1Solid);
    }

    public void unsetLod1TerrainIntersection() {
        this.lod1TerrainIntersection = ModelObjects.setNull(this.lod1TerrainIntersection);
    }

    public void unsetLod2MultiCurve() {
        this.lod2MultiCurve = ModelObjects.setNull(this.lod2MultiCurve);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod2Solid() {
        this.lod2Solid = ModelObjects.setNull(this.lod2Solid);
    }

    public void unsetLod2TerrainIntersection() {
        this.lod2TerrainIntersection = ModelObjects.setNull(this.lod2TerrainIntersection);
    }

    public void unsetLod3MultiCurve() {
        this.lod3MultiCurve = ModelObjects.setNull(this.lod3MultiCurve);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod3Solid() {
        this.lod3Solid = ModelObjects.setNull(this.lod3Solid);
    }

    public void unsetLod3TerrainIntersection() {
        this.lod3TerrainIntersection = ModelObjects.setNull(this.lod3TerrainIntersection);
    }

    public void unsetLod4MultiCurve() {
        this.lod4MultiCurve = ModelObjects.setNull(this.lod4MultiCurve);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetLod4Solid() {
        this.lod4Solid = ModelObjects.setNull(this.lod4Solid);
    }

    public void unsetLod4TerrainIntersection() {
        this.lod4TerrainIntersection = ModelObjects.setNull(this.lod4TerrainIntersection);
    }

    public void unsetMeasuredHeight() {
        this.measuredHeight = ModelObjects.setNull(this.measuredHeight);
    }

    public void unsetOuterBuildingInstallation() {
        this.outerBuildingInstallation = ModelObjects.setNull(this.outerBuildingInstallation);
    }

    public boolean unsetOuterBuildingInstallation(BuildingInstallationProperty outerBuildingInstallation) {
        return this.isSetOuterBuildingInstallation() && this.outerBuildingInstallation.remove(outerBuildingInstallation);
    }

    public void unsetRoofType() {
        this.roofType = ModelObjects.setNull(this.roofType);
    }

    public void unsetStoreyHeightsAboveGround() {
        this.storeyHeightsAboveGround = ModelObjects.setNull(this.storeyHeightsAboveGround);
    }

    public void unsetStoreyHeightsBelowGround() {
        this.storeyHeightsBelowGround = ModelObjects.setNull(this.storeyHeightsBelowGround);
    }

    public void unsetStoreysAboveGround() {
        this.storeysAboveGround = null;
    }

    public void unsetStoreysBelowGround() {
        this.storeysBelowGround = null;
    }

    public void unsetYearOfConstruction() {
        this.yearOfConstruction = null;
    }

    public void unsetYearOfDemolition() {
        this.yearOfDemolition = null;
    }

    public MultiSurfaceProperty getLod0FootPrint() {
        return this.lod0FootPrint;
    }

    public MultiSurfaceProperty getLod0RoofEdge() {
        return this.lod0RoofEdge;
    }

    public boolean isSetLod0FootPrint() {
        return this.lod0FootPrint != null;
    }

    public boolean isSetLod0RoofEdge() {
        return this.lod0RoofEdge != null;
    }

    public void setLod0FootPrint(MultiSurfaceProperty lod0FootPrint) {
        this.lod0FootPrint = ModelObjects.setParent(lod0FootPrint, (ModelObject)this);
    }

    public void setLod0RoofEdge(MultiSurfaceProperty lod0RoofEgde) {
        this.lod0RoofEdge = ModelObjects.setParent(lod0RoofEgde, (ModelObject)this);
    }

    public void unsetLod0FootPrint() {
        this.lod0FootPrint = ModelObjects.setNull(this.lod0FootPrint);
    }

    public void unsetLod0RoofEdge() {
        this.lod0RoofEdge = ModelObjects.setNull(this.lod0RoofEdge);
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.lod0FootPrint != null && this.lod0FootPrint.isSetMultiSurface()) {
            boundedBy.updateEnvelope(this.lod0FootPrint.getMultiSurface().calcBoundingBox());
        }
        if (this.lod0RoofEdge != null && this.lod0RoofEdge.isSetMultiSurface()) {
            boundedBy.updateEnvelope(this.lod0RoofEdge.getMultiSurface().calcBoundingBox());
        }
        SolidProperty solidProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    solidProperty = this.lod1Solid;
                    break;
                }
                case 2: {
                    solidProperty = this.lod2Solid;
                    break;
                }
                case 3: {
                    solidProperty = this.lod3Solid;
                    break;
                }
                case 4: {
                    solidProperty = this.lod4Solid;
                }
            }
            if (solidProperty == null || !solidProperty.isSetSolid()) continue;
            boundedBy.updateEnvelope(solidProperty.getSolid().calcBoundingBox());
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    multiSurfaceProperty = this.lod1MultiSurface;
                    break;
                }
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        MultiCurveProperty multiCurveProperty = null;
        for (int lod = 2; lod < 5; ++lod) {
            switch (lod) {
                case 2: {
                    multiCurveProperty = this.lod2MultiCurve;
                    break;
                }
                case 3: {
                    multiCurveProperty = this.lod3MultiCurve;
                    break;
                }
                case 4: {
                    multiCurveProperty = this.lod4MultiCurve;
                }
            }
            if (multiCurveProperty == null || !multiCurveProperty.isSetMultiCurve()) continue;
            boundedBy.updateEnvelope(multiCurveProperty.getMultiCurve().calcBoundingBox());
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : this.getBoundedBySurface()) {
                if (!boundarySurfaceProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((AbstractBoundarySurface)boundarySurfaceProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetOuterBuildingInstallation()) {
            for (BuildingInstallationProperty buildingInstallationProperty : this.getOuterBuildingInstallation()) {
                if (!buildingInstallationProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((BuildingInstallation)buildingInstallationProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetConsistsOfBuildingPart()) {
            for (BuildingPartProperty buildingPartProperty : this.getConsistsOfBuildingPart()) {
                if (!buildingPartProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((BuildingPart)buildingPartProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfAbstractBuilding()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfAbstractBuilding()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(0, this.lod0FootPrint);
        lodRepresentation.addRepresentation(0, this.lod0RoofEdge);
        lodRepresentation.addRepresentation(1, this.lod1Solid);
        lodRepresentation.addRepresentation(2, this.lod2Solid);
        lodRepresentation.addRepresentation(3, this.lod3Solid);
        lodRepresentation.addRepresentation(4, this.lod4Solid);
        lodRepresentation.addRepresentation(1, this.lod1MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiCurve);
        lodRepresentation.addRepresentation(3, this.lod3MultiCurve);
        lodRepresentation.addRepresentation(4, this.lod4MultiCurve);
        return lodRepresentation;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractBuilding copy = (AbstractBuilding)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetYearOfConstruction()) {
            copy.setYearOfConstruction((LocalDate)copyBuilder.copy(this.yearOfConstruction));
        }
        if (this.isSetYearOfDemolition()) {
            copy.setYearOfDemolition((LocalDate)copyBuilder.copy(this.yearOfDemolition));
        }
        if (this.isSetRoofType()) {
            copy.setRoofType((Code)copyBuilder.copy(this.roofType));
        }
        if (this.isSetStoreysAboveGround()) {
            copy.setStoreysAboveGround((Integer)copyBuilder.copy(this.storeysAboveGround));
        }
        if (this.isSetStoreysBelowGround()) {
            copy.setStoreysBelowGround((Integer)copyBuilder.copy(this.storeysBelowGround));
        }
        if (this.isSetMeasuredHeight()) {
            copy.setMeasuredHeight((Length)copyBuilder.copy(this.measuredHeight));
            if (copy.getMeasuredHeight() == this.measuredHeight) {
                this.measuredHeight.setParent(this);
            }
        }
        if (this.isSetStoreyHeightsAboveGround()) {
            copy.setStoreyHeightsAboveGround((MeasureOrNullList)copyBuilder.copy(this.storeyHeightsAboveGround));
            if (copy.getStoreyHeightsAboveGround() == this.storeyHeightsAboveGround) {
                this.storeyHeightsAboveGround.setParent(this);
            }
        }
        if (this.isSetStoreyHeightsBelowGround()) {
            copy.setStoreyHeightsBelowGround((MeasureOrNullList)copyBuilder.copy(this.storeyHeightsBelowGround));
            if (copy.getStoreyHeightsBelowGround() == this.storeyHeightsBelowGround) {
                this.storeyHeightsBelowGround.setParent(this);
            }
        }
        if (this.isSetLod1Solid()) {
            copy.setLod1Solid((SolidProperty)copyBuilder.copy(this.lod1Solid));
            if (copy.getLod1Solid() == this.lod1Solid) {
                this.lod1Solid.setParent(this);
            }
        }
        if (this.isSetLod2Solid()) {
            copy.setLod2Solid((SolidProperty)copyBuilder.copy(this.lod2Solid));
            if (copy.getLod2Solid() == this.lod2Solid) {
                this.lod2Solid.setParent(this);
            }
        }
        if (this.isSetLod3Solid()) {
            copy.setLod3Solid((SolidProperty)copyBuilder.copy(this.lod3Solid));
            if (copy.getLod3Solid() == this.lod3Solid) {
                this.lod3Solid.setParent(this);
            }
        }
        if (this.isSetLod4Solid()) {
            copy.setLod4Solid((SolidProperty)copyBuilder.copy(this.lod4Solid));
            if (copy.getLod4Solid() == this.lod4Solid) {
                this.lod4Solid.setParent(this);
            }
        }
        if (this.isSetLod1TerrainIntersection()) {
            copy.setLod1TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod1TerrainIntersection));
            if (copy.getLod1TerrainIntersection() == this.lod1TerrainIntersection) {
                this.lod1TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod2TerrainIntersection()) {
            copy.setLod2TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod2TerrainIntersection));
            if (copy.getLod2TerrainIntersection() == this.lod2TerrainIntersection) {
                this.lod2TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod3TerrainIntersection()) {
            copy.setLod3TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod3TerrainIntersection));
            if (copy.getLod3TerrainIntersection() == this.lod3TerrainIntersection) {
                this.lod3TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod4TerrainIntersection()) {
            copy.setLod4TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod4TerrainIntersection));
            if (copy.getLod4TerrainIntersection() == this.lod4TerrainIntersection) {
                this.lod4TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod2MultiCurve()) {
            copy.setLod2MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod2MultiCurve));
            if (copy.getLod2MultiCurve() == this.lod2MultiCurve) {
                this.lod2MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod3MultiCurve()) {
            copy.setLod3MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod3MultiCurve));
            if (copy.getLod3MultiCurve() == this.lod3MultiCurve) {
                this.lod3MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod4MultiCurve()) {
            copy.setLod4MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod4MultiCurve));
            if (copy.getLod4MultiCurve() == this.lod4MultiCurve) {
                this.lod4MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod0FootPrint()) {
            copy.setLod0FootPrint((MultiSurfaceProperty)copyBuilder.copy(this.lod0FootPrint));
            if (copy.getLod0FootPrint() == this.lod0FootPrint) {
                this.lod0FootPrint.setParent(this);
            }
        }
        if (this.isSetLod0RoofEdge()) {
            copy.setLod0RoofEdge((MultiSurfaceProperty)copyBuilder.copy(this.lod0RoofEdge));
            if (copy.getLod0RoofEdge() == this.lod0RoofEdge) {
                this.lod0RoofEdge.setParent(this);
            }
        }
        if (this.isSetLod1MultiSurface()) {
            copy.setLod1MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod1MultiSurface));
            if (copy.getLod1MultiSurface() == this.lod1MultiSurface) {
                this.lod1MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetAddress()) {
            for (AddressProperty addressProperty : this.address) {
                copyPart = (AddressProperty)copyBuilder.copy(addressProperty);
                copy.addAddress((AddressProperty)copyPart);
                if (addressProperty == null || copyPart != addressProperty) continue;
                addressProperty.setParent(this);
            }
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : this.boundedBySurface) {
                copyPart = (BoundarySurfaceProperty)copyBuilder.copy(boundarySurfaceProperty);
                copy.addBoundedBySurface((BoundarySurfaceProperty)copyPart);
                if (boundarySurfaceProperty == null || copyPart != boundarySurfaceProperty) continue;
                boundarySurfaceProperty.setParent(this);
            }
        }
        if (this.isSetOuterBuildingInstallation()) {
            for (BuildingInstallationProperty buildingInstallationProperty : this.outerBuildingInstallation) {
                copyPart = (BuildingInstallationProperty)copyBuilder.copy(buildingInstallationProperty);
                copy.addOuterBuildingInstallation((BuildingInstallationProperty)copyPart);
                if (buildingInstallationProperty == null || copyPart != buildingInstallationProperty) continue;
                buildingInstallationProperty.setParent(this);
            }
        }
        if (this.isSetInteriorBuildingInstallation()) {
            for (IntBuildingInstallationProperty intBuildingInstallationProperty : this.interiorBuildingInstallation) {
                copyPart = (IntBuildingInstallationProperty)copyBuilder.copy(intBuildingInstallationProperty);
                copy.addInteriorBuildingInstallation((IntBuildingInstallationProperty)copyPart);
                if (intBuildingInstallationProperty == null || copyPart != intBuildingInstallationProperty) continue;
                intBuildingInstallationProperty.setParent(this);
            }
        }
        if (this.isSetConsistsOfBuildingPart()) {
            for (BuildingPartProperty buildingPartProperty : this.buildingPart) {
                copyPart = (BuildingPartProperty)copyBuilder.copy(buildingPartProperty);
                copy.addConsistsOfBuildingPart((BuildingPartProperty)copyPart);
                if (buildingPartProperty == null || copyPart != buildingPartProperty) continue;
                buildingPartProperty.setParent(this);
            }
        }
        if (this.isSetInteriorRoom()) {
            for (InteriorRoomProperty interiorRoomProperty : this.interiorRoom) {
                copyPart = (InteriorRoomProperty)copyBuilder.copy(interiorRoomProperty);
                copy.addInteriorRoom((InteriorRoomProperty)copyPart);
                if (interiorRoomProperty == null || copyPart != interiorRoomProperty) continue;
                interiorRoomProperty.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfAbstractBuilding()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfAbstractBuilding((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }
}

