/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.cityobjectgroup;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupMember;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupModuleComponent;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupParent;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class CityObjectGroup
extends AbstractCityObject
implements CityObjectGroupModuleComponent,
StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private List<CityObjectGroupMember> groupMember;
    private CityObjectGroupParent groupParent;
    private GeometryProperty<? extends AbstractGeometry> geometry;
    private List<ADEComponent> ade;

    public CityObjectGroup() {
    }

    public CityObjectGroup(Module module) {
        super(module);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfCityObjectGroup(ADEComponent ade) {
        this.getGenericApplicationPropertyOfCityObjectGroup().add(ade);
    }

    public void addGroupMember(CityObjectGroupMember groupMember) {
        this.getGroupMember().add(groupMember);
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfCityObjectGroup() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public GeometryProperty<? extends AbstractGeometry> getGeometry() {
        return this.geometry;
    }

    public List<CityObjectGroupMember> getGroupMember() {
        if (this.groupMember == null) {
            this.groupMember = new ChildList<CityObjectGroupMember>(this);
        }
        return this.groupMember;
    }

    public CityObjectGroupParent getGroupParent() {
        return this.groupParent;
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfCityObjectGroup() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetGeometry() {
        return this.geometry != null;
    }

    public boolean isSetGroupMember() {
        return this.groupMember != null && !this.groupMember.isEmpty();
    }

    public boolean isSetGroupParent() {
        return this.groupParent != null;
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setGenericApplicationPropertyOfCityObjectGroup(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setGeometry(GeometryProperty<? extends AbstractGeometry> geometry) {
        this.geometry = ModelObjects.setParent(geometry, (ModelObject)this);
    }

    public void setGroupMember(List<CityObjectGroupMember> groupMember) {
        this.groupMember = new ChildList<CityObjectGroupMember>((ModelObject)this, groupMember);
    }

    public void setGroupParent(CityObjectGroupParent groupParent) {
        this.groupParent = ModelObjects.setParent(groupParent, (ModelObject)this);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfCityObjectGroup() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfCityObjectGroup(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfCityObjectGroup() && this.ade.remove(ade);
    }

    public void unsetGeometry() {
        this.geometry = ModelObjects.setNull(this.geometry);
    }

    public void unsetGroupMember() {
        this.groupMember = ModelObjects.setNull(this.groupMember);
    }

    public boolean unsetGroupMember(CityObjectGroupMember groupMember) {
        return this.isSetGroupMember() && this.groupMember.remove(groupMember);
    }

    public void unsetGroupParent() {
        this.groupParent = ModelObjects.setNull(this.groupParent);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.CITY_OBJECT_GROUP;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetGeometry() && this.geometry.isSetGeometry()) {
            boundedBy.updateEnvelope(this.geometry.getGeometry().calcBoundingBox());
        }
        if (this.isSetGroupMember()) {
            for (CityObjectGroupMember member : this.groupMember) {
                if (!member.isSetObject()) continue;
                boundedBy.updateEnvelope(((AbstractCityObject)member.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfCityObjectGroup()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfCityObjectGroup()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(this.geometry);
        return lodRepresentation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new CityObjectGroup(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        CityObjectGroup copy = target == null ? new CityObjectGroup() : (CityObjectGroup)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetGroupMember()) {
            for (CityObjectGroupMember cityObjectGroupMember : this.groupMember) {
                copyPart = (CityObjectGroupMember)copyBuilder.copy(cityObjectGroupMember);
                copy.addGroupMember((CityObjectGroupMember)copyPart);
                if (cityObjectGroupMember == null || copyPart != cityObjectGroupMember) continue;
                cityObjectGroupMember.setParent(this);
            }
        }
        if (this.isSetGroupParent()) {
            copy.setGroupParent((CityObjectGroupParent)copyBuilder.copy(this.groupParent));
            if (copy.getGroupParent() == this.groupParent) {
                this.groupParent.setParent(this);
            }
        }
        if (this.isSetGeometry()) {
            copy.setGeometry((GeometryProperty)copyBuilder.copy(this.geometry));
            if (copy.getGeometry() == this.geometry) {
                this.geometry.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfCityObjectGroup()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfCityObjectGroup((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

