/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.core.CoreModuleComponent;
import org.citygml4j.model.citygml.core.ExternalReference;
import org.citygml4j.model.citygml.core.GeneralizationRelation;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.RelativeToTerrain;
import org.citygml4j.model.citygml.core.RelativeToWater;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.base.AssociationByRepOrRef;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.SpatialRepresentation;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractCityObject
extends AbstractFeature
implements CoreModuleComponent {
    private ZonedDateTime creationDate;
    private ZonedDateTime terminationDate;
    private List<ExternalReference> externalReference;
    private List<AbstractGenericAttribute> genericAttribute;
    private List<GeneralizationRelation> generalizesTo;
    private RelativeToTerrain relativeToTerrain;
    private RelativeToWater relativeToWater;
    private List<AppearanceProperty> appearance;
    private List<ADEComponent> ade;

    public AbstractCityObject() {
    }

    public AbstractCityObject(Module module) {
        super(module);
    }

    public void addAppearance(AppearanceProperty appearance) {
        this.getAppearance().add(appearance);
    }

    public void addExternalReference(ExternalReference externalReference) {
        this.getExternalReference().add(externalReference);
    }

    public void addGeneralizesTo(GeneralizationRelation generalizesTo) {
        this.getGeneralizesTo().add(generalizesTo);
    }

    public void addGenericApplicationPropertyOfCityObject(ADEComponent ade) {
        this.getGenericApplicationPropertyOfCityObject().add(ade);
    }

    public void addGenericAttribute(AbstractGenericAttribute genericAttribute) {
        this.getGenericAttribute().add(genericAttribute);
    }

    public List<AppearanceProperty> getAppearance() {
        if (this.appearance == null) {
            this.appearance = new ChildList<AppearanceProperty>(this);
        }
        return this.appearance;
    }

    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public List<ExternalReference> getExternalReference() {
        if (this.externalReference == null) {
            this.externalReference = new ChildList<ExternalReference>(this);
        }
        return this.externalReference;
    }

    public List<GeneralizationRelation> getGeneralizesTo() {
        if (this.generalizesTo == null) {
            this.generalizesTo = new ChildList<GeneralizationRelation>(this);
        }
        return this.generalizesTo;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfCityObject() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public List<AbstractGenericAttribute> getGenericAttribute() {
        if (this.genericAttribute == null) {
            this.genericAttribute = new ChildList<AbstractGenericAttribute>(this);
        }
        return this.genericAttribute;
    }

    public RelativeToTerrain getRelativeToTerrain() {
        return this.relativeToTerrain;
    }

    public RelativeToWater getRelativeToWater() {
        return this.relativeToWater;
    }

    public ZonedDateTime getTerminationDate() {
        return this.terminationDate;
    }

    public boolean isSetAppearance() {
        return this.appearance != null && !this.appearance.isEmpty();
    }

    public boolean isSetCreationDate() {
        return this.creationDate != null;
    }

    public boolean isSetExternalReference() {
        return this.externalReference != null && !this.externalReference.isEmpty();
    }

    public boolean isSetGeneralizesTo() {
        return this.generalizesTo != null && !this.generalizesTo.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfCityObject() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetGenericAttribute() {
        return this.genericAttribute != null && !this.genericAttribute.isEmpty();
    }

    public boolean isSetRelativeToTerrain() {
        return this.relativeToTerrain != null;
    }

    public boolean isSetRelativeToWater() {
        return this.relativeToWater != null;
    }

    public boolean isSetTerminationDate() {
        return this.terminationDate != null;
    }

    public void setAppearance(List<AppearanceProperty> appearance) {
        this.appearance = new ChildList<AppearanceProperty>((ModelObject)this, appearance);
    }

    public void setCreationDate(ZonedDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate.atZone(ZoneId.systemDefault());
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate.atStartOfDay(ZoneId.systemDefault());
    }

    public void setExternalReference(List<ExternalReference> externalReference) {
        this.externalReference = new ChildList<ExternalReference>((ModelObject)this, externalReference);
    }

    public void setGeneralizesTo(List<GeneralizationRelation> generalizesTo) {
        this.generalizesTo = new ChildList<GeneralizationRelation>((ModelObject)this, generalizesTo);
    }

    public void setGenericApplicationPropertyOfCityObject(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setGenericAttribute(List<AbstractGenericAttribute> genericAttribute) {
        this.genericAttribute = new ChildList<AbstractGenericAttribute>((ModelObject)this, genericAttribute);
    }

    public void setRelativeToTerrain(RelativeToTerrain relativeToTerrain) {
        this.relativeToTerrain = relativeToTerrain;
    }

    public void setRelativeToWater(RelativeToWater relativeToWater) {
        this.relativeToWater = relativeToWater;
    }

    public void setTerminationDate(ZonedDateTime terminationDate) {
        this.terminationDate = terminationDate;
    }

    public void setTerminationDate(LocalDateTime terminationDate) {
        this.terminationDate = terminationDate.atZone(ZoneId.systemDefault());
    }

    public void setTerminationDate(LocalDate terminationDate) {
        this.terminationDate = terminationDate.atStartOfDay(ZoneId.systemDefault());
    }

    public void unsetAppearance() {
        this.appearance = ModelObjects.setNull(this.appearance);
    }

    public boolean unsetAppearance(AppearanceProperty appearance) {
        return this.isSetAppearance() && this.appearance.remove(appearance);
    }

    public void unsetCreationDate() {
        this.creationDate = null;
    }

    public void unsetExternalReference() {
        this.externalReference = ModelObjects.setNull(this.externalReference);
    }

    public boolean unsetExternalReference(ExternalReference externalReference) {
        return this.isSetExternalReference() && this.externalReference.remove(externalReference);
    }

    public void unsetGeneralizesTo() {
        this.generalizesTo = ModelObjects.setNull(this.generalizesTo);
    }

    public boolean unsetGeneralizesTo(GeneralizationRelation generalizesTo) {
        return this.isSetGeneralizesTo() && this.generalizesTo.remove(generalizesTo);
    }

    public void unsetGenericApplicationPropertyOfCityObject() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfCityObject(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfCityObject() && this.ade.remove(ade);
    }

    public void unsetGenericAttribute() {
        this.genericAttribute = ModelObjects.setNull(this.genericAttribute);
    }

    public boolean unsetGenericAttribute(AbstractGenericAttribute genericAttribute) {
        return this.isSetGenericAttribute() && this.genericAttribute.remove(genericAttribute);
    }

    public void unsetRelativeToTerrain() {
        this.relativeToTerrain = null;
    }

    public void unsetRelativeToWater() {
        this.relativeToWater = null;
    }

    public void unsetTerminationDate() {
        this.terminationDate = null;
    }

    @Override
    public final SpatialRepresentation getSpatialRepresentation() {
        return this.getLodRepresentation();
    }

    public LodRepresentation getLodRepresentation() {
        return LodRepresentation.emptyRepresentation();
    }

    public void unsetLod(int lod) {
        LodRepresentation representation = this.getLodRepresentation();
        if (representation != null && representation.isSetRepresentation(lod)) {
            for (AssociationByRepOrRef<? extends AbstractGML> property : representation.getRepresentation(lod)) {
                ModelObject parent = property.getParent();
                ModelObjects.unsetProperty(parent != null ? parent : this, property);
            }
        }
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetGenericApplicationPropertyOfCityObject()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfCityObject()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CityGML copyPart;
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractCityObject copy = (AbstractCityObject)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetCreationDate()) {
            copy.setCreationDate((ZonedDateTime)copyBuilder.copy(this.creationDate));
        }
        if (this.isSetTerminationDate()) {
            copy.setTerminationDate((ZonedDateTime)copyBuilder.copy(this.terminationDate));
        }
        if (this.isSetRelativeToTerrain()) {
            copy.setRelativeToTerrain((RelativeToTerrain)copyBuilder.copy(this.relativeToTerrain));
        }
        if (this.isSetRelativeToWater()) {
            copy.setRelativeToWater((RelativeToWater)copyBuilder.copy(this.relativeToWater));
        }
        if (this.isSetExternalReference()) {
            for (ExternalReference externalReference : this.externalReference) {
                copyPart = (ExternalReference)copyBuilder.copy(externalReference);
                copy.addExternalReference((ExternalReference)copyPart);
                if (externalReference == null || copyPart != externalReference) continue;
                externalReference.setParent(this);
            }
        }
        if (this.isSetGenericAttribute()) {
            for (AbstractGenericAttribute abstractGenericAttribute : this.genericAttribute) {
                copyPart = (AbstractGenericAttribute)copyBuilder.copy(abstractGenericAttribute);
                copy.addGenericAttribute((AbstractGenericAttribute)copyPart);
                if (abstractGenericAttribute == null || copyPart != abstractGenericAttribute) continue;
                abstractGenericAttribute.setParent(this);
            }
        }
        if (this.isSetGeneralizesTo()) {
            for (GeneralizationRelation generalizationRelation : this.generalizesTo) {
                copyPart = (GeneralizationRelation)copyBuilder.copy(generalizationRelation);
                copy.addGeneralizesTo((GeneralizationRelation)copyPart);
                if (generalizationRelation == null || copyPart != generalizationRelation) continue;
                generalizationRelation.setParent(this);
            }
        }
        if (this.isSetAppearance()) {
            for (AppearanceProperty appearanceProperty : this.appearance) {
                copyPart = (AppearanceProperty)copyBuilder.copy(appearanceProperty);
                copy.addAppearance((AppearanceProperty)copyPart);
                if (appearanceProperty == null || copyPart != appearanceProperty) continue;
                appearanceProperty.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfCityObject()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfCityObject((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }
}

