/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.core;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.geometry.Matrix;
import org.citygml4j.geometry.Point;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.core.CoreModuleComponent;
import org.citygml4j.model.citygml.core.TransformationMatrix4x4;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class ImplicitGeometry
extends AbstractGML
implements CoreModuleComponent {
    private Code mimeType;
    private TransformationMatrix4x4 transformationMatrix;
    private String libraryObject;
    private GeometryProperty<? extends AbstractGeometry> relativeGeometry;
    private PointProperty referencePoint;

    public String getLibraryObject() {
        return this.libraryObject;
    }

    public Code getMimeType() {
        return this.mimeType;
    }

    public PointProperty getReferencePoint() {
        return this.referencePoint;
    }

    public GeometryProperty<? extends AbstractGeometry> getRelativeGMLGeometry() {
        return this.relativeGeometry;
    }

    public TransformationMatrix4x4 getTransformationMatrix() {
        return this.transformationMatrix;
    }

    public boolean isSetLibraryObject() {
        return this.libraryObject != null;
    }

    public boolean isSetMimeType() {
        return this.mimeType != null;
    }

    public boolean isSetReferencePoint() {
        return this.referencePoint != null;
    }

    public boolean isSetRelativeGMLGeometry() {
        return this.relativeGeometry != null;
    }

    public boolean isSetTransformationMatrix() {
        return this.transformationMatrix != null;
    }

    public void setLibraryObject(String libraryObject) {
        this.libraryObject = libraryObject;
    }

    public void setMimeType(Code mimeType) {
        this.mimeType = ModelObjects.setParent(mimeType, (ModelObject)this);
    }

    public void setReferencePoint(PointProperty referencePoint) {
        this.referencePoint = ModelObjects.setParent(referencePoint, (ModelObject)this);
    }

    public void setRelativeGeometry(GeometryProperty<? extends AbstractGeometry> relativeGeometry) {
        this.relativeGeometry = ModelObjects.setParent(relativeGeometry, (ModelObject)this);
    }

    public void setTransformationMatrix(TransformationMatrix4x4 transformationMatrix) {
        this.transformationMatrix = ModelObjects.setParent(transformationMatrix, (ModelObject)this);
    }

    public void unsetLibraryObject() {
        this.libraryObject = null;
    }

    public void unsetMimeType() {
        this.mimeType = ModelObjects.setNull(this.mimeType);
    }

    public void unsetReferencePoint() {
        this.referencePoint = ModelObjects.setNull(this.referencePoint);
    }

    public void unsetRelativeGMLGeometry() {
        this.relativeGeometry = ModelObjects.setNull(this.relativeGeometry);
    }

    public void unsetTransformationMatrix() {
        this.transformationMatrix = ModelObjects.setNull(this.transformationMatrix);
    }

    public BoundingBox calcBoundingBox(BoundingBoxOptions options) {
        if (this.relativeGeometry == null || !this.relativeGeometry.isSetGeometry() || options.isUseReferencePointForImplicitGeometries()) {
            if (this.referencePoint != null && this.referencePoint.isSetPoint()) {
                List<Double> coord = this.referencePoint.getPoint().toList3d();
                if (this.transformationMatrix != null) {
                    Matrix m = this.transformationMatrix.getMatrix();
                    coord.set(0, coord.get(0) + m.get(0, 3));
                    coord.set(1, coord.get(1) + m.get(1, 3));
                    coord.set(2, coord.get(2) + m.get(2, 3));
                }
                return new BoundingBox(new Point(coord.get(0), coord.get(1), coord.get(2)), new Point(coord.get(0), coord.get(1), coord.get(2)));
            }
        } else {
            BoundingBox bbox = this.relativeGeometry.getGeometry().calcBoundingBox();
            if (bbox != null) {
                if (this.transformationMatrix != null && this.referencePoint != null && this.referencePoint.isSetPoint()) {
                    Matrix m = this.transformationMatrix.getMatrix().copy();
                    List<Double> point = this.referencePoint.getPoint().toList3d();
                    m.set(0, 3, m.get(0, 3) + point.get(0));
                    m.set(1, 3, m.get(1, 3) + point.get(1));
                    m.set(2, 3, m.get(2, 3) + point.get(2));
                    bbox.transform3d(m);
                }
                return bbox;
            }
        }
        return null;
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.IMPLICIT_GEOMETRY;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new ImplicitGeometry(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        ImplicitGeometry copy = target == null ? new ImplicitGeometry() : (ImplicitGeometry)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLibraryObject()) {
            copy.setLibraryObject(copyBuilder.copy(this.libraryObject));
        }
        if (this.isSetMimeType()) {
            copy.setMimeType((Code)copyBuilder.copy(this.mimeType));
        }
        if (this.isSetReferencePoint()) {
            copy.setReferencePoint((PointProperty)copyBuilder.copy(this.referencePoint));
            if (copy.getReferencePoint() == this.referencePoint) {
                this.referencePoint.setParent(this);
            }
        }
        if (this.isSetRelativeGMLGeometry()) {
            copy.setRelativeGeometry((GeometryProperty)copyBuilder.copy(this.relativeGeometry));
            if (copy.getRelativeGMLGeometry() == this.relativeGeometry) {
                this.relativeGeometry.setParent(this);
            }
        }
        if (this.isSetTransformationMatrix()) {
            copy.setTransformationMatrix((TransformationMatrix4x4)copyBuilder.copy(this.transformationMatrix));
            if (copy.getTransformationMatrix() == this.transformationMatrix) {
                this.transformationMatrix.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

