/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.generics;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;

public class DateAttribute
extends AbstractGenericAttribute {
    private LocalDate value;

    public DateAttribute() {
    }

    public DateAttribute(LocalDate value) {
        this.value = value;
    }

    public DateAttribute(Date value) {
        this.value = value.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public DateAttribute(String name, LocalDate value) {
        this(value);
        this.setName(name);
    }

    public DateAttribute(String name, Date value) {
        this(value);
        this.setName(name);
    }

    public LocalDate getValue() {
        return this.value;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValue(LocalDate value) {
        this.value = value;
    }

    public void unsetValue() {
        this.value = null;
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.DATE_ATTRIBUTE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new DateAttribute(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        DateAttribute copy = target == null ? new DateAttribute() : (DateAttribute)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetValue()) {
            copy.setValue((LocalDate)copyBuilder.copy(this.value));
        }
        return copy;
    }
}

