/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.relief;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.relief.ReliefModuleComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.primitives.PolygonProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractReliefComponent
extends AbstractCityObject
implements ReliefModuleComponent {
    private int lod;
    private PolygonProperty extent;
    private List<ADEComponent> ade;

    public AbstractReliefComponent() {
    }

    public AbstractReliefComponent(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfReliefComponent(ADEComponent ade) {
        this.getGenericApplicationPropertyOfReliefComponent().add(ade);
    }

    public PolygonProperty getExtent() {
        return this.extent;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfReliefComponent() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public int getLod() {
        return this.lod;
    }

    public boolean isSetExtent() {
        return this.extent != null;
    }

    public boolean isSetGenericApplicationPropertyOfReliefComponent() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod() {
        return true;
    }

    public void setExtent(PolygonProperty extent) {
        this.extent = ModelObjects.setParent(extent, (ModelObject)this);
    }

    public void setGenericApplicationPropertyOfReliefComponent(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod(int lod) {
        if (lod >= 0 && lod <= 4) {
            this.lod = lod;
        }
    }

    public void unsetExtent() {
        this.extent = ModelObjects.setNull(this.extent);
    }

    public void unsetGenericApplicationPropertyOfReliefComponent() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfReliefComponent(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfReliefComponent() && this.ade.remove(ade);
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetExtent() && this.extent.isSetPolygon()) {
            boundedBy.updateEnvelope(this.extent.getPolygon().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfReliefComponent()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfReliefComponent()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractReliefComponent copy = (AbstractReliefComponent)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLod()) {
            copy.setLod(copyBuilder.copy(this.lod));
        }
        if (this.isSetExtent()) {
            copy.setExtent((PolygonProperty)copyBuilder.copy(this.extent));
            if (copy.getExtent() == this.extent) {
                this.extent.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfReliefComponent()) {
            for (ADEComponent part : this.ade) {
                ADEComponent copyPart = (ADEComponent)copyBuilder.copy(part);
                copy.addGenericApplicationPropertyOfReliefComponent(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }
}

