/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.relief;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.relief.AbstractReliefComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurveProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class BreaklineRelief
extends AbstractReliefComponent {
    private MultiCurveProperty ridgeOrValleyLines;
    private MultiCurveProperty breaklines;
    private List<ADEComponent> ade;

    public BreaklineRelief() {
    }

    public BreaklineRelief(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfBreaklineRelief(ADEComponent ade) {
        this.getGenericApplicationPropertyOfBreaklineRelief().add(ade);
    }

    public MultiCurveProperty getBreaklines() {
        return this.breaklines;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfBreaklineRelief() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiCurveProperty getRidgeOrValleyLines() {
        return this.ridgeOrValleyLines;
    }

    public boolean isSetBreaklines() {
        return this.breaklines != null;
    }

    public boolean isSetGenericApplicationPropertyOfBreaklineRelief() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetRidgeOrValleyLines() {
        return this.ridgeOrValleyLines != null;
    }

    public void setBreaklines(MultiCurveProperty breaklines) {
        this.breaklines = ModelObjects.setParent(breaklines, (ModelObject)this);
    }

    public void setGenericApplicationPropertyOfBreaklineRelief(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setRidgeOrValleyLines(MultiCurveProperty ridgeOrValleyLines) {
        this.ridgeOrValleyLines = ModelObjects.setParent(ridgeOrValleyLines, (ModelObject)this);
    }

    public void unsetBreaklines() {
        this.breaklines = ModelObjects.setNull(this.breaklines);
    }

    public void unsetGenericApplicationPropertyOfBreaklineRelief() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfBreaklineRelief(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfBreaklineRelief() && this.ade.remove(ade);
    }

    public void unsetRidgeOrValleyLines() {
        this.ridgeOrValleyLines = ModelObjects.setNull(this.ridgeOrValleyLines);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.BREAKLINE_RELIEF;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetBreaklines() && this.breaklines.isSetMultiCurve()) {
            boundedBy.updateEnvelope(this.breaklines.getMultiCurve().calcBoundingBox());
        }
        if (this.isSetRidgeOrValleyLines() && this.ridgeOrValleyLines.isSetMultiCurve()) {
            boundedBy.updateEnvelope(this.ridgeOrValleyLines.getMultiCurve().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfBreaklineRelief()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfBreaklineRelief()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(this.getLod(), this.ridgeOrValleyLines);
        lodRepresentation.addRepresentation(this.getLod(), this.breaklines);
        return lodRepresentation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new BreaklineRelief(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        BreaklineRelief copy = target == null ? new BreaklineRelief() : (BreaklineRelief)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetBreaklines()) {
            copy.setBreaklines((MultiCurveProperty)copyBuilder.copy(this.breaklines));
            if (copy.getBreaklines() == this.breaklines) {
                this.breaklines.setParent(this);
            }
        }
        if (this.isSetRidgeOrValleyLines()) {
            copy.setRidgeOrValleyLines((MultiCurveProperty)copyBuilder.copy(this.ridgeOrValleyLines));
            if (copy.getRidgeOrValleyLines() == this.ridgeOrValleyLines) {
                this.ridgeOrValleyLines.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfBreaklineRelief()) {
            for (ADEComponent part : this.ade) {
                ADEComponent copyPart = (ADEComponent)copyBuilder.copy(part);
                copy.addGenericApplicationPropertyOfBreaklineRelief(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

