/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.transportation;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.citygml.transportation.AbstractTransportationObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class AuxiliaryTrafficArea
extends AbstractTransportationObject
implements StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private Code surfaceMaterial;
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private List<ADEComponent> ade;

    public AuxiliaryTrafficArea() {
    }

    public AuxiliaryTrafficArea(Module module) {
        super(module);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfAuxiliaryTrafficArea(ADEComponent ade) {
        this.getGenericApplicationPropertyOfAuxiliaryTrafficArea().add(ade);
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfAuxiliaryTrafficArea() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public Code getSurfaceMaterial() {
        return this.surfaceMaterial;
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfAuxiliaryTrafficArea() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetSurfaceMaterial() {
        return this.surfaceMaterial != null;
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setGenericApplicationPropertyOfAuxiliaryTrafficArea(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setSurfaceMaterial(Code surfaceMaterial) {
        this.surfaceMaterial = ModelObjects.setParent(surfaceMaterial, (ModelObject)this);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfAuxiliaryTrafficArea() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfAuxiliaryTrafficArea(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfAuxiliaryTrafficArea() && this.ade.remove(ade);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetSurfaceMaterial() {
        this.surfaceMaterial = ModelObjects.setNull(this.surfaceMaterial);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.AUXILIARY_TRAFFIC_AREA;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 2; lod < 5; ++lod) {
            switch (lod) {
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfAuxiliaryTrafficArea()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfAuxiliaryTrafficArea()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        return lodRepresentation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new AuxiliaryTrafficArea(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        AuxiliaryTrafficArea copy = target == null ? new AuxiliaryTrafficArea() : (AuxiliaryTrafficArea)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetSurfaceMaterial()) {
            copy.setSurfaceMaterial((Code)copyBuilder.copy(this.surfaceMaterial));
        }
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfAuxiliaryTrafficArea()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfAuxiliaryTrafficArea((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

