/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.transportation;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.citygml.transportation.AbstractTransportationObject;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficArea;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficAreaProperty;
import org.citygml4j.model.citygml.transportation.TrafficArea;
import org.citygml4j.model.citygml.transportation.TrafficAreaProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplex;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplexProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.AbstractGeometricPrimitive;
import org.citygml4j.model.gml.geometry.primitives.GeometricPrimitiveProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class TransportationComplex
extends AbstractTransportationObject
implements StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private List<TrafficAreaProperty> trafficArea;
    private List<AuxiliaryTrafficAreaProperty> auxiliaryTrafficArea;
    private List<GeometricComplexProperty> lod0Network;
    private MultiSurfaceProperty lod1MultiSurface;
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private List<ADEComponent> ade;

    public TransportationComplex() {
    }

    public TransportationComplex(Module module) {
        super(module);
    }

    public void addAuxiliaryTrafficArea(AuxiliaryTrafficAreaProperty auxiliaryTrafficArea) {
        this.getAuxiliaryTrafficArea().add(auxiliaryTrafficArea);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfTransportationComplex(ADEComponent ade) {
        this.getGenericApplicationPropertyOfTransportationComplex().add(ade);
    }

    public void addLod0Network(GeometricComplexProperty lod0Network) {
        this.getLod0Network().add(lod0Network);
    }

    public void addTrafficArea(TrafficAreaProperty trafficArea) {
        this.getTrafficArea().add(trafficArea);
    }

    public List<AuxiliaryTrafficAreaProperty> getAuxiliaryTrafficArea() {
        if (this.auxiliaryTrafficArea == null) {
            this.auxiliaryTrafficArea = new ChildList<AuxiliaryTrafficAreaProperty>(this);
        }
        return this.auxiliaryTrafficArea;
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfTransportationComplex() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public List<GeometricComplexProperty> getLod0Network() {
        if (this.lod0Network == null) {
            this.lod0Network = new ChildList<GeometricComplexProperty>(this);
        }
        return this.lod0Network;
    }

    public MultiSurfaceProperty getLod1MultiSurface() {
        return this.lod1MultiSurface;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public List<TrafficAreaProperty> getTrafficArea() {
        if (this.trafficArea == null) {
            this.trafficArea = new ChildList<TrafficAreaProperty>(this);
        }
        return this.trafficArea;
    }

    public boolean isSetAuxiliaryTrafficArea() {
        return this.auxiliaryTrafficArea != null && !this.auxiliaryTrafficArea.isEmpty();
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfTransportationComplex() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod0Network() {
        return this.lod0Network != null && !this.lod0Network.isEmpty();
    }

    public boolean isSetLod1MultiSurface() {
        return this.lod1MultiSurface != null;
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetTrafficArea() {
        return this.trafficArea != null && !this.trafficArea.isEmpty();
    }

    public void setAuxiliaryTrafficArea(List<AuxiliaryTrafficAreaProperty> auxiliaryTrafficArea) {
        this.auxiliaryTrafficArea = new ChildList<AuxiliaryTrafficAreaProperty>((ModelObject)this, auxiliaryTrafficArea);
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setGenericApplicationPropertyOfTransportationComplex(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod0Network(List<GeometricComplexProperty> lod0Network) {
        this.lod0Network = new ChildList<GeometricComplexProperty>((ModelObject)this, lod0Network);
    }

    public void setLod1MultiSurface(MultiSurfaceProperty lod1MultiSurface) {
        this.lod1MultiSurface = ModelObjects.setParent(lod1MultiSurface, (ModelObject)this);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setTrafficArea(List<TrafficAreaProperty> trafficArea) {
        this.trafficArea = new ChildList<TrafficAreaProperty>((ModelObject)this, trafficArea);
    }

    public void unsetAuxiliaryTrafficArea() {
        this.auxiliaryTrafficArea = ModelObjects.setNull(this.auxiliaryTrafficArea);
    }

    public boolean unsetAuxiliaryTrafficArea(AuxiliaryTrafficAreaProperty auxiliaryTrafficArea) {
        return this.isSetAuxiliaryTrafficArea() && this.auxiliaryTrafficArea.remove(auxiliaryTrafficArea);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfTransportationComplex() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfTransportationComplex(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfTransportationComplex() && this.ade.remove(ade);
    }

    public void unsetLod0Network() {
        this.lod0Network = ModelObjects.setNull(this.lod0Network);
    }

    public boolean unsetLod0Network(GeometricComplexProperty lod0Network) {
        return this.isSetLod0Network() && this.lod0Network.remove(lod0Network);
    }

    public void unsetLod1MultiSurface() {
        this.lod1MultiSurface = ModelObjects.setNull(this.lod1MultiSurface);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetTrafficArea() {
        this.trafficArea = ModelObjects.setNull(this.trafficArea);
    }

    public boolean unsetTrafficArea(TrafficAreaProperty trafficArea) {
        return this.isSetTrafficArea() && this.trafficArea.remove(trafficArea);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.TRANSPORTATION_COMPLEX;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    multiSurfaceProperty = this.lod1MultiSurface;
                    break;
                }
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        if (this.isSetLod0Network()) {
            for (GeometricComplexProperty geomProperty : this.lod0Network) {
                GeometricComplex complex;
                if (geomProperty.isSetCompositeCurve()) {
                    if (!geomProperty.isSetCompositeCurve()) continue;
                    boundedBy.updateEnvelope(geomProperty.getCompositeCurve().calcBoundingBox());
                    continue;
                }
                if (!geomProperty.isSetGeometricComplex() || !(complex = geomProperty.getGeometricComplex()).isSetElement()) continue;
                for (GeometricPrimitiveProperty primitiveProperty : complex.getElement()) {
                    AbstractGeometricPrimitive absPrimitive = primitiveProperty.getGeometricPrimitive();
                    if (absPrimitive == null || !(absPrimitive instanceof AbstractCurve)) continue;
                    boundedBy.updateEnvelope(absPrimitive.calcBoundingBox());
                }
            }
        }
        if (this.isSetAuxiliaryTrafficArea()) {
            for (AuxiliaryTrafficAreaProperty auxTrafficAreaProperty : this.auxiliaryTrafficArea) {
                if (!auxTrafficAreaProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((AuxiliaryTrafficArea)auxTrafficAreaProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetTrafficArea()) {
            for (TrafficAreaProperty trafficAreaProperty : this.trafficArea) {
                if (!trafficAreaProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((TrafficArea)trafficAreaProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfTransportationComplex()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfTransportationComplex()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        if (this.lod0Network != null) {
            for (GeometricComplexProperty property : this.lod0Network) {
                if (property == null) continue;
                lodRepresentation.addRepresentation(0, property);
            }
        }
        lodRepresentation.addRepresentation(1, this.lod1MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        return lodRepresentation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new TransportationComplex(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        TransportationComplex copy = target == null ? new TransportationComplex() : (TransportationComplex)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetAuxiliaryTrafficArea()) {
            for (AuxiliaryTrafficAreaProperty auxiliaryTrafficAreaProperty : this.auxiliaryTrafficArea) {
                copyPart = (AuxiliaryTrafficAreaProperty)copyBuilder.copy(auxiliaryTrafficAreaProperty);
                copy.addAuxiliaryTrafficArea((AuxiliaryTrafficAreaProperty)copyPart);
                if (auxiliaryTrafficAreaProperty == null || copyPart != auxiliaryTrafficAreaProperty) continue;
                auxiliaryTrafficAreaProperty.setParent(this);
            }
        }
        if (this.isSetTrafficArea()) {
            for (TrafficAreaProperty trafficAreaProperty : this.trafficArea) {
                copyPart = (TrafficAreaProperty)copyBuilder.copy(trafficAreaProperty);
                copy.addTrafficArea((TrafficAreaProperty)copyPart);
                if (trafficAreaProperty == null || copyPart != trafficAreaProperty) continue;
                trafficAreaProperty.setParent(this);
            }
        }
        if (this.isSetLod0Network()) {
            for (GeometricComplexProperty geometricComplexProperty : this.lod0Network) {
                copyPart = (GeometricComplexProperty)copyBuilder.copy(geometricComplexProperty);
                copy.addLod0Network((GeometricComplexProperty)copyPart);
                if (geometricComplexProperty == null || copyPart != geometricComplexProperty) continue;
                geometricComplexProperty.setParent(this);
            }
        }
        if (this.isSetLod1MultiSurface()) {
            copy.setLod1MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod1MultiSurface));
            if (copy.getLod1MultiSurface() == this.lod1MultiSurface) {
                this.lod1MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfTransportationComplex()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfTransportationComplex((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

