/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.tunnel;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.tunnel.OpeningProperty;
import org.citygml4j.model.citygml.tunnel.TunnelModuleComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractBoundarySurface
extends AbstractCityObject
implements TunnelModuleComponent {
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private List<OpeningProperty> opening;
    private List<ADEComponent> ade;

    public AbstractBoundarySurface() {
    }

    public AbstractBoundarySurface(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfBoundarySurface(ADEComponent ade) {
        this.getGenericApplicationPropertyOfBoundarySurface().add(ade);
    }

    public void addOpening(OpeningProperty opening) {
        this.getOpening().add(opening);
    }

    public List<ADEComponent> getGenericApplicationPropertyOfBoundarySurface() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public List<OpeningProperty> getOpening() {
        if (this.opening == null) {
            this.opening = new ChildList<OpeningProperty>(this);
        }
        return this.opening;
    }

    public boolean isSetGenericApplicationPropertyOfBoundarySurface() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetOpening() {
        return this.opening != null && !this.opening.isEmpty();
    }

    public void setGenericApplicationPropertyOfBoundarySurface(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setOpening(List<OpeningProperty> opening) {
        this.opening = new ChildList<OpeningProperty>((ModelObject)this, opening);
    }

    public void unsetGenericApplicationPropertyOfBoundarySurface() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfBoundarySurface(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfBoundarySurface() && this.ade.remove(ade);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetOpening() {
        this.opening = ModelObjects.setNull(this.opening);
    }

    public boolean unsetOpening(OpeningProperty opening) {
        return this.isSetOpening() && this.opening.remove(opening);
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 2; lod < 5; ++lod) {
            switch (lod) {
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfBoundarySurface()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfBoundarySurface()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        return lodRepresentation;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CityGML copyPart;
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractBoundarySurface copy = (AbstractBoundarySurface)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetOpening()) {
            for (OpeningProperty openingProperty : this.opening) {
                copyPart = (OpeningProperty)copyBuilder.copy(openingProperty);
                copy.addOpening((OpeningProperty)copyPart);
                if (openingProperty == null || copyPart != openingProperty) continue;
                openingProperty.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfBoundarySurface()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfBoundarySurface((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }
}

