/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.vegetation;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.citygml.vegetation.AbstractVegetationObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolidProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.measures.Length;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class PlantCover
extends AbstractVegetationObject
implements StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private Length averageHeight;
    private MultiSurfaceProperty lod1MultiSurface;
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private MultiSolidProperty lod1MultiSolid;
    private MultiSolidProperty lod2MultiSolid;
    private MultiSolidProperty lod3MultiSolid;
    private MultiSolidProperty lod4MultiSolid;
    private List<ADEComponent> ade;

    public PlantCover() {
    }

    public PlantCover(Module module) {
        super(module);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfPlantCover(ADEComponent ade) {
        this.getGenericApplicationPropertyOfPlantCover().add(ade);
    }

    public Length getAverageHeight() {
        return this.averageHeight;
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfPlantCover() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiSolidProperty getLod1MultiSolid() {
        return this.lod1MultiSolid;
    }

    public MultiSurfaceProperty getLod1MultiSurface() {
        return this.lod1MultiSurface;
    }

    public MultiSolidProperty getLod2MultiSolid() {
        return this.lod2MultiSolid;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public MultiSolidProperty getLod3MultiSolid() {
        return this.lod3MultiSolid;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public MultiSolidProperty getLod4MultiSolid() {
        return this.lod4MultiSolid;
    }

    public boolean isSetAverageHeight() {
        return this.averageHeight != null;
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfPlantCover() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod1MultiSolid() {
        return this.lod1MultiSolid != null;
    }

    public boolean isSetLod1MultiSurface() {
        return this.lod1MultiSurface != null;
    }

    public boolean isSetLod2MultiSolid() {
        return this.lod2MultiSolid != null;
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod3MultiSolid() {
        return this.lod3MultiSolid != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetLod4MultiSolid() {
        return this.lod4MultiSolid != null;
    }

    public void setAverageHeight(Length averageHeight) {
        this.averageHeight = ModelObjects.setParent(averageHeight, (ModelObject)this);
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setGenericApplicationPropertyOfPlantCover(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod1MultiSolid(MultiSolidProperty lod1MultiSolid) {
        this.lod1MultiSolid = ModelObjects.setParent(lod1MultiSolid, (ModelObject)this);
    }

    public void setLod1MultiSurface(MultiSurfaceProperty lod1MultiSurface) {
        this.lod1MultiSurface = ModelObjects.setParent(lod1MultiSurface, (ModelObject)this);
    }

    public void setLod2MultiSolid(MultiSolidProperty lod2MultiSolid) {
        this.lod2MultiSolid = ModelObjects.setParent(lod2MultiSolid, (ModelObject)this);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod3MultiSolid(MultiSolidProperty lod3MultiSolid) {
        this.lod3MultiSolid = ModelObjects.setParent(lod3MultiSolid, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setLod4MultiSolid(MultiSolidProperty lod4MultiSolid) {
        this.lod3MultiSolid = ModelObjects.setParent(lod4MultiSolid, (ModelObject)this);
    }

    public void unsetAverageHeight() {
        this.averageHeight = ModelObjects.setNull(this.averageHeight);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetGenericApplicationPropertyOfPlantCover() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfPlantCover(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfPlantCover() && this.ade.remove(ade);
    }

    public void unsetLod1MultiSolid() {
        this.lod1MultiSolid = ModelObjects.setNull(this.lod1MultiSolid);
    }

    public void unsetLod1MultiSurface() {
        this.lod1MultiSurface = ModelObjects.setNull(this.lod1MultiSurface);
    }

    public void unsetLod2MultiSolid() {
        this.lod2MultiSolid = ModelObjects.setNull(this.lod2MultiSolid);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod3MultiSolid() {
        this.lod3MultiSolid = ModelObjects.setNull(this.lod3MultiSolid);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetLod4MultiSolid() {
        this.lod4MultiSolid = ModelObjects.setNull(this.lod4MultiSolid);
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        MultiSolidProperty multiSolidProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    multiSolidProperty = this.lod1MultiSolid;
                    break;
                }
                case 2: {
                    multiSolidProperty = this.lod2MultiSolid;
                    break;
                }
                case 3: {
                    multiSolidProperty = this.lod3MultiSolid;
                    break;
                }
                case 4: {
                    multiSolidProperty = this.lod4MultiSolid;
                }
            }
            if (multiSolidProperty == null || !multiSolidProperty.isSetMultiSolid()) continue;
            boundedBy.updateEnvelope(multiSolidProperty.getMultiSolid().calcBoundingBox());
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    multiSurfaceProperty = this.lod1MultiSurface;
                    break;
                }
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfPlantCover()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfPlantCover()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(1, this.lod1MultiSolid);
        lodRepresentation.addRepresentation(2, this.lod2MultiSolid);
        lodRepresentation.addRepresentation(3, this.lod3MultiSolid);
        lodRepresentation.addRepresentation(4, this.lod4MultiSolid);
        lodRepresentation.addRepresentation(1, this.lod1MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        return lodRepresentation;
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.PLANT_COVER;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new PlantCover(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        PlantCover copy = target == null ? new PlantCover() : (PlantCover)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetAverageHeight()) {
            copy.setAverageHeight((Length)copyBuilder.copy(this.averageHeight));
            if (copy.getAverageHeight() == this.averageHeight) {
                this.averageHeight.setParent(this);
            }
        }
        if (this.isSetLod1MultiSurface()) {
            copy.setLod1MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod1MultiSurface));
            if (copy.getLod1MultiSurface() == this.lod1MultiSurface) {
                this.lod1MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod1MultiSolid()) {
            copy.setLod1MultiSolid((MultiSolidProperty)copyBuilder.copy(this.lod1MultiSolid));
            if (copy.getLod1MultiSolid() == this.lod1MultiSolid) {
                this.lod1MultiSolid.setParent(this);
            }
        }
        if (this.isSetLod2MultiSolid()) {
            copy.setLod2MultiSolid((MultiSolidProperty)copyBuilder.copy(this.lod2MultiSolid));
            if (copy.getLod2MultiSolid() == this.lod2MultiSolid) {
                this.lod2MultiSolid.setParent(this);
            }
        }
        if (this.isSetLod3MultiSolid()) {
            copy.setLod3MultiSolid((MultiSolidProperty)copyBuilder.copy(this.lod3MultiSolid));
            if (copy.getLod3MultiSolid() == this.lod3MultiSolid) {
                this.lod3MultiSolid.setParent(this);
            }
        }
        if (this.isSetLod4MultiSolid()) {
            copy.setLod4MultiSolid((MultiSolidProperty)copyBuilder.copy(this.lod4MultiSolid));
            if (copy.getLod4MultiSolid() == this.lod4MultiSolid) {
                this.lod4MultiSolid.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfPlantCover()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfPlantCover((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

