/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.waterbody;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.waterbody.WaterBodyModuleComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractWaterBoundarySurface
extends AbstractCityObject
implements WaterBodyModuleComponent {
    private SurfaceProperty lod2Surface;
    private SurfaceProperty lod3Surface;
    private SurfaceProperty lod4Surface;
    private List<ADEComponent> ade;

    public AbstractWaterBoundarySurface() {
    }

    public AbstractWaterBoundarySurface(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfWaterBoundarySurface(ADEComponent ade) {
        this.getGenericApplicationPropertyOfWaterBoundarySurface().add(ade);
    }

    public List<ADEComponent> getGenericApplicationPropertyOfWaterBoundarySurface() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public SurfaceProperty getLod2Surface() {
        return this.lod2Surface;
    }

    public SurfaceProperty getLod3Surface() {
        return this.lod3Surface;
    }

    public SurfaceProperty getLod4Surface() {
        return this.lod4Surface;
    }

    public boolean isSetGenericApplicationPropertyOfWaterBoundarySurface() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetLod2Surface() {
        return this.lod2Surface != null;
    }

    public boolean isSetLod3Surface() {
        return this.lod3Surface != null;
    }

    public boolean isSetLod4Surface() {
        return this.lod4Surface != null;
    }

    public void setGenericApplicationPropertyOfWaterBoundarySurface(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setLod2Surface(SurfaceProperty lod2Surface) {
        this.lod2Surface = ModelObjects.setParent(lod2Surface, (ModelObject)this);
    }

    public void setLod3Surface(SurfaceProperty lod3Surface) {
        this.lod3Surface = ModelObjects.setParent(lod3Surface, (ModelObject)this);
    }

    public void setLod4Surface(SurfaceProperty lod4Surface) {
        this.lod4Surface = ModelObjects.setParent(lod4Surface, (ModelObject)this);
    }

    public void unsetGenericApplicationPropertyOfWaterBoundarySurface() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfWaterBoundarySurface(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfWaterBoundarySurface() && this.ade.remove(ade);
    }

    public void unsetLod2Surface() {
        this.lod2Surface = ModelObjects.setNull(this.lod2Surface);
    }

    public void unsetLod3Surface() {
        this.lod3Surface = ModelObjects.setNull(this.lod3Surface);
    }

    public void unsetLod4Surface() {
        this.lod4Surface = ModelObjects.setNull(this.lod4Surface);
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        SurfaceProperty surfaceProperty = null;
        for (int lod = 2; lod < 5; ++lod) {
            switch (lod) {
                case 2: {
                    surfaceProperty = this.lod2Surface;
                    break;
                }
                case 3: {
                    surfaceProperty = this.lod3Surface;
                    break;
                }
                case 4: {
                    surfaceProperty = this.lod4Surface;
                }
            }
            if (surfaceProperty == null || !surfaceProperty.isSetSurface()) continue;
            boundedBy.updateEnvelope(surfaceProperty.getSurface().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfWaterBoundarySurface()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfWaterBoundarySurface()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(2, this.lod2Surface);
        lodRepresentation.addRepresentation(3, this.lod3Surface);
        lodRepresentation.addRepresentation(4, this.lod4Surface);
        return lodRepresentation;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractWaterBoundarySurface copy = (AbstractWaterBoundarySurface)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLod2Surface()) {
            copy.setLod2Surface((SurfaceProperty)copyBuilder.copy(this.lod2Surface));
            if (copy.getLod2Surface() == this.lod2Surface) {
                this.lod2Surface.setParent(this);
            }
        }
        if (this.isSetLod3Surface()) {
            copy.setLod3Surface((SurfaceProperty)copyBuilder.copy(this.lod3Surface));
            if (copy.getLod3Surface() == this.lod3Surface) {
                this.lod3Surface.setParent(this);
            }
        }
        if (this.isSetLod4Surface()) {
            copy.setLod4Surface((SurfaceProperty)copyBuilder.copy(this.lod4Surface));
            if (copy.getLod4Surface() == this.lod4Surface) {
                this.lod4Surface.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfWaterBoundarySurface()) {
            for (ADEComponent part : this.ade) {
                ADEComponent copyPart = (ADEComponent)copyBuilder.copy(part);
                copy.addGenericApplicationPropertyOfWaterBoundarySurface(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }
}

