/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.common.base;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;

public class ModelObjects {
    public static <T extends Child> T setParent(T child, ModelObject parent) {
        if (child != null) {
            child.setParent(parent);
        }
        return child;
    }

    public static <T extends Child> List<T> setParent(List<T> child, ModelObject parent) {
        return child != null ? new ChildList<T>(parent, child) : null;
    }

    public static <T extends ModelObject> T setNull(T object) {
        if (object instanceof Child) {
            ((Child)object).unsetParent();
        }
        return null;
    }

    public static <T extends List<?>> T setNull(T list) {
        if (list instanceof ChildList) {
            ((ChildList)list).unsetParent();
        }
        return null;
    }

    public static boolean unsetProperty(ModelObject object, Object value) {
        if (object == null || value == null) {
            return false;
        }
        try {
            Class<?> clazz = object.getClass();
            boolean removed = false;
            do {
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object candidate = field.get(object);
                    if (candidate == null) continue;
                    if (candidate == value) {
                        field.set(object, null);
                        removed = true;
                        continue;
                    }
                    if (candidate instanceof Collection) {
                        removed = ((Collection)candidate).removeIf(o -> o == value);
                        if (!removed || !((Collection)candidate).isEmpty()) continue;
                        field.set(object, null);
                        continue;
                    }
                    if (candidate instanceof Map) {
                        removed = ((Map)candidate).entrySet().removeIf(e -> e.getValue() == value);
                        if (!removed || !((Map)candidate).isEmpty()) continue;
                        field.set(object, null);
                        continue;
                    }
                    if (!candidate.getClass().isArray()) continue;
                    for (int i = 0; i < Array.getLength(candidate); ++i) {
                        if (Array.get(candidate, i) != value) continue;
                        Array.set(candidate, i, null);
                        removed = true;
                    }
                }
            } while (!removed && (clazz = clazz.getSuperclass()) != null);
            return removed;
        }
        catch (Throwable e2) {
            return false;
        }
    }
}

