/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.common.child;

import java.util.ArrayList;
import java.util.Collection;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.child.Child;

public class ChildList<T extends Child>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private ModelObject parent;

    public ChildList(ModelObject parent) {
        this.parent = parent;
    }

    public ChildList(ModelObject parent, Collection<? extends T> c) {
        super(c);
        this.parent = parent;
        for (Child child : this) {
            if (child == null) continue;
            child.setParent(parent);
        }
    }

    public ChildList(ModelObject parent, int initialCapacity) {
        super(initialCapacity);
        this.parent = parent;
    }

    @Override
    public void add(int index, T element) {
        if (element != null) {
            element.setParent(this.parent);
        }
        super.add(index, element);
    }

    @Override
    public boolean add(T o) {
        if (o != null) {
            o.setParent(this.parent);
        }
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Child child : c) {
            if (child == null) continue;
            child.setParent(this.parent);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (Child child : c) {
            if (child == null) continue;
            child.setParent(this.parent);
        }
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        this.unsetParent();
        super.clear();
    }

    public void unsetParent() {
        for (Child child : this) {
            if (child == null) continue;
            child.unsetParent();
        }
    }

    @Override
    public T remove(int index) {
        Child child = (Child)super.remove(index);
        if (child != null) {
            child.unsetParent();
        }
        return (T)child;
    }

    @Override
    public boolean remove(Object o) {
        int index = super.indexOf(o);
        if (index == -1) {
            return false;
        }
        Child child = (Child)super.get(index);
        if (child != null) {
            child.unsetParent();
        }
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Child child : this) {
            if (child == null || !c.contains(child)) continue;
            child.unsetParent();
        }
        return super.removeAll(c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int index = fromIndex; index < toIndex; ++index) {
            Child child = (Child)super.get(index);
            if (child == null) continue;
            child.unsetParent();
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (Child child : this) {
            if (child == null || c.contains(child)) continue;
            child.unsetParent();
        }
        return super.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        Child child = (Child)super.set(index, element);
        if (element != null) {
            element.setParent(this.parent);
        }
        if (child != null) {
            child.unsetParent();
        }
        return (T)child;
    }
}

