/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.base;

import java.util.List;

public interface CoordinateListProvider {
    public List<Double> toList3d();

    default public List<Double> toList3d(boolean reverse) {
        return !reverse ? this.toList3d() : CoordinateListProvider.reversedCoordinateList(this);
    }

    public static List<Double> reversedCoordinateList(CoordinateListProvider provider) {
        List<Double> coordinates = provider.toList3d();
        if (coordinates.size() % 3 != 0) {
            throw new IllegalArgumentException("The size of the posList must be a multiple of 3.");
        }
        int i = coordinates.size() - 3;
        for (int j = 0; j < coordinates.size() / 2; j += 3) {
            double x = coordinates.get(j);
            double y = coordinates.get(j + 1);
            double z = coordinates.get(j + 2);
            coordinates.set(j, coordinates.get(i));
            coordinates.set(j + 1, coordinates.get(i + 1));
            coordinates.set(j + 2, coordinates.get(i + 2));
            coordinates.set(i, x);
            coordinates.set(i + 1, y);
            coordinates.set(i + 2, z);
            i -= 3;
        }
        return coordinates;
    }
}

