/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.basicTypes;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.copy.Copyable;
import org.citygml4j.model.gml.GML;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.base.CoordinateListProvider;

public class Coordinates
implements GML,
Child,
Copyable,
CoordinateListProvider {
    private String value;
    private String decimal;
    private String cs;
    private String ts;
    private ModelObject parent;

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.COORDINATES;
    }

    public String getCs() {
        if (this.cs == null) {
            return ",";
        }
        return this.cs;
    }

    public String getDecimal() {
        if (this.decimal == null) {
            return ".";
        }
        return this.decimal;
    }

    public String getTs() {
        if (this.ts == null) {
            return " ";
        }
        return this.ts;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSetCs() {
        return this.cs != null;
    }

    public boolean isSetDecimal() {
        return this.decimal != null;
    }

    public boolean isSetTs() {
        return this.ts != null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setCs(String cs) {
        this.cs = cs;
    }

    public void setDecimal(String decimal) {
        this.decimal = decimal;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<Double> toList3d() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        boolean isValid = false;
        if (this.isSetValue()) {
            String coordinates = this.getValue();
            String decimal = this.prepareRegex(this.getDecimal());
            String cs = this.prepareRegex(this.getCs());
            String ts = this.prepareRegex(this.getTs());
            isValid = true;
            coordinates = coordinates.replaceAll("[\\t\\n\\r]+", ts);
            String[] tupels = coordinates.split(ts);
            for (int i = 0; i < tupels.length && isValid; ++i) {
                if (tupels[i] == null || tupels[i].length() == 0) continue;
                String[] coords = tupels[i].split(cs);
                ArrayList<Double> point = new ArrayList<Double>();
                for (int j = 0; j < coords.length && isValid; ++j) {
                    if (coords[j] != null && coords[j].trim().length() != 0) {
                        coords[j] = coords[j].replaceAll(decimal, ".");
                        try {
                            double result = Double.parseDouble(coords[j]);
                            point.add(result);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            isValid = false;
                            break;
                        }
                    }
                    isValid = false;
                }
                if (!isValid) continue;
                while (point.size() < 3) {
                    point.add(0.0);
                }
                tmp.addAll(point.subList(0, 3));
            }
        }
        if (!isValid || tmp.size() == 0) {
            tmp.clear();
        }
        return tmp;
    }

    public void unsetCs() {
        this.cs = null;
    }

    public void unsetDecimal() {
        this.decimal = null;
    }

    public void unsetTs() {
        this.ts = null;
    }

    public void unsetValue() {
        this.value = null;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Coordinates copy;
        Coordinates coordinates = copy = target == null ? new Coordinates() : (Coordinates)target;
        if (this.isSetValue()) {
            copy.setValue(copyBuilder.copy(this.value));
        }
        if (this.isSetDecimal()) {
            copy.setDecimal(copyBuilder.copy(this.decimal));
        }
        if (this.isSetCs()) {
            copy.setCs(copyBuilder.copy(this.cs));
        }
        if (this.isSetTs()) {
            copy.setTs(copyBuilder.copy(this.ts));
        }
        copy.unsetParent();
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Coordinates(), copyBuilder);
    }

    @Override
    public ModelObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ModelObject parent) {
        this.parent = parent;
    }

    @Override
    public boolean isSetParent() {
        return this.parent != null;
    }

    @Override
    public void unsetParent() {
        this.parent = null;
    }

    private String prepareRegex(String input) {
        StringBuilder buffer = new StringBuilder();
        for (char c : input.toCharArray()) {
            if ("+()^$.{}[]|\\".indexOf(c) != -1) {
                buffer.append('\\').append(c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

