/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.feature;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.LocationProperty;
import org.citygml4j.model.gml.feature.SpatialRepresentation;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractFeature
extends AbstractGML {
    private BoundingShape boundedBy;
    private LocationProperty location;
    private List<ADEGenericElement> genericADEElement;
    private Module module;

    public AbstractFeature() {
    }

    public AbstractFeature(Module module) {
        this.module = module;
    }

    public void addGenericADEElement(ADEGenericElement genericADEElement) {
        this.getGenericADEElement().add(genericADEElement);
    }

    public BoundingShape getBoundedBy() {
        return this.boundedBy;
    }

    public LocationProperty getLocation() {
        return this.location;
    }

    public List<ADEGenericElement> getGenericADEElement() {
        if (this.genericADEElement == null) {
            this.genericADEElement = new ChildList<ADEGenericElement>(this);
        }
        return this.genericADEElement;
    }

    public boolean isSetBoundedBy() {
        return this.boundedBy != null;
    }

    public boolean isSetLocation() {
        return this.location != null;
    }

    public boolean isSetGenericADEElement() {
        return this.genericADEElement != null && !this.genericADEElement.isEmpty();
    }

    public void setBoundedBy(BoundingShape boundingShape) {
        if (boundingShape == null || !boundingShape.isEmpty()) {
            this.boundedBy = ModelObjects.setParent(boundingShape, (ModelObject)this);
        }
    }

    public void setLocation(LocationProperty location) {
        this.location = ModelObjects.setParent(location, (ModelObject)this);
    }

    public void setGenericADEElement(List<ADEGenericElement> genericADEElement) {
        this.genericADEElement = new ChildList<ADEGenericElement>((ModelObject)this, genericADEElement);
    }

    public void unsetBoundedBy() {
        this.boundedBy = ModelObjects.setNull(this.boundedBy);
    }

    public void unsetLocation() {
        this.location = ModelObjects.setNull(this.location);
    }

    public void unsetGenericADEElement() {
        this.genericADEElement = ModelObjects.setNull(this.genericADEElement);
    }

    public boolean unsetGenericADEElement(ADEGenericElement genericADEElement) {
        return this.isSetGenericADEElement() && this.genericADEElement.remove(genericADEElement);
    }

    public boolean isSetModule() {
        return this.module != null;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.ABSTRACT_FEATURE;
    }

    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        return options.isUseExistingEnvelopes() && this.boundedBy != null && !this.boundedBy.isEmpty() ? this.boundedBy : new BoundingShape();
    }

    public SpatialRepresentation getSpatialRepresentation() {
        return SpatialRepresentation.emptyRepresentation();
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractFeature copy = (AbstractFeature)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetBoundedBy()) {
            copy.setBoundedBy((BoundingShape)copyBuilder.copy(this.boundedBy));
            if (copy.getBoundedBy() == this.boundedBy) {
                this.boundedBy.setParent(this);
            }
        }
        if (this.isSetLocation()) {
            copy.setLocation((LocationProperty)copyBuilder.copy(this.location));
            if (copy.getLocation() == this.location) {
                this.location.setParent(this);
            }
        }
        if (this.isSetGenericADEElement()) {
            for (ADEGenericElement part : this.genericADEElement) {
                ADEGenericElement copyPart = (ADEGenericElement)copyBuilder.copy(part);
                copy.addGenericADEElement(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    public abstract void accept(FeatureVisitor var1);

    public abstract <T> T accept(FeatureFunctor<T> var1);
}

