/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.base.AssociationByRepOrRef;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;

public class SpatialRepresentation {
    private static final SpatialRepresentation EMPTY_REPRESENTATION = new SpatialRepresentation();
    private Map<Integer, List<AssociationByRepOrRef<? extends AbstractGML>>> representations = new HashMap<Integer, List<AssociationByRepOrRef<? extends AbstractGML>>>();

    public static SpatialRepresentation emptyRepresentation() {
        return EMPTY_REPRESENTATION;
    }

    protected final void add(int lod, AssociationByRepOrRef<? extends AbstractGML> property) {
        if (property instanceof GeometryProperty || property instanceof ImplicitRepresentationProperty) {
            this.representations.computeIfAbsent(lod, k -> new ArrayList()).add(property);
        }
    }

    public void addRepresentation(AssociationByRepOrRef<? extends AbstractGML> property) {
        this.add(-1, property);
    }

    public void addRepresentation(GeometryProperty<? extends AbstractGeometry> property) {
        this.add(-1, property);
    }

    public void addRepresentation(ImplicitRepresentationProperty property) {
        this.add(-1, property);
    }

    protected boolean isSetRepresentation(int lod) {
        return this.representations.containsKey(lod);
    }

    public boolean hasRepresentations() {
        return !this.representations.isEmpty();
    }

    protected List<AssociationByRepOrRef<? extends AbstractGML>> getRepresentation(int lod) {
        return this.representations.getOrDefault(lod, Collections.emptyList());
    }

    public List<AssociationByRepOrRef<? extends AbstractGML>> getRepresentations() {
        return this.representations.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSetGeometry(int lod) {
        List<AssociationByRepOrRef<? extends AbstractGML>> representation = this.representations.get(lod);
        if (representation == null) return false;
        if (!representation.stream().anyMatch(GeometryProperty.class::isInstance)) return false;
        return true;
    }

    public boolean hasGeometries() {
        return this.representations.keySet().stream().anyMatch(this::isSetGeometry);
    }

    protected List<GeometryProperty<? extends AbstractGeometry>> getGeometry(int lod) {
        List<AssociationByRepOrRef<? extends AbstractGML>> representation = this.representations.get(lod);
        return representation != null ? representation.stream().filter(GeometryProperty.class::isInstance).map(p -> (GeometryProperty)p).collect(Collectors.toList()) : Collections.emptyList();
    }

    public List<GeometryProperty<? extends AbstractGeometry>> getGeometries() {
        return this.representations.values().stream().flatMap(Collection::stream).filter(GeometryProperty.class::isInstance).map(p -> (GeometryProperty)p).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSetImplicitGeometry(int lod) {
        List<AssociationByRepOrRef<? extends AbstractGML>> representation = this.representations.get(lod);
        if (representation == null) return false;
        if (!representation.stream().anyMatch(ImplicitRepresentationProperty.class::isInstance)) return false;
        return true;
    }

    public boolean hasImplicitGeometries() {
        return this.representations.keySet().stream().anyMatch(this::isSetImplicitGeometry);
    }

    protected List<ImplicitRepresentationProperty> getImplicitGeometry(int lod) {
        List<AssociationByRepOrRef<? extends AbstractGML>> representation = this.representations.get(lod);
        return representation != null ? representation.stream().filter(ImplicitRepresentationProperty.class::isInstance).map(p -> (ImplicitRepresentationProperty)p).collect(Collectors.toList()) : Collections.emptyList();
    }

    public List<ImplicitRepresentationProperty> getImplicitGeometries() {
        return this.representations.values().stream().flatMap(Collection::stream).filter(ImplicitRepresentationProperty.class::isInstance).map(p -> (ImplicitRepresentationProperty)p).collect(Collectors.toList());
    }

    protected List<Integer> getLods() {
        return this.representations.keySet().stream().filter(lod -> lod >= 0).collect(Collectors.toList());
    }
}

