/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryArrayProperty;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;

public class MultiGeometry
extends AbstractGeometricAggregate {
    private List<GeometryProperty<? extends AbstractGeometry>> geometryMember;
    private GeometryArrayProperty<? extends AbstractGeometry> geometryMembers;

    public MultiGeometry() {
    }

    public MultiGeometry(List<? extends AbstractGeometry> abstractGeometries) {
        for (AbstractGeometry abstractGeometry : abstractGeometries) {
            this.addGeometryMember(new GeometryProperty<AbstractGeometry>(abstractGeometry));
        }
    }

    public MultiGeometry(AbstractGeometry ... abstractGeometries) {
        this(Arrays.asList(abstractGeometries));
    }

    public void addGeometryMember(GeometryProperty<? extends AbstractGeometry> geometryMember) {
        this.getGeometryMember().add(geometryMember);
    }

    public List<GeometryProperty<? extends AbstractGeometry>> getGeometryMember() {
        if (this.geometryMember == null) {
            this.geometryMember = new ChildList<GeometryProperty<? extends AbstractGeometry>>(this);
        }
        return this.geometryMember;
    }

    public GeometryArrayProperty<? extends AbstractGeometry> getGeometryMembers() {
        return this.geometryMembers;
    }

    public boolean isSetGeometryMember() {
        return this.geometryMember != null && !this.geometryMember.isEmpty();
    }

    public boolean isSetGeometryMembers() {
        return this.geometryMembers != null;
    }

    public void setGeometryMember(List<GeometryProperty<? extends AbstractGeometry>> geometryMember) {
        this.geometryMember = new ChildList<GeometryProperty<? extends AbstractGeometry>>((ModelObject)this, geometryMember);
    }

    public void setGeometryMembers(GeometryArrayProperty<? extends AbstractGeometry> geometryMembers) {
        this.geometryMembers = ModelObjects.setParent(geometryMembers, (ModelObject)this);
    }

    public void unsetGeometryMember() {
        this.geometryMember = ModelObjects.setNull(this.geometryMember);
    }

    public boolean unsetGeometryMember(GeometryProperty<? extends AbstractGeometry> geometryMember) {
        return this.isSetGeometryMember() && this.geometryMember.remove(geometryMember);
    }

    public void unsetGeometryMembers() {
        this.geometryMembers = ModelObjects.setNull(this.geometryMembers);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        GeometryArrayProperty<? extends AbstractGeometry> geometryArrayProperty;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetGeometryMember()) {
            for (GeometryProperty<? extends AbstractGeometry> geometryProperty : this.getGeometryMember()) {
                if (!geometryProperty.isSetGeometry()) continue;
                bbox.update(geometryProperty.getGeometry().calcBoundingBox());
            }
        }
        if (this.isSetGeometryMembers() && (geometryArrayProperty = this.getGeometryMembers()).isSetGeometry()) {
            for (AbstractGeometry abstractGeometry : geometryArrayProperty.getGeometry()) {
                bbox.update(abstractGeometry.calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_GEOMETRY;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiGeometry(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiGeometry copy = target == null ? new MultiGeometry() : (MultiGeometry)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetGeometryMember()) {
            for (GeometryProperty<? extends AbstractGeometry> part : this.geometryMember) {
                GeometryProperty copyPart = (GeometryProperty)copyBuilder.copy(part);
                copy.addGeometryMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetGeometryMembers()) {
            copy.setGeometryMembers((GeometryArrayProperty)copyBuilder.copy(this.geometryMembers));
            if (copy.getGeometryMembers() == this.geometryMembers) {
                this.geometryMembers.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

