/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.Point;
import org.citygml4j.model.gml.geometry.primitives.PointArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;

public class MultiPoint
extends AbstractGeometricAggregate {
    private List<PointProperty> pointMember;
    private PointArrayProperty pointMembers;

    public MultiPoint() {
    }

    public MultiPoint(List<Point> points) {
        for (Point point : points) {
            this.addPointMember(new PointProperty(point));
        }
    }

    public MultiPoint(Point ... points) {
        this(Arrays.asList(points));
    }

    public void addPointMember(PointProperty pointMember) {
        this.getPointMember().add(pointMember);
    }

    public List<PointProperty> getPointMember() {
        if (this.pointMember == null) {
            this.pointMember = new ChildList<PointProperty>(this);
        }
        return this.pointMember;
    }

    public PointArrayProperty getPointMembers() {
        return this.pointMembers;
    }

    public boolean isSetPointMember() {
        return this.pointMember != null && !this.pointMember.isEmpty();
    }

    public boolean isSetPointMembers() {
        return this.pointMembers != null;
    }

    public void setPointMember(List<PointProperty> pointMember) {
        this.pointMember = new ChildList<PointProperty>((ModelObject)this, pointMember);
    }

    public void setPointMembers(PointArrayProperty pointMembers) {
        this.pointMembers = ModelObjects.setParent(pointMembers, (ModelObject)this);
    }

    public void unsetPointMember() {
        this.pointMember = ModelObjects.setNull(this.pointMember);
    }

    public boolean unsetPointMember(PointProperty pointMember) {
        return this.isSetPointMember() && this.pointMember.remove(pointMember);
    }

    public void unsetPointMembers() {
        this.pointMembers = ModelObjects.setNull(this.pointMembers);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        PointArrayProperty pointArrayProperty;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetPointMember()) {
            for (PointProperty pointProperty : this.getPointMember()) {
                if (!pointProperty.isSetPoint()) continue;
                bbox.update(pointProperty.getPoint().calcBoundingBox());
            }
        }
        if (this.isSetPointMembers() && (pointArrayProperty = this.getPointMembers()).isSetPoint()) {
            for (Point point : pointArrayProperty.getPoint()) {
                bbox.update(point.calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_POINT;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiPoint(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiPoint copy = target == null ? new MultiPoint() : (MultiPoint)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetPointMember()) {
            for (PointProperty part : this.pointMember) {
                PointProperty copyPart = (PointProperty)copyBuilder.copy(part);
                copy.addPointMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetPointMembers()) {
            copy.setPointMembers((PointArrayProperty)copyBuilder.copy(this.pointMembers));
            if (copy.getPointMembers() == this.pointMembers) {
                this.pointMembers.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

