/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.SurfaceArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;

public class MultiSurface
extends AbstractGeometricAggregate {
    private List<SurfaceProperty> surfaceMember;
    private SurfaceArrayProperty surfaceMembers;

    public MultiSurface() {
    }

    public MultiSurface(List<? extends AbstractSurface> abstractSurfaces) {
        for (AbstractSurface abstractSurface : abstractSurfaces) {
            this.addSurfaceMember(new SurfaceProperty(abstractSurface));
        }
    }

    public MultiSurface(AbstractSurface ... abstractSurfaces) {
        this(Arrays.asList(abstractSurfaces));
    }

    public void addSurfaceMember(SurfaceProperty surfaceMember) {
        this.getSurfaceMember().add(surfaceMember);
    }

    public List<SurfaceProperty> getSurfaceMember() {
        if (this.surfaceMember == null) {
            this.surfaceMember = new ChildList<SurfaceProperty>(this);
        }
        return this.surfaceMember;
    }

    public SurfaceArrayProperty getSurfaceMembers() {
        return this.surfaceMembers;
    }

    public boolean isSetSurfaceMember() {
        return this.surfaceMember != null && !this.surfaceMember.isEmpty();
    }

    public boolean isSetSurfaceMembers() {
        return this.surfaceMembers != null;
    }

    public void setSurfaceMember(List<SurfaceProperty> surfaceMember) {
        this.surfaceMember = new ChildList<SurfaceProperty>((ModelObject)this, surfaceMember);
    }

    public void setSurfaceMembers(SurfaceArrayProperty surfaceMembers) {
        this.surfaceMembers = ModelObjects.setParent(surfaceMembers, (ModelObject)this);
    }

    public void unsetSurfaceMember() {
        this.surfaceMember = ModelObjects.setNull(this.surfaceMember);
    }

    public boolean unsetSurfaceMember(SurfaceProperty surfaceMember) {
        return this.isSetSurfaceMember() && this.surfaceMember.remove(surfaceMember);
    }

    public void unsetSurfaceMembers() {
        this.surfaceMembers = ModelObjects.setNull(this.surfaceMembers);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        SurfaceArrayProperty surfaceArrayProperty;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetSurfaceMember()) {
            for (SurfaceProperty surfaceProperty : this.getSurfaceMember()) {
                if (!surfaceProperty.isSetSurface()) continue;
                bbox.update(surfaceProperty.getSurface().calcBoundingBox());
            }
        }
        if (this.isSetSurfaceMembers() && (surfaceArrayProperty = this.getSurfaceMembers()).isSetSurface()) {
            for (AbstractSurface abstractSurface : surfaceArrayProperty.getSurface()) {
                bbox.update(abstractSurface.calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_SURFACE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiSurface(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiSurface copy = target == null ? new MultiSurface() : (MultiSurface)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetSurfaceMember()) {
            for (SurfaceProperty part : this.surfaceMember) {
                SurfaceProperty copyPart = (SurfaceProperty)copyBuilder.copy(part);
                copy.addSurfaceMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetSurfaceMembers()) {
            copy.setSurfaceMembers((SurfaceArrayProperty)copyBuilder.copy(this.surfaceMembers));
            if (copy.getSurfaceMembers() == this.surfaceMembers) {
                this.surfaceMembers.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

