/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.complexes;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractSolid;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;

public class CompositeSolid
extends AbstractSolid {
    private List<SolidProperty> solidMember;

    public CompositeSolid() {
    }

    public CompositeSolid(List<? extends AbstractSolid> abstractSolids) {
        for (AbstractSolid abstractSolid : abstractSolids) {
            this.addSolidMember(new SolidProperty(abstractSolid));
        }
    }

    public CompositeSolid(AbstractSolid ... abstractSolids) {
        this(Arrays.asList(abstractSolids));
    }

    public void addSolidMember(SolidProperty solidMember) {
        this.getSolidMember().add(solidMember);
    }

    public List<SolidProperty> getSolidMember() {
        if (this.solidMember == null) {
            this.solidMember = new ChildList<SolidProperty>(this);
        }
        return this.solidMember;
    }

    public boolean isSetSolidMember() {
        return this.solidMember != null && !this.solidMember.isEmpty();
    }

    public void setSolidMember(List<SolidProperty> solidMember) {
        this.solidMember = new ChildList<SolidProperty>((ModelObject)this, solidMember);
    }

    public void unsetSolidMember() {
        this.solidMember = ModelObjects.setNull(this.solidMember);
    }

    public boolean unsetSolidMember(SolidProperty solidMember) {
        return this.isSetSolidMember() && this.solidMember.remove(solidMember);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetSolidMember()) {
            for (SolidProperty solidProperty : this.getSolidMember()) {
                if (!solidProperty.isSetSolid()) continue;
                bbox.update(solidProperty.getSolid().calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.COMPOSITE_SOLID;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new CompositeSolid(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CompositeSolid copy = target == null ? new CompositeSolid() : (CompositeSolid)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetSolidMember()) {
            for (SolidProperty part : this.solidMember) {
                SolidProperty copyPart = (SolidProperty)copyBuilder.copy(part);
                copy.addSolidMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

