/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.geometry.Point;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.copy.Copyable;
import org.citygml4j.model.gml.GML;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.basicTypes.Coordinates;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.geometry.SRSReferenceGroup;
import org.citygml4j.model.gml.geometry.primitives.Coord;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;

public class Envelope
implements SRSReferenceGroup,
Child,
Copyable {
    private DirectPosition lowerCorner;
    private DirectPosition upperCorner;
    private List<Coord> coord;
    private List<DirectPosition> pos;
    private Coordinates coordinates;
    private Integer srsDimension;
    private String srsName;
    private List<String> axisLabels;
    private List<String> uomLabels;
    private ModelObject parent;

    public Envelope() {
    }

    public Envelope(BoundingBox boundingBox) {
        if (boundingBox != null && !boundingBox.isNull()) {
            this.setLowerCorner(boundingBox.getLowerCorner());
            this.setUpperCorner(boundingBox.getUpperCorner());
            this.setSrsDimension(3);
        }
    }

    public void addCoord(Coord coord) {
        this.getCoord().add(coord);
    }

    public void addPos(DirectPosition pos) {
        this.getPos().add(pos);
    }

    public List<Coord> getCoord() {
        if (this.coord == null) {
            this.coord = new ChildList<Coord>(this);
        }
        return this.coord;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public DirectPosition getLowerCorner() {
        return this.lowerCorner;
    }

    public List<DirectPosition> getPos() {
        if (this.pos == null) {
            this.pos = new ChildList<DirectPosition>(this);
        }
        return this.pos;
    }

    public DirectPosition getUpperCorner() {
        return this.upperCorner;
    }

    public boolean isSetCoord() {
        return this.coord != null && !this.coord.isEmpty();
    }

    public boolean isSetCoordinates() {
        return this.coordinates != null;
    }

    public boolean isSetLowerCorner() {
        return this.lowerCorner != null && this.lowerCorner.isSetValue();
    }

    public boolean isSetPos() {
        return this.pos != null && !this.pos.isEmpty();
    }

    public boolean isSetUpperCorner() {
        return this.upperCorner != null && this.upperCorner.isSetValue();
    }

    public void setCoord(List<Coord> coord) {
        this.coord = new ChildList<Coord>((ModelObject)this, coord);
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = ModelObjects.setParent(coordinates, (ModelObject)this);
    }

    public void setLowerCorner(DirectPosition lowerCorner) {
        this.lowerCorner = ModelObjects.setParent(lowerCorner, (ModelObject)this);
    }

    public void setLowerCorner(Point lowerCorner) {
        if (lowerCorner != null) {
            if (!this.isSetLowerCorner()) {
                this.setLowerCorner(new DirectPosition());
            } else {
                this.lowerCorner.unsetValue();
            }
            this.lowerCorner.addValue(lowerCorner.getX());
            this.lowerCorner.addValue(lowerCorner.getY());
            this.lowerCorner.addValue(lowerCorner.getZ());
        }
    }

    public void setPos(List<DirectPosition> pos) {
        this.pos = new ChildList<DirectPosition>((ModelObject)this, pos);
    }

    public void setUpperCorner(DirectPosition upperCorner) {
        this.upperCorner = ModelObjects.setParent(upperCorner, (ModelObject)this);
    }

    public void setUpperCorner(Point upperCorner) {
        if (upperCorner != null) {
            if (!this.isSetUpperCorner()) {
                this.setUpperCorner(new DirectPosition());
            } else {
                this.upperCorner.unsetValue();
            }
            this.upperCorner.addValue(upperCorner.getX());
            this.upperCorner.addValue(upperCorner.getY());
            this.upperCorner.addValue(upperCorner.getZ());
        }
    }

    public void unsetCoord() {
        this.coord = ModelObjects.setNull(this.coord);
    }

    public boolean unsetCoord(Coord coord) {
        return this.isSetCoord() && this.coord.remove(coord);
    }

    public void unsetCoordinates() {
        this.coordinates = ModelObjects.setNull(this.coordinates);
    }

    public void unsetLowerCorner() {
        this.lowerCorner = ModelObjects.setNull(this.lowerCorner);
    }

    public void unsetPos() {
        this.pos = ModelObjects.setNull(this.pos);
    }

    public boolean unsetPos(DirectPosition pos) {
        return this.isSetPos() && this.pos.remove(pos);
    }

    public void unsetUpperCorner() {
        this.upperCorner = ModelObjects.setNull(this.upperCorner);
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.ENVELOPE;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public String getInheritedSrsName() {
        if (this.srsName == null) {
            ModelObject parent;
            Child child = this;
            while ((parent = child.getParent()) != null) {
                AbstractFeature feature;
                if (parent instanceof AbstractFeature && (feature = (AbstractFeature)parent).isSetBoundedBy() && feature.getBoundedBy().isSetEnvelope() && feature.getBoundedBy().getEnvelope().isSetSrsName()) {
                    return feature.getBoundedBy().getEnvelope().getSrsName();
                }
                if (!(parent instanceof Child)) break;
                child = (Child)parent;
            }
        }
        return this.srsName;
    }

    @Override
    public boolean isSetSrsDimension() {
        return this.srsDimension != null;
    }

    @Override
    public boolean isSetSrsName() {
        return this.srsName != null;
    }

    @Override
    public void setSrsDimension(Integer srsDimension) {
        if (srsDimension > 0) {
            this.srsDimension = srsDimension;
        }
    }

    @Override
    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    @Override
    public void unsetSrsDimension() {
        this.srsDimension = null;
    }

    @Override
    public void unsetSrsName() {
        this.srsName = null;
    }

    @Override
    public void addAxisLabel(String axisLabel) {
        this.getAxisLabels().add(axisLabel);
    }

    @Override
    public void addUomLabel(String uomLabel) {
        this.getUomLabels().add(uomLabel);
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.axisLabels != null && !this.axisLabels.isEmpty();
    }

    @Override
    public boolean isSetUomLabels() {
        return this.uomLabels != null && !this.uomLabels.isEmpty();
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        this.axisLabels = axisLabels;
    }

    @Override
    public void setUomLabels(List<String> uomLabels) {
        this.uomLabels = uomLabels;
    }

    @Override
    public void unsetAxisLabels() {
        this.axisLabels = null;
    }

    @Override
    public boolean unsetAxisLabels(String axisLabel) {
        return this.isSetAxisLabels() && this.axisLabels.remove(axisLabel);
    }

    @Override
    public void unsetUomLabels() {
        this.uomLabels = null;
    }

    @Override
    public boolean unsetUomLabels(String uomLabel) {
        return this.isSetUomLabels() && this.uomLabels.remove(uomLabel);
    }

    @Override
    public ModelObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ModelObject parent) {
        this.parent = parent;
    }

    @Override
    public boolean isSetParent() {
        return this.parent != null;
    }

    @Override
    public void unsetParent() {
        this.parent = null;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Envelope(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        GML copyPart;
        Envelope copy;
        Envelope envelope = copy = target == null ? new Envelope() : (Envelope)target;
        if (this.isSetLowerCorner()) {
            copy.setLowerCorner((DirectPosition)copyBuilder.copy(this.lowerCorner));
            if (copy.getLowerCorner() == this.lowerCorner) {
                this.lowerCorner.setParent(this);
            }
        }
        if (this.isSetUpperCorner()) {
            copy.setUpperCorner((DirectPosition)copyBuilder.copy(this.upperCorner));
            if (copy.getUpperCorner() == this.upperCorner) {
                this.upperCorner.setParent(this);
            }
        }
        if (this.isSetCoord()) {
            for (Coord coord : this.coord) {
                copyPart = (Coord)copyBuilder.copy(coord);
                copy.addCoord((Coord)copyPart);
                if (coord == null || copyPart != coord) continue;
                coord.setParent(this);
            }
        }
        if (this.isSetPos()) {
            for (DirectPosition directPosition : this.pos) {
                copyPart = (DirectPosition)copyBuilder.copy(directPosition);
                copy.addPos((DirectPosition)copyPart);
                if (directPosition == null || copyPart != directPosition) continue;
                directPosition.setParent(this);
            }
        }
        if (this.isSetCoordinates()) {
            copy.setCoordinates((Coordinates)copyBuilder.copy(this.coordinates));
            if (copy.getCoordinates() == this.coordinates) {
                this.coordinates.setParent(this);
            }
        }
        if (this.isSetSrsDimension()) {
            copy.setSrsDimension((Integer)copyBuilder.copy(this.srsDimension));
        }
        if (this.isSetSrsName()) {
            copy.setSrsName(copyBuilder.copy(this.srsName));
        }
        if (this.isSetAxisLabels()) {
            copy.setAxisLabels((List)copyBuilder.copy(this.axisLabels));
        }
        if (this.isSetUomLabels()) {
            copy.setUomLabels((List)copyBuilder.copy(this.uomLabels));
        }
        copy.unsetParent();
        return copy;
    }

    public boolean isNull() {
        return this.toBoundingBox().isNull();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        if (boundingBox != null && !boundingBox.isNull()) {
            this.setLowerCorner(boundingBox.getLowerCorner());
            this.setUpperCorner(boundingBox.getUpperCorner());
            this.setSrsDimension(3);
            this.unsetPos();
            this.unsetCoord();
            this.unsetCoordinates();
        }
    }

    public void update(BoundingBox boundingBox) {
        BoundingBox bbox = this.toBoundingBox();
        bbox.update(boundingBox);
        this.setBoundingBox(bbox);
    }

    public Envelope convert3d() {
        return new Envelope(this.toBoundingBox());
    }

    public BoundingBox toBoundingBox() {
        Iterator<Coord> value;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetLowerCorner()) {
            value = this.lowerCorner.toList3d();
            bbox.setLowerCorner(value.get(0), (Double)value.get(1), (Double)value.get(2));
        }
        if (this.isSetUpperCorner()) {
            value = this.upperCorner.toList3d();
            bbox.setUpperCorner(value.get(0), (Double)value.get(1), (Double)value.get(2));
        }
        if (this.isSetPos()) {
            for (DirectPosition directPosition : this.pos) {
                if (!directPosition.isSetValue()) continue;
                List<Double> value2 = directPosition.toList3d();
                bbox.update(value2.get(0), value2.get(1), value2.get(2));
            }
        }
        if (this.isSetCoord()) {
            for (Coord coord : this.coord) {
                if (!coord.isSetX() || !coord.isSetY()) continue;
                bbox.update(coord.getX(), coord.getY(), coord.isSetZ() ? coord.getZ() : 0.0);
            }
        }
        if (this.isSetCoordinates()) {
            List<Double> coordinates = this.coordinates.toList3d();
            for (int i = 0; i < coordinates.size(); i += 3) {
                bbox.update(coordinates.get(i), coordinates.get(i + 1), coordinates.get(i + 2));
            }
        }
        return bbox;
    }
}

