/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GML;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.basicTypes.Coordinates;
import org.citygml4j.model.gml.geometry.primitives.AbstractRing;
import org.citygml4j.model.gml.geometry.primitives.Coord;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;
import org.citygml4j.model.gml.geometry.primitives.DirectPositionList;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.PointRep;
import org.citygml4j.model.gml.geometry.primitives.PosOrPointPropertyOrPointRep;

public class LinearRing
extends AbstractRing {
    private List<PosOrPointPropertyOrPointRep> controlPoints;
    private DirectPositionList posList;
    private Coordinates coordinates;
    private List<Coord> coord;

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.LINEAR_RING;
    }

    public void addCoord(Coord coord) {
        this.getCoord().add(coord);
    }

    public void addPointProperty(PointProperty pointProperty) {
        this.getPosOrPointPropertyOrPointRep().add(new PosOrPointPropertyOrPointRep(pointProperty));
    }

    public void addPointRep(PointRep pointRep) {
        this.getPosOrPointPropertyOrPointRep().add(new PosOrPointPropertyOrPointRep(pointRep));
    }

    public void addPos(DirectPosition pos) {
        this.getPosOrPointPropertyOrPointRep().add(new PosOrPointPropertyOrPointRep(pos));
    }

    public void addControlPoint(PosOrPointPropertyOrPointRep controlPoint) {
        this.getPosOrPointPropertyOrPointRep().add(controlPoint);
    }

    public List<Coord> getCoord() {
        if (this.coord == null) {
            this.coord = new ChildList<Coord>(this);
        }
        return this.coord;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public DirectPositionList getPosList() {
        return this.posList;
    }

    public List<PosOrPointPropertyOrPointRep> getPosOrPointPropertyOrPointRep() {
        if (this.controlPoints == null) {
            this.controlPoints = new ChildList<PosOrPointPropertyOrPointRep>(this);
        }
        return this.controlPoints;
    }

    public boolean isSetCoord() {
        return this.coord != null && !this.coord.isEmpty();
    }

    public boolean isSetCoordinates() {
        return this.coordinates != null;
    }

    public boolean isSetPosList() {
        return this.posList != null;
    }

    public boolean isSetPosOrPointPropertyOrPointRep() {
        return this.controlPoints != null && !this.controlPoints.isEmpty();
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = ModelObjects.setParent(coordinates, (ModelObject)this);
    }

    public void setPosList(DirectPositionList posList) {
        this.posList = ModelObjects.setParent(posList, (ModelObject)this);
    }

    public void setCoord(List<Coord> coord) {
        this.coord = new ChildList<Coord>((ModelObject)this, coord);
    }

    public void setPosOrPointPropertyOrPointRep(List<PosOrPointPropertyOrPointRep> controlPoints) {
        this.controlPoints = new ChildList<PosOrPointPropertyOrPointRep>((ModelObject)this, controlPoints);
    }

    @Override
    public List<Double> toList3d() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        if (this.isSetPosList()) {
            tmp.addAll(this.posList.toList3d());
        }
        if (this.isSetPosOrPointPropertyOrPointRep()) {
            for (PosOrPointPropertyOrPointRep controlPoint : this.controlPoints) {
                tmp.addAll(controlPoint.toList3d());
            }
        }
        if (this.isSetCoord()) {
            for (Coord value : this.coord) {
                tmp.addAll(value.toList3d());
            }
        }
        if (this.isSetCoordinates()) {
            tmp.addAll(this.coordinates.toList3d());
        }
        return tmp;
    }

    public void unsetCoord() {
        this.coord = ModelObjects.setNull(this.coord);
    }

    public void unsetCoordinates() {
        this.coordinates = ModelObjects.setNull(this.coordinates);
    }

    public boolean unsetPosOrPointPropertyOrPointRep(PosOrPointPropertyOrPointRep controlPoint) {
        return this.isSetPosOrPointPropertyOrPointRep() && this.controlPoints.remove(controlPoint);
    }

    public boolean unsetPointProperty(PointProperty pointProperty) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRep()) {
            Iterator<PosOrPointPropertyOrPointRep> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRep controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPointProperty().equals(pointProperty)) continue;
                iter.remove();
                success = true;
            }
        }
        return success;
    }

    public boolean unsetPointRep(PointRep pointRep) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRep()) {
            Iterator<PosOrPointPropertyOrPointRep> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRep controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPointRep().equals(pointRep)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    public boolean unsetPos(DirectPosition pos) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRep()) {
            Iterator<PosOrPointPropertyOrPointRep> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRep controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPos().equals(pos)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    public void unsetPosList() {
        this.posList = ModelObjects.setNull(this.posList);
    }

    public void unsetPosOrPointPropertyOrPointRep() {
        this.controlPoints = ModelObjects.setNull(this.controlPoints);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        GML copyPart;
        LinearRing copy = target == null ? new LinearRing() : (LinearRing)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetPosOrPointPropertyOrPointRep()) {
            for (PosOrPointPropertyOrPointRep posOrPointPropertyOrPointRep : this.controlPoints) {
                copyPart = (PosOrPointPropertyOrPointRep)copyBuilder.copy(posOrPointPropertyOrPointRep);
                copy.addControlPoint((PosOrPointPropertyOrPointRep)copyPart);
                if (posOrPointPropertyOrPointRep == null || copyPart != posOrPointPropertyOrPointRep) continue;
                posOrPointPropertyOrPointRep.setParent(this);
            }
        }
        if (this.isSetPosList()) {
            copy.setPosList((DirectPositionList)copyBuilder.copy(this.posList));
            if (copy.getPosList() == this.posList) {
                this.posList.setParent(this);
            }
        }
        if (this.isSetCoordinates()) {
            copy.setCoordinates((Coordinates)copyBuilder.copy(this.coordinates));
            if (copy.getCoordinates() == this.coordinates) {
                this.coordinates.setParent(this);
            }
        }
        if (this.isSetCoord()) {
            for (Coord coord : this.coord) {
                copyPart = (Coord)copyBuilder.copy(coord);
                copy.addCoord((Coord)copyPart);
                if (coord == null || copyPart != coord) continue;
                coord.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new LinearRing(), copyBuilder);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

