/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.CurveProperty;
import org.citygml4j.model.gml.geometry.primitives.Sign;

public class OrientableCurve
extends AbstractCurve {
    private CurveProperty baseCurve;
    private Sign orientation;

    public OrientableCurve() {
    }

    public OrientableCurve(AbstractCurve base, Sign orientation) {
        this.setBaseCurve(new CurveProperty(base));
        this.setOrientation(orientation);
    }

    public OrientableCurve(String xlink, Sign orientation) {
        this.setBaseCurve(new CurveProperty(xlink));
        this.setOrientation(orientation);
    }

    public CurveProperty getBaseCurve() {
        return this.baseCurve;
    }

    public Sign getOrientation() {
        return this.orientation == null ? Sign.PLUS : this.orientation;
    }

    public boolean isSetBaseCurve() {
        return this.baseCurve != null;
    }

    public boolean isSetOrientation() {
        return this.orientation != null;
    }

    public void setBaseCurve(CurveProperty baseCurve) {
        this.baseCurve = ModelObjects.setParent(baseCurve, (ModelObject)this);
    }

    public void setOrientation(Sign orientation) {
        this.orientation = orientation;
    }

    public void unsetBaseCurve() {
        this.baseCurve = ModelObjects.setNull(this.baseCurve);
    }

    public void unsetOrientation() {
        this.orientation = null;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.ORIENTABLE_CURVE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new OrientableCurve(), copyBuilder);
    }

    @Override
    public List<Double> toList3d() {
        return this.isSetBaseCurve() && this.baseCurve.isSetCurve() ? this.baseCurve.getCurve().toList3d(this.getOrientation() == Sign.MINUS) : new ArrayList<Double>();
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        OrientableCurve copy = target == null ? new OrientableCurve() : (OrientableCurve)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetBaseCurve()) {
            copy.setBaseCurve((CurveProperty)copyBuilder.copy(this.baseCurve));
            if (copy.getBaseCurve() == this.baseCurve) {
                this.baseCurve.setParent(this);
            }
        }
        if (this.isSetOrientation()) {
            copy.setOrientation((Sign)copyBuilder.copy(this.orientation));
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

