/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.Sign;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;

public class OrientableSurface
extends AbstractSurface {
    private SurfaceProperty baseSurface;
    private Sign orientation;

    public OrientableSurface() {
    }

    public OrientableSurface(AbstractSurface base, Sign orientation) {
        this.setBaseSurface(new SurfaceProperty(base));
        this.setOrientation(orientation);
    }

    public OrientableSurface(String xlink, Sign orientation) {
        this.setBaseSurface(new SurfaceProperty(xlink));
        this.setOrientation(orientation);
    }

    public SurfaceProperty getBaseSurface() {
        return this.baseSurface;
    }

    public Sign getOrientation() {
        return this.orientation == null ? Sign.PLUS : this.orientation;
    }

    public boolean isSetBaseSurface() {
        return this.baseSurface != null;
    }

    public boolean isSetOrientation() {
        return this.orientation != null;
    }

    public void setBaseSurface(SurfaceProperty baseSurface) {
        this.baseSurface = ModelObjects.setParent(baseSurface, (ModelObject)this);
    }

    public void setOrientation(Sign orientation) {
        this.orientation = orientation;
    }

    public void unsetBaseSurface() {
        this.baseSurface = ModelObjects.setNull(this.baseSurface);
    }

    public void unsetOrientation() {
        this.orientation = null;
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetBaseSurface() && this.baseSurface.isSetSurface()) {
            bbox.update(this.baseSurface.getSurface().calcBoundingBox());
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.ORIENTABLE_SURFACE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new OrientableSurface(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        OrientableSurface copy = target == null ? new OrientableSurface() : (OrientableSurface)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetBaseSurface()) {
            copy.setBaseSurface((SurfaceProperty)copyBuilder.copy(this.baseSurface));
            if (copy.getBaseSurface() == this.baseSurface) {
                this.baseSurface.setParent(this);
            }
        }
        if (this.isSetOrientation()) {
            copy.setOrientation((Sign)copyBuilder.copy(this.orientation));
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

