/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractRingProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;

public class Polygon
extends AbstractSurface {
    private AbstractRingProperty exterior;
    private List<AbstractRingProperty> interior;

    public void addInterior(AbstractRingProperty abstractRingProperty) {
        this.getInterior().add(abstractRingProperty);
    }

    public AbstractRingProperty getExterior() {
        return this.exterior;
    }

    public List<AbstractRingProperty> getInterior() {
        if (this.interior == null) {
            this.interior = new ChildList<AbstractRingProperty>(this);
        }
        return this.interior;
    }

    public boolean isSetExterior() {
        return this.exterior != null;
    }

    public boolean isSetInterior() {
        return this.interior != null && !this.interior.isEmpty();
    }

    public void setExterior(AbstractRingProperty abstractRingProperty) {
        this.exterior = ModelObjects.setParent(abstractRingProperty, (ModelObject)this);
    }

    public void setInterior(List<AbstractRingProperty> abstractRingProperty) {
        this.interior = new ChildList<AbstractRingProperty>((ModelObject)this, abstractRingProperty);
    }

    public void unsetExterior() {
        this.exterior = ModelObjects.setNull(this.exterior);
    }

    public void unsetInterior() {
        this.interior = ModelObjects.setNull(this.interior);
    }

    public boolean unsetInterior(AbstractRingProperty abstractRingProperty) {
        return this.isSetInterior() && this.interior.remove(abstractRingProperty);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetExterior() && this.exterior.isSetRing()) {
            bbox.update(this.exterior.getRing().calcBoundingBox());
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.POLYGON;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Polygon(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Polygon copy = target == null ? new Polygon() : (Polygon)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetExterior()) {
            copy.setExterior((AbstractRingProperty)copyBuilder.copy(this.exterior));
            if (copy.getExterior() == this.exterior) {
                this.exterior.setParent(this);
            }
        }
        if (this.isSetInterior()) {
            for (AbstractRingProperty part : this.interior) {
                AbstractRingProperty copyPart = (AbstractRingProperty)copyBuilder.copy(part);
                copy.addInterior(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

