/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.primitives.AbstractSolid;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;

public class Solid
extends AbstractSolid {
    private SurfaceProperty exterior;
    private List<SurfaceProperty> interior;

    public void addInterior(SurfaceProperty interior) {
        this.getInterior().add(interior);
    }

    public SurfaceProperty getExterior() {
        return this.exterior;
    }

    public List<SurfaceProperty> getInterior() {
        if (this.interior == null) {
            this.interior = new ChildList<SurfaceProperty>(this);
        }
        return this.interior;
    }

    public boolean isSetExterior() {
        return this.exterior != null;
    }

    public boolean isSetInterior() {
        return this.interior != null && !this.interior.isEmpty();
    }

    public void setExterior(SurfaceProperty exterior) {
        this.exterior = ModelObjects.setParent(exterior, (ModelObject)this);
    }

    public void setInterior(List<SurfaceProperty> interior) {
        this.interior = new ChildList<SurfaceProperty>((ModelObject)this, interior);
    }

    public void unsetExterior() {
        this.exterior = ModelObjects.setNull(this.exterior);
    }

    public void unsetInterior() {
        this.interior = ModelObjects.setNull(this.interior);
    }

    public boolean unsetInterior(SurfaceProperty interior) {
        return this.isSetInterior() && this.interior.remove(interior);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        SurfaceProperty exterior;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetExterior() && (exterior = this.getExterior()).isSetSurface()) {
            bbox.update(exterior.getSurface().calcBoundingBox());
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.SOLID;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Solid(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Solid copy = target == null ? new Solid() : (Solid)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetExterior()) {
            copy.setExterior((SurfaceProperty)copyBuilder.copy(this.exterior));
            if (copy.getExterior() == this.exterior) {
                this.exterior.setParent(this);
            }
        }
        if (this.isSetInterior()) {
            for (SurfaceProperty part : this.interior) {
                SurfaceProperty copyPart = (SurfaceProperty)copyBuilder.copy(part);
                copy.addInterior(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

